# Aspose.OMR for Cloud

[Aspose.OMR for Cloud](https://products.aspose.cloud/omr/cloud) is a REST API that helps you to perform optical mark recognition in the cloud. We provide a series of [SDKs](https://github.com/aspose-omr-cloud). Along with that, you can get [binaries](https://github.com/aspose-omr-cloud/aspose-omr-cloud-dotnet/releases) to start working immediately and recognize various OMR forms.

Developers can embed [optical recognition](https://en.wikipedia.org/wiki/Optical_mark_recognition) in any type of application to extract data from images of tests, exams, questionnaires, surveys, etc. In the repository you can find examples on how to start using [Aspose.OMR API](https://docs.aspose.cloud/display/omrcloud/OMR+API+Specification) in your project.

## Quickstart

You can perform tasks out of the box without writing a single line of code with our [GUI client](https://github.com/aspose-omr-cloud/aspose-omr-cloud-dotnet/releases). You can also refer to the [client documentation](https://docs.aspose.cloud/display/omrcloud/Aspose.OMR.Client+Application).

## Using OMR Cloud API in your Perl projects

This Perl package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.1
- Build package: io.swagger.codegen.languages.PerlClientCodegen

## Requirements

You nee to install Log::Any, URI::Query, Date::Parse packages
```
ppm install Log::Any URI::Query Date::Parse
```

## Installation

- Clone https://github.com/aspose-omr-cloud/aspose-omr-cloud-perl.git

## Optional requirements

To take full advantage of Aspose.OMR for Cloud, _AsposeStorageCloud-StorageApi_ is required. Just run `ppm install AsposeStorageCloud-StorageApi`.

## Usage
### Receive Cloud Keys
Aspose.Cloud credentials are required to use Aspose.OMR for Cloud API. You can acquire App SID and App Key by registrating at [Aspose Cloud Dashboard](https://dashboard.aspose.cloud). It will take only a couple of minutes.

### To load the API packages:
```perl
use asposeomrcloud::OmrApi;

```

To load the models:
```perl
use asposeomrcloud::Object::AsposeResponse;
use asposeomrcloud::Object::FileInfo;
use asposeomrcloud::Object::OMRFunctionParam;
use asposeomrcloud::Object::OMRResponseDetails;
use asposeomrcloud::Object::OmrResponseContent;
use asposeomrcloud::Object::OmrResponseInfo;
use asposeomrcloud::Object::Payload;
use asposeomrcloud::Object::RecognitionStatistics;
use asposeomrcloud::Object::ServerStat;
use asposeomrcloud::Object::OMRResponse;

````

### Code example
You can check out [OMR Demo](demo) project to get started with Aspose.OMR for Cloud.


## Documentation for API endpoints

All URIs are relative to *https://api.aspose.cloud/v1.1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*OmrApi* | [**post_run_omr_task**](docs/OmrApi.md#post_run_omr_task) | **POST** /omr/{name}/runOmrTask | Run specific OMR task


## Documentation for models
 - [asposeomrcloud::Object::AsposeResponse](docs/AsposeResponse.md)
 - [asposeomrcloud::Object::FileInfo](docs/FileInfo.md)
 - [asposeomrcloud::Object::OMRFunctionParam](docs/OMRFunctionParam.md)
 - [asposeomrcloud::Object::OMRResponseDetails](docs/OMRResponseDetails.md)
 - [asposeomrcloud::Object::OmrResponseContent](docs/OmrResponseContent.md)
 - [asposeomrcloud::Object::OmrResponseInfo](docs/OmrResponseInfo.md)
 - [asposeomrcloud::Object::Payload](docs/Payload.md)
 - [asposeomrcloud::Object::RecognitionStatistics](docs/RecognitionStatistics.md)
 - [asposeomrcloud::Object::ServerStat](docs/ServerStat.md)
 - [asposeomrcloud::Object::OMRResponse](docs/OMRResponse.md)


## Authentication

Library uses OAUTH2 internally

## Author

Aspose Pty Ltd (https://www.aspose.com)


