=begin comment

Copyright (c) 2018 Aspose Pty Ltd. All Rights Reserved.

Licensed under the MIT (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

      https://github.com/aspose-omr-cloud/aspose-omr-cloud-perl/blob/master/LICENSE

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.



Aspose.OMR for Cloud API Reference

Aspose.OMR for Cloud helps performing optical mark recognition in the cloud

OpenAPI spec version: 1.1

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package asposeomrcloud::ApiFactory;

use strict;
use warnings;
use utf8;

use Carp;
use Module::Find;

usesub asposeomrcloud::Object;

use asposeomrcloud::ApiClient;

=head1 Name

	asposeomrcloud::ApiFactory - constructs APIs to retrieve asposeomrcloud objects

=head1 Synopsis

	package My::Petstore::App;
	
	use asposeomrcloud::ApiFactory;
	
	my $api_factory = asposeomrcloud::ApiFactory->new( ... ); # any args for ApiClient constructor
							  
	# later...
	my $pet_api = $api_factory->get_api('Pet');  
	
	# $pet_api isa asposeomrcloud::PetApi
	
	my $pet = $pet_api->get_pet_by_id(pet_id => $pet_id);
	
	# object attributes have proper accessors:
	printf "Pet's name is %s", $pet->name;
	
	# change the value stored on the object:
	$pet->name('Dave'); 

=cut

# Load all the API classes and construct a lookup table at startup time
my %_apis = map { $_ =~ /^asposeomrcloud::(.*)$/; $1 => $_ } 
			grep {$_ =~ /Api$/} 
			usesub 'asposeomrcloud';

=head1 new($api_client)
	
	create a new asposeomrcloud::ApiFactory instance with the given asposeomrcloud::ApiClient instance.

=head1 new(%paramters)

	Any parameters are optional, and are passed to and stored on the api_client object.
	
	See L<asposeomrcloud::ApiClient> and L<asposeomrcloud::Configuration> for valid paramters

=cut	

sub new {
    my ($class) = shift;

    my $api_client;
    if ($_[0] && ref $_[0] && ref $_[0] eq 'asposeomrcloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = asposeomrcloud::ApiClient->new(@_);
    }
    bless { api_client => $api_client }, $class;
}

=head1 get_api($which)

	Returns an API object of the requested type. 
	
	$which is a nickname for the class: 
	
		FooBarClient::BazApi has nickname 'Baz'
		
=cut

sub get_api {
	my ($self, $which) = @_;
	croak "API not specified" unless $which;
	my $api_class = $_apis{"${which}Api"} || croak "No known API for '$which'";
	return $api_class->new($self->api_client); 
}

=head1 api_client()

	Returns the api_client object, should you ever need it.
	
=cut

sub api_client { $_[0]->{api_client} }

=head1 apis_available()
=cut 

sub apis_available { return map { $_ =~ s/Api$//; $_ } sort keys %_apis }

=head1 classname_for()
=cut

sub classname_for {
	my ($self, $api_name) = @_;
	return $_apis{"${api_name}Api"};
}


1;
