=begin comment

Web API Swagger specification

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: 1.0

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package AsposeCellsCloud::CellsPropertiesApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeCellsCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeCellsCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeCellsCloud::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# cells_properties_delete_document_properties
#
# Delete all custom document properties and clean built-in ones.
# 
# @param string $name The document name. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_properties_delete_document_properties' } = { 
    	summary => 'Delete all custom document properties and clean built-in ones.',
        params => $params,
        returns => 'CellsDocumentPropertiesResponse',
        };
}
# @return CellsDocumentPropertiesResponse
#
sub cells_properties_delete_document_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_properties_delete_document_properties");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/documentproperties';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsDocumentPropertiesResponse', $response);
    return $_response_object;
}

#
# cells_properties_delete_document_property
#
# Delete document property.
# 
# @param string $name The document name. (required)
# @param string $property_name The property name. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'property_name' => {
        data_type => 'string',
        description => 'The property name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_properties_delete_document_property' } = { 
    	summary => 'Delete document property.',
        params => $params,
        returns => 'CellsDocumentPropertiesResponse',
        };
}
# @return CellsDocumentPropertiesResponse
#
sub cells_properties_delete_document_property {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_properties_delete_document_property");
    }

    # verify the required parameter 'property_name' is set
    unless (exists $args{'property_name'}) {
      croak("Missing the required parameter 'property_name' when calling cells_properties_delete_document_property");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/documentproperties/{propertyName}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'property_name'}) {
        my $_base_variable = "{" . "propertyName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'property_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsDocumentPropertiesResponse', $response);
    return $_response_object;
}

#
# cells_properties_get_document_properties
#
# Read document properties.
# 
# @param string $name The document name. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_properties_get_document_properties' } = { 
    	summary => 'Read document properties.',
        params => $params,
        returns => 'CellsDocumentPropertiesResponse',
        };
}
# @return CellsDocumentPropertiesResponse
#
sub cells_properties_get_document_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_properties_get_document_properties");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/documentproperties';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsDocumentPropertiesResponse', $response);
    return $_response_object;
}

#
# cells_properties_get_document_property
#
# Read document property by name.
# 
# @param string $name The document name. (required)
# @param string $property_name The property name. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'property_name' => {
        data_type => 'string',
        description => 'The property name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_properties_get_document_property' } = { 
    	summary => 'Read document property by name.',
        params => $params,
        returns => 'CellsDocumentPropertyResponse',
        };
}
# @return CellsDocumentPropertyResponse
#
sub cells_properties_get_document_property {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_properties_get_document_property");
    }

    # verify the required parameter 'property_name' is set
    unless (exists $args{'property_name'}) {
      croak("Missing the required parameter 'property_name' when calling cells_properties_get_document_property");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/documentproperties/{propertyName}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'property_name'}) {
        my $_base_variable = "{" . "propertyName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'property_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsDocumentPropertyResponse', $response);
    return $_response_object;
}

#
# cells_properties_put_document_property
#
# Set/create document property.
# 
# @param string $name The document name. (required)
# @param string $property_name The property name. (required)
# @param CellsDocumentProperty $property with new property value. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'property_name' => {
        data_type => 'string',
        description => 'The property name.',
        required => '1',
    },
    'property' => {
        data_type => 'CellsDocumentProperty',
        description => 'with new property value.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_properties_put_document_property' } = { 
    	summary => 'Set/create document property.',
        params => $params,
        returns => 'CellsDocumentPropertyResponse',
        };
}
# @return CellsDocumentPropertyResponse
#
sub cells_properties_put_document_property {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_properties_put_document_property");
    }

    # verify the required parameter 'property_name' is set
    unless (exists $args{'property_name'}) {
      croak("Missing the required parameter 'property_name' when calling cells_properties_put_document_property");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/documentproperties/{propertyName}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'property_name'}) {
        my $_base_variable = "{" . "propertyName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'property_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'property'}) {
        $_body_data = $args{'property'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsDocumentPropertyResponse', $response);
    return $_response_object;
}

1;
