package OpenInteract::SQLInstall::Theme;

# $Id: Theme.pm,v 1.4 2002/05/02 12:21:09 lachoy Exp $

# Do installation of SQL for this package

use strict;
use vars qw( %HANDLERS );
use base qw( OpenInteract::SQLInstall );

my @SEQUENCES = ( 'theme_sequence.sql', 'theme_prop_sequence.sql' );
my @TABLES    = ( 'theme.sql', 'theme_prop.sql' );

my %files = (
  tables        => [ @TABLES ],
  tables_oracle => [ 'theme_oracle.sql', 'theme_prop_oracle.sql', @SEQUENCES ],
  tables_pg     => [ @TABLES, @SEQUENCES ],
  tables_ib     => [ 'theme_interbase.sql', 'theme_generator.sql',
                     'theme_prop_interbase.sql', 'theme_prop_generator.sql' ],
  data          => [ 'install_theme.dat', 'install_theme_prop.dat' ],
  security      => [ 'install_security.dat' ],
);

%HANDLERS = (
  create_structure => { '_default_' => [ 'create_structure',
                                         { table_file_list => $files{tables} } ],
                        'Oracle'    => [ 'create_structure',
                                         { table_file_list => $files{tables_oracle} } ],
                        'Pg'        => [ 'create_structure',
                                         { table_file_list => $files{tables_pg} } ],
                        'InterBase' => [ 'create_structure',
                                         { table_file_list => $files{tables_ib} } ],
  },
  install_data     => { '_default_' => [ 'install_data',
                                         { data_file_list => $files{data} } ] },
  install_security => { '_default_' => [ 'install_data',
                                         { data_file_list => $files{security} } ] },
);

1;
