
use strict;
use warnings;



use ExtUtils::MakeMaker 6.31;



my %WriteMakefileArgs = (
  'ABSTRACT' => 'A pure perl BibTeX parser',
  'AUTHOR' => 'Gerhard Gossen <gerhard.gossen@googlemail.com>',
  'BUILD_REQUIRES' => {
    'Test::More' => '0.88'
  },
  'CONFIGURE_REQUIRES' => {
    'ExtUtils::MakeMaker' => '6.31'
  },
  'DISTNAME' => 'BibTeX-Parser',
  'EXE_FILES' => [],
  'LICENSE' => 'perl',
  'NAME' => 'BibTeX::Parser',
  'PREREQ_PM' => {
    'File::Spec' => '0',
    'IO::File' => '0',
    'IO::String' => '0',
    'LaTeX::ToUnicode' => '0.02',
    'Test::More' => '0'
  },
  'VERSION' => '0.62',
  'test' => {
    'TESTS' => 't/*.t'
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



