package App::Manoc::Controller::VlanRange;
#ABSTRACT: VlanRange controller
use Moose;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use namespace::autoclean;

BEGIN { extends 'Catalyst::Controller'; }
with
    "App::Manoc::ControllerRole::CommonCRUD",
    "App::Manoc::ControllerRole::JSONView";

use App::Manoc::Form::VlanRange;
use App::Manoc::Form::VlanRange::Merge;
use App::Manoc::Form::VlanRange::Split;

BEGIN { extends 'Catalyst::Controller'; }

__PACKAGE__->config(
    # define PathPart
    action => {
        setup => {
            PathPart => 'vlanrange',
        }
    },
    class                   => 'ManocDB::VlanRange',
    form_class              => 'App::Manoc::Form::VlanRange',
    enable_permission_check => 1,
    view_object_perm        => undef,
    json_columns            => [qw(id name description)],
    object_list             => {
        order_by => [ 'start', 'vlans.id' ],
        prefetch => 'vlans',
        join     => 'vlans',
    }
);


sub split : Chained('object') : PathPart('split') : Args(0) {
    my ( $self, $c ) = @_;

    $c->require_permission( $c->stash->{object}, 'edit' );

    my $form = App::Manoc::Form::VlanRange::Split->new( { ctx => $c } );

    $c->stash(
        form   => $form,
        action => $c->uri_for( $c->action, $c->req->captures ),
    );
    return unless $form->process(
        item   => $c->stash->{object},
        params => $c->req->parameters,
    );

    $c->response->redirect( $c->uri_for_action('vlanrange/list') );
    $c->detach();
}


sub merge : Chained('object') : PathPart('merge') : Args(0) {
    my ( $self, $c ) = @_;

    $c->require_permission( $c->stash->{object}, 'edit' );

    my $form = App::Manoc::Form::VlanRange::Merge->new( { ctx => $c } );

    $c->stash(
        form   => $form,
        action => $c->uri_for( $c->action, $c->req->captures ),
    );
    return unless $form->process(
        item   => $c->stash->{object},
        params => $c->req->parameters,
    );

    $c->response->redirect( $c->uri_for_action('vlanrange/list') );
    $c->detach();
}


sub delete_object {

    my ( $self, $c ) = @_;
    my $range = $c->stash->{'object'};
    my $id    = $range->id;
    my $name  = $range->name;

    if ( $range->vlans->count() ) {
        $c->flash( error_msg => "There are vlans in vlan range '$name'. Cannot delete it." );
        return;
    }

    return $range->delete;
}


sub get_form_success_url {
    my ( $self, $c ) = @_;

    return $c->uri_for_action( $c->namespace . "/list" );
}


sub get_delete_failure_url {
    my ( $self, $c ) = @_;

    return $c->uri_for_action( $c->namespace . "/list" );
}

__PACKAGE__->meta->make_immutable;

1;

__END__

=pod

=head1 NAME

App::Manoc::Controller::VlanRange - VlanRange controller

=head1 VERSION

version 2.99.2

=head1 ACTIONS

=head2 split

=head2 merge

=head1 METHODS

=head2 delete_object

=head2 get_form_success_url

=head2 get_delete_failure_url

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
