package SNMP::Insight::MIB::UCD;

#ABSTRACT: Support for data in UCD MIB

use Moose::Role;

use SNMP::Insight::Moose::MIB;
use namespace::autoclean;

our $VERSION = '0.001';    #TRIAL VERSION:

with 'SNMP::Insight::MIB';

# See http://www.net-snmp.org/docs/mibs/UCD-SNMP-MIB.txt

# { enterprises 2021 }
mib_oid ".1.3.6.1.4.1.2021";
mib_name "UCD-SNMP-MIB";

has_scalar memTotalSwap => ( oid => '4.3' );
has_scalar memAvailSwap => ( oid => '4.4' );
has_scalar memTotalReal => ( oid => '4.5' );
has_scalar memAvailReal => ( oid => '4.6' );

has_table prTable => (
    oid     => '2',
    index   => 'prIndex',
    columns => {
        prIndex => 1,
        prNames => 2,
        prMin   => 3,
        prMax   => 4,
        prCount => 5,
    }
);

has_table dskTable => (
    oid     => '9',
    index   => 'dskIndex',
    columns => {
        dskIndex       => 1,
        dskPath        => 2,
        dskDevice      => 3,
        dskMinimum     => 4,
        dskMinPercent  => 5,
        dskTotal       => 6,
        dskAvail       => 7,
        dskUsed        => 8,
        dskPercent     => 9,
        dskPercentNode => 10
    },
);

1;

# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

SNMP::Insight::MIB::UCD - Support for data in UCD MIB

=head1 VERSION

version 0.001

=head1 AUTHOR

Gabriele Mambrini <g.mambrini@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
