# Unit tests for WARC::Index::Entry module			# -*- CPerl -*-

use strict;
use warnings;

use Test::More tests => 3;
BEGIN { use_ok('WARC::Index::Entry')
	  or BAIL_OUT "WARC::Index::Entry failed to load" }

BEGIN {
  my $fail = 0;
  eval q{use WARC::Index::Entry v9999.1.2.3; $fail = 1};
  ok($fail == 0
     && $@ =~ m/WARC.* version v9999.*required--this is only version/,
     'WARC::Index::Entry version check')
}

my $fail = 0;

{
  my $entry = bless {}, 'WARC::Index::Entry'; # make a fake object
  $fail = 0;

  eval { $entry->distance(bogus => 1); $fail = 1 };
  ok($fail == 0 && $@ =~ m/abstract base class/,
     'distance in base class dies');
}
