use strict;
use warnings;

use Test::More tests => 133;

use DateTime::TimeZone::Alias;

my @good_offsets = (
    [ '1000',       '+10:00:00' ],
    [ '100001',     '+10:00:01' ],
    [ '10:0002',    '+10:00:02' ],
    [ '1000:03',    '+10:00:03' ],
    [ '10:00:04',   '+10:00:04' ],
    [ '+0000',      '+00:00:00' ],
    [ '+000001',    '+00:00:01' ],
    [ '+00:0002',   '+00:00:02' ],
    [ '+0000:03',   '+00:00:03' ],
    [ '+00:00:04',  '+00:00:04' ],
    [ '-0000',      '-00:00:00' ],
    [ '-000001',    '-00:00:01' ],
    [ '-00:0002',   '-00:00:02' ],
    [ '-0000:03',   '-00:00:03' ],
    [ '-00:00:04',  '-00:00:04' ],
    [ '+9999',      '+99:99:00' ],
    [ '+999999',    '+99:99:99' ],
    [ '+99:9998',   '+99:99:98' ],
    [ '+9999:97',   '+99:99:97' ],
    [ '+99:99:96',  '+99:99:96' ],
    [ '-9999',      '-99:99:00' ],
    [ '-999999',    '-99:99:99' ],
    [ '-99:9998',   '-99:99:98' ],
    [ '-9999:97',   '-99:99:97' ],
    [ '-99:99:96',  '-99:99:96' ],
);

my @bad_offsets = (
    '1', '+1', '-1',
    '1:', '+1:', '-1:',
    ':1', '+:1', '-:1',
    '11', '+11', '-11',
    '11:', '+11:', '-11:',
    '1:1', '+1:1', '-1:1',
    ':11', '+:11', '-:11',
    #'111', '+111', '-111',
    '111:', '+111:', '-111:',
    '11:1', '+11:1', '-11:1',
    #'1:11', '+1:11', '-1:11',
    ':111', '+:111', '-:111',
    ':11:1', '+:11:1', '-:11:1',
    '1:11:', '+1:11:', '-1:11:',
    '1111:', '+1111:', '-1111:',
    '111:1', '+111:1', '-111:1',
    '1:111', '+1:111', '-1:111',
    ':1111', '+:1111', '-:1111',
    ':11:11', '+:11:11', '-:11:11',
    '1:11:1', '+1:11:1', '-1:11:1',
    '11:11:', '+11:11:', '-11:11:',
    #'11111', '+11111', '-11111',
    '11111:', '+11111:', '-11111:',
    '1111:1', '+1111:1', '-1111:1',
    #'111:11', '+111:11', '-111:11',
    '11:111', '+11:111', '-11:111',
    #'1:1111', '+1:1111', '-1:1111',
    ':11111', '+:11111', '-:11111',
    ':11:111', '+:11:111', '-:11:111',
    #'1:11:11', '+1:11:11', '-1:11:11',
    '11:11:1', '+11:11:1', '-11:11:1',
    '111:11:', '+111:11:', '-111:11:',
    '111111:', '+111111:', '-111111:',
    '11111:1', '+11111:1', '-11111:1',
    #'1111:11', '+1111:11', '-1111:11',
    '111:111', '+111:111', '-111:111',
    #'11:1111', '+11:1111', '-11:1111',
    '1:11111', '+1:11111', '-1:11111',
    ':111111', '+:111111', '-:111111',
    ':11:1111', '+:11:1111', '-:11:1111',
    '1:11:111', '+1:11:111', '-1:11:111',
    '111:11:1', '+111:11:1', '-111:11:1',
    '1111:11:', '+1111:11:', '-1111:11:',
    '1111111', '+1111111', '-1111111',
);

foreach ( @good_offsets ) {
    DateTime::TimeZone::Alias->set( test => $_->[0] );
    is( DateTime::TimeZone::Alias->value( 'test' ), $_->[1] );
}

foreach ( @bad_offsets ) {
    eval{ DateTime::TimeZone::Alias->set( test => $_ ) };
    like( $@, qr/Aliases must point to a valid timezone/ );
}
