# Generated by default/object.tt
package Paws::SageMaker::ModelDeployConfig;
  use Moose;
  has AutoGenerateEndpointName => (is => 'ro', isa => 'Bool');
  has EndpointName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ModelDeployConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ModelDeployConfig object:

  $service_obj->Method(Att1 => { AutoGenerateEndpointName => $value, ..., EndpointName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ModelDeployConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->AutoGenerateEndpointName

=head1 DESCRIPTION

Specifies how to generate the endpoint name for an automatic one-click
Autopilot model deployment.

=head1 ATTRIBUTES


=head2 AutoGenerateEndpointName => Bool

Set to C<True> to automatically generate an endpoint name for a
one-click Autopilot model deployment; set to C<False> otherwise. The
default value is C<False>.

If you set C<AutoGenerateEndpointName> to C<True>, do not specify the
C<EndpointName>; otherwise a 400 error is thrown.


=head2 EndpointName => Str

Specifies the endpoint name to use for a one-click Autopilot model
deployment if the endpoint name is not generated automatically.

Specify the C<EndpointName> if and only if you set
C<AutoGenerateEndpointName> to C<False>; otherwise a 400 error is
thrown.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

