/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.Extractor;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Function;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractTreeExtractor<T>
implements Extractor<T> {
    protected final Options op;

    protected AbstractTreeExtractor(Options op) {
        this.op = op;
    }

    protected void tallyLeaf(Tree lt, double weight2) {
    }

    protected void tallyPreTerminal(Tree lt, double weight2) {
    }

    protected void tallyInternalNode(Tree lt, double weight2) {
    }

    protected void tallyRoot(Tree lt, double weight2) {
    }

    public T formResult() {
        return null;
    }

    protected void tallyLocalTree(Tree lt, double weight2) {
        if (lt.isLeaf()) {
            this.tallyLeaf(lt, weight2);
        } else if (lt.isPreTerminal()) {
            this.tallyPreTerminal(lt, weight2);
        } else {
            this.tallyInternalNode(lt, weight2);
        }
    }

    public void tallyTree(Tree t, double weight2) {
        this.tallyRoot(t, weight2);
        for (Tree localTree : t.subTreeList()) {
            this.tallyLocalTree(localTree, weight2);
        }
    }

    protected void tallyTrees(Collection<Tree> trees, double weight2) {
        for (Tree tree : trees) {
            this.tallyTree(tree, weight2);
        }
    }

    protected void tallyTreeIterator(Iterator<Tree> treeIterator, Function<Tree, Tree> f, double weight2) {
        while (treeIterator.hasNext()) {
            Tree tree;
            block3: {
                tree = treeIterator.next();
                try {
                    tree = f.apply(tree);
                }
                catch (Exception e) {
                    if (!this.op.testOptions.verbose) break block3;
                    e.printStackTrace();
                }
            }
            this.tallyTree(tree, weight2);
        }
    }

    public T extract() {
        return this.formResult();
    }

    @Override
    public T extract(Collection<Tree> treeList) {
        this.tallyTrees(treeList, 1.0);
        return this.formResult();
    }

    public T extract(Collection<Tree> trees1, double weight1, Collection<Tree> trees2, double weight2) {
        this.tallyTrees(trees1, weight1);
        this.tallyTrees(trees2, weight2);
        return this.formResult();
    }

    public T extract(Iterator<Tree> treeIterator, Function<Tree, Tree> f, double weight2) {
        this.tallyTreeIterator(treeIterator, f, weight2);
        return this.formResult();
    }

    @Override
    public T extract(Iterator<Tree> iterator, Function<Tree, Tree> f) {
        return this.extract(iterator, f, 1.0);
    }
}

