/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.Timing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class POSTaggerAnnotator
implements Annotator {
    private final MaxentTagger pos;
    private int maxSentenceLength;

    public POSTaggerAnnotator() {
        this(true);
    }

    public POSTaggerAnnotator(boolean verbose) {
        this(System.getProperty("pos.model", MaxentTagger.DEFAULT_NLP_GROUP_MODEL_PATH), verbose);
    }

    public POSTaggerAnnotator(String posLoc, boolean verbose) {
        this(posLoc, verbose, Integer.MAX_VALUE);
    }

    public POSTaggerAnnotator(String posLoc, boolean verbose, int maxSentenceLength) {
        this(POSTaggerAnnotator.loadModel(posLoc, verbose), maxSentenceLength);
    }

    public POSTaggerAnnotator(MaxentTagger model) {
        this(model, Integer.MAX_VALUE);
    }

    public POSTaggerAnnotator(MaxentTagger model, int maxSentenceLength) {
        this.pos = model;
        this.maxSentenceLength = maxSentenceLength;
    }

    public POSTaggerAnnotator(String annotatorName, Properties props) {
        String posLoc = props.getProperty(annotatorName + ".model");
        if (posLoc == null) {
            throw new IllegalArgumentException("No model specified for POS tagger annotator " + annotatorName);
        }
        boolean verbose = PropertiesUtils.getBool(props, annotatorName + ".verbose", true);
        this.pos = POSTaggerAnnotator.loadModel(posLoc, verbose);
        this.maxSentenceLength = PropertiesUtils.getInt(props, annotatorName + ".maxlen", Integer.MAX_VALUE);
    }

    public void setMaxSentenceLength(int maxLen) {
        this.maxSentenceLength = maxLen;
    }

    private static MaxentTagger loadModel(String loc, boolean verbose) {
        MaxentTagger tagger;
        Timing timer = null;
        if (verbose) {
            timer = new Timing();
            timer.doing("Loading POS Model [" + loc + ']');
        }
        try {
            tagger = new MaxentTagger(loc);
        }
        catch (IOException e) {
            RuntimeException runtimeException = new RuntimeException(e);
            throw runtimeException;
        }
        catch (ClassNotFoundException e) {
            RuntimeException runtimeException = new RuntimeException(e);
            throw runtimeException;
        }
        if (verbose) {
            timer.done();
        }
        return tagger;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (annotation.has(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                ArrayList<TaggedWord> tagged = this.pos.apply(tokens);
                for (int i = 0; i < tokens.size(); ++i) {
                    ((CoreLabel)tokens.get(i)).set(CoreAnnotations.PartOfSpeechAnnotation.class, ((TaggedWord)tagged.get(i)).tag());
                }
            }
        } else {
            throw new RuntimeException("unable to find words/tokens in: " + annotation);
        }
    }

    public List<? extends CoreLabel> processText(List<? extends CoreLabel> text) {
        if (text.size() > this.maxSentenceLength) {
            return this.processTextLargerThanMaxLen(text);
        }
        ArrayList<TaggedWord> tagged = this.pos.apply((List<? extends HasWord>)new ArrayList<CoreLabel>(text));
        Iterator taggedIter = tagged.iterator();
        for (CoreLabel coreLabel : text) {
            TaggedWord cur = (TaggedWord)taggedIter.next();
            coreLabel.setTag(cur.tag());
        }
        return text;
    }

    private List<? extends CoreLabel> processTextLargerThanMaxLen(List<? extends CoreLabel> text) {
        int startIndx = 0;
        int endIndx = startIndx + this.maxSentenceLength < text.size() ? startIndx + this.maxSentenceLength : text.size();
        while (true) {
            System.out.println(startIndx + "\t" + endIndx);
            List<? extends CoreLabel> textToTag = text.subList(startIndx, endIndx);
            ArrayList<TaggedWord> tagged = this.pos.apply(textToTag);
            Iterator taggedIter = tagged.iterator();
            for (CoreLabel coreLabel : textToTag) {
                TaggedWord cur = (TaggedWord)taggedIter.next();
                coreLabel.setTag(cur.tag());
            }
            if (startIndx + this.maxSentenceLength >= text.size()) break;
            endIndx = (startIndx += this.maxSentenceLength) + this.maxSentenceLength < text.size() ? startIndx + this.maxSentenceLength : text.size();
        }
        return text;
    }
}

