#!perl -T

use Test::More tests => 21;

use Net::validMX;

sub test {
  my ($email) = @_;
  my ($rv, $reason);

  ($rv, $reason) = &Net::validMX::check_valid_mx($email);
  print &Net::validMX::get_output_result($email, $rv, $reason);
 
  return $rv;
}

sub test_params {
  my (%params) = @_;

  my ($rv, $reason);

  ($rv, $reason) = &Net::validMX::check_valid_mx(%params);
  print &Net::validMX::get_output_result($params{'email'}, $rv, $reason);

  return $rv;
}

is( test('kevin.mcgrail@peregrinehw.com'), 1, 'Test for correct DNS - Should Pass');

is( test('test@test13.peregrinehw.com'), 1, 'Test non-rfc compliant DNS using cname for MX - Should Pass');

is( test('test@test14.peregrinehw.com'), 1, 'Test for implicit MX by A record - Should Pass');

#REMOVED BECAUSE IT RELIES ON BAD CONFIGURATION TO PERSIST ON A DOMAIN OUTSIDE OUR DEVELOPMENT CONTROL
#is( test('AirchieChalmers@londo.cysticercus.com'), 1, 'Test for something that was throwing an error in v1 where we need to discard the first answer on a CNAME domain - Should Pass');

#REMOVED BECAUSE IT RELIES ON BAD CONFIGURATION TO PERSIST ON A DOMAIN OUTSIDE OUR DEVELOPMENT CONTROL
#is( test('OlgaCraft@barbequesauceofthemonthclub.com'), 1, 'Test for something that was throwing an error in v1 where we need to discard the first answer on a CNAME domain - Should Pass');

is( test('test@test.peregrinehw.com'), 1, 'Test for the use of crazy things like 12.34.56.78. as the host name in DNS - Should Pass if $allow_ip_address_as_mx = 1');

# Top-level MX records generally deprecated and even prohibited in the
# new gTLDs.  The Vatican does no longer have an MX record for its
# ccTLD, but this still exists for .tt for example.
#is( test('thepope@va'), 1, 'Test for unusual top level domain setups like .va for the Vatican');

is( test('test@test6.peregrinehw.com'), 1, 'Test for a host that is configured with an MX of . but eventually has a good MX recorded (due to eNom.com (name-services.com) false positives - Should Pass');

is( test('test@test7.peregrinehw.com'), 1, 'Test for DNS where MX1 is private, MX2 is private but MX3 is a valid internet address');

is( test_params(email=>'test@test7.peregrinehw.com'), 1, 'Testing overloaded call with hash parameters');

is( test('test@test15.peregrinehw.com'), 1, 'Test for DNS where MX record is IPv6 AAAA record');

#THANKS TO Kelson Vibber FOR INFORMATION AND EXAMPLES TO TEST VERP AND SRS
# 1. Addresses generated by VERP schemes on mailing lists.
#Most of them include a variation on this pattern in the LHS:
#
#(recip LHS)=(recip domain)
#
#2. Addresses rewritten by SRS on POBoxes server.  They seem to use this 
#pattern:
#
#SRS0=(4-character key)=(2-character key)=(recip domain)=(recip LHS)

#VERP
is( test('announce-return-162-mysql=speed.net@peregrinehw.com'), 1, 'Test for VERP Record');
is( test('cygwin-announce-return-547-test=speed.net@peregrinehw.com'), 1, 'Test for VERP Record');
is( test('kde-announce-bounces-+test=pobox.com@peregrinehw.com'), 1, 'Test for VERP Record');
is( test('ntf-461_30-12033835-TEST_=_POBOX.COM@peregrinehw.com'), 1, 'Test for VERP Record');
is( test('openssh-unix-announce-bounces+test=pobox.com@peregrinehw.com'), 1, 'Test for VERP Record');
is( test('sentto-1020166-167-1020161999-test=pobox.com@peregrinehw.com'), 1, 'Test for VERP Record');
is( test('users-return-14779-test=test.net@peregrinehw.com'), 1, 'Test for VERP Record');

#SRS
is( test('bounce+test#aol.com-7eDsxRQ4JXXF5=test#pobox.com@peregrinehw.com'), 1, 'Test for SRS Record');
is( test('SRS0=coi/=X6=mandriva.org=return@peregrinehw.com'), 1, 'Test for SRS Record');
is( test('SRS0=oktk=QO=speed.net=test@peregrinehw.com'), 1, 'Test for SRS Record');
is( test('SRS0=pr+A=5A=evite.com=info@peregrinehw.com'), 1, 'Test for SRS Record');
is( test('SRS0=yY6Q=5F=deepdiscountdvdpromotions.com=offers@peregrinehw.com'), 1, 'Test for SRS Record');

#VERP and SRS!
is( test('SRS0=R+JI=42=returns.groups.yahoo.com=sentto-3977489-5630-1141374659-kelson=pobox.com@peregrinehw.com'), 1, 'Test for SRS & VERP');

