#!/bin/bash

. "$(dirname "$0")"/config.sh

cd "$dump_dir"

for layer in ${layers[@]}; do
    for script in "${layer}__init.sh"; do
	if [ $syntax = 'postgres' ]; then
  	  bash "$script" -u "$user" -d "$db" -h "$db_host" -p "$db_port"
	elif [ $syntax = 'oracle' ]; then
  	  bash "$script" -u "$user" -d "$db" -h "$db_host" -p "$db_port" -w "$password"
	fi 
    done 2>&1 | tee "$base_dir/db_load_${layer}.log"
done

[ -n "$config_cleanup" ] && eval "$config_cleanup"
