BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( Carp Exporter Module::Load base experimental lib strict utf8 warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.026; 1}) {
    print "Perl 5.026 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.79.
use strict;
use warnings;
use 5.026;
use ExtUtils::MakeMaker;
use File::ShareDir::Install;

$File::ShareDir::Install::INCLUDE_DOTFILES = 1;
$File::ShareDir::Install::INCLUDE_DOTDIRS  = 1;
install_share dist => "share";

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Check spelling of POD and other documents",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker"     => 0,
    "File::ShareDir::Install" => "0.06"
  },
  "DISTNAME"  => "Test-SpellCheck",
  "EXE_FILES" => [
    "bin/spellcheck"
  ],
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.026",
  "NAME"             => "Test::SpellCheck",
  "PM"               => {
    "lib/Test/SpellCheck.pm"                          => "\$(INST_LIB)/Test/SpellCheck.pm",
    "lib/Test/SpellCheck/INI.pm"                      => "\$(INST_LIB)/Test/SpellCheck/INI.pm",
    "lib/Test/SpellCheck/Plugin.pm"                   => "\$(INST_LIB)/Test/SpellCheck/Plugin.pm",
    "lib/Test/SpellCheck/Plugin/Combo.pm"             => "\$(INST_LIB)/Test/SpellCheck/Plugin/Combo.pm",
    "lib/Test/SpellCheck/Plugin/Dictionary.pm"        => "\$(INST_LIB)/Test/SpellCheck/Plugin/Dictionary.pm",
    "lib/Test/SpellCheck/Plugin/Perl.pm"              => "\$(INST_LIB)/Test/SpellCheck/Plugin/Perl.pm",
    "lib/Test/SpellCheck/Plugin/PerlComment.pm"       => "\$(INST_LIB)/Test/SpellCheck/Plugin/PerlComment.pm",
    "lib/Test/SpellCheck/Plugin/PerlPOD.pm"           => "\$(INST_LIB)/Test/SpellCheck/Plugin/PerlPOD.pm",
    "lib/Test/SpellCheck/Plugin/PerlWords.pm"         => "\$(INST_LIB)/Test/SpellCheck/Plugin/PerlWords.pm",
    "lib/Test/SpellCheck/Plugin/PrimaryDictionary.pm" => "\$(INST_LIB)/Test/SpellCheck/Plugin/PrimaryDictionary.pm",
    "lib/Test/SpellCheck/Plugin/StopWords.pm"         => "\$(INST_LIB)/Test/SpellCheck/Plugin/StopWords.pm"
  },
  "PREREQ_PM" => {
    "Config::INI::Reader"                    => 0,
    "File::Globstar"                         => 0,
    "File::ShareDir::Dist"                   => 0,
    "List::Util"                             => "1.29",
    "PPI"                                    => 0,
    "PPI::Document"                          => 0,
    "PPIx::DocumentName"                     => "1.00",
    "Path::Tiny"                             => "0.130",
    "PerlX::Maybe"                           => "0.003",
    "Pod::Simple::Words"                     => 0,
    "Ref::Util"                              => 0,
    "Test2::API"                             => "1.302015",
    "Test2::V0"                              => "0.000121",
    "Test::SpellCheck::Plugin::Lang::EN::US" => 0,
    "Text::HumanComputerWords"               => "0.02",
    "Text::Hunspell::FFI"                    => "0.04",
    "URI"                                    => 0
  },
  "TEST_REQUIRES" => {
    "File::chdir"  => 0,
    "Test::Script" => 0
  },
  "VERSION" => "0.02",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Config::INI::Reader"                    => 0,
  "File::Globstar"                         => 0,
  "File::ShareDir::Dist"                   => 0,
  "File::chdir"                            => 0,
  "List::Util"                             => "1.29",
  "PPI"                                    => 0,
  "PPI::Document"                          => 0,
  "PPIx::DocumentName"                     => "1.00",
  "Path::Tiny"                             => "0.130",
  "PerlX::Maybe"                           => "0.003",
  "Pod::Simple::Words"                     => 0,
  "Ref::Util"                              => 0,
  "Test2::API"                             => "1.302015",
  "Test2::V0"                              => "0.000121",
  "Test::Script"                           => 0,
  "Test::SpellCheck::Plugin::Lang::EN::US" => 0,
  "Text::HumanComputerWords"               => "0.02",
  "Text::Hunspell::FFI"                    => "0.04",
  "URI"                                    => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

{
  package
    MY;
  use File::ShareDir::Install qw(postamble);
}