# NAME

WebService::ILS - Standardised library discovery/circulation services

# SYNOPSIS

    use WebService::ILS::<Provider Subclass>;
    my $ils = WebService::ILS::<Provider Subclass>->new({
        client_id => $client_id,
        client_secret => $client_secret
    });
    my %search_params = (
        query => "Some keyword",
        sort => "rating",
    );
    my $result = $ils->search(\%search_params);
    foreach (@{ $result->{items} }) {
        ...
    }
    foreach (2..$result->{pages}) {
        $search_params{page} = $_;
        my $next_results = $ils->search(\%search_params);
        ...
    }

    or

    my $native_result = $ils->native_search(\%native_search_params);

# DESCRIPTION

WebService::ILS is an attempt to create a standardised interface for
online library services providers.

In addition, native API interface is provided.

Here we will describe constructor parameters and methods common to all
service providers. Diversions and native interfaces are documented
in corresponding modules.

## Supported service providers

- __WebService::ILS::OverDrive::Library__

    OverDrive Library API [https://developer.overdrive.com/discovery-apis](https://developer.overdrive.com/discovery-apis)

- __WebService::ILS::OverDrive::Patron__

    OverDrive Circulation API [https://developer.overdrive.com/circulation-apis](https://developer.overdrive.com/circulation-apis)

# TESTING ENVIRONMENT

Testing `WebService::ILS` modules is extremely difficult. It requires
test accounts with vendors, sometimes special setup for handling
redirect URLs.

In that respect for building purposes, all tests are skipped by default.
If you want to run tests for vendor specific modules during the build,
you need to set the corresponding WEBSERVICE\_ILS\_TEST\_\* env vars to true,
and supply values in vendor specific env vars. Those vendor specific vars
correspond to [CONSTRUCTOR](https://metacpan.org/pod/CONSTRUCTOR) params.

# TESTING OverDrive API

- __WEBSERVICE\_ILS\_TEST\_OVERDRIVE\_LIBRARY__

    When set to true turns on tests from t/overdrve\_library.t, which test
    `WebService::ILS::OverDrive::Library` module

- __WEBSERVICE\_ILS\_TEST\_OVERDRIVE\_PATRON__

    When set to true turns on tests from t/overdrve\_patron.t, which test
    `WebService::ILS::OverDrive::Patron` module

- __WEBSERVICE\_ILS\_TEST\_OVERDRIVE\_AUTH__

    When set to true turns on tests from t/overdrve\_auth.t, which test
    OverDrive Granted (3-legged) authentication mechanism. It is separated
    because of the challenges it presents

## OverDrive account vars

- __OVERDRIVE\_TEST\_CLIENT\_ID__
- __OVERDRIVE\_TEST\_CLIENT\_SECRET__
- __OVERDRIVE\_TEST\_LIBRARY\_ID__          library and auth
- __OVERDRIVE\_TEST\_WEBSITE\_ID__          patron only
- __OVERDRIVE\_TEST\_AUTHORIZATION\_NAME__  patron only
- __OVERDRIVE\_TEST\_USER\_ID__             patron only
- __OVERDRIVE\_TEST\_USER\_PASSWORD__       patron only
- __OVERDRIVE\_TEST\_AUTH\_REDIRECT\_URL__   auth only
