/*
 * Decompiled with CFR 0.152.
 */
package gma;

import gma.gsa.GSA;
import gma.simr.SIMR;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;

public class GMA {
    public Properties properties = new Properties();

    public GMA(String[] args) {
        try {
            this.parseArguments(args);
        }
        catch (IllegalArgumentException e) {
            this.printUsage();
            System.exit(1);
        }
    }

    private String formArgumentUsage(String argument, boolean isRequired, String example) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t").append("-").append(argument).append(" ").append(argument).append("\n");
        if (isRequired) {
            buffer.append("\t").append("required argument; ");
        } else {
            buffer.append("\t").append("optional argument; ");
        }
        buffer.append("e.g., ").append("-").append(argument).append(" ").append(example).append("\n\n");
        return buffer.toString();
    }

    private void printUsage() {
        StringBuffer buffer = new StringBuffer("Usage: java gma.GMA [arguments]\n\n");
        buffer.append("where [arguments] are:\n\n");
        buffer.append(this.formArgumentUsage("properties", true, "./GMA.properties"));
        buffer.append(this.formArgumentUsage("xAxisFile", false, "./french.txt"));
        buffer.append(this.formArgumentUsage("yAxisFile", false, "./english.txt"));
        buffer.append(this.formArgumentUsage("simr.outputFile", false, "./simrOutput.txt"));
        buffer.append(this.formArgumentUsage("gsa.outputFile", false, "./gsaOutput.txt"));
        System.err.println(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readProperties(String fileName) {
        String line;
        BufferedInputStream in = null;
        in = new BufferedInputStream(new FileInputStream(fileName));
        this.properties.load(in);
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        String inc = new String("#INCLUDE");
        while ((line = reader.readLine()) != null) {
            if (line.equals("") || !line.startsWith(inc)) continue;
            String[] tok = line.split(" +");
            Object in2 = null;
            this.readProperties(tok[1]);
        }
        Object var9_10 = null;
        if (in == null) return;
        try {
            ((InputStream)in).close();
            return;
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return;
        {
            catch (FileNotFoundException e) {
                e.printStackTrace();
                System.exit(1);
                Object var9_11 = null;
                if (in == null) return;
                try {
                    ((InputStream)in).close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
                Object var9_12 = null;
                if (in == null) return;
                try {
                    ((InputStream)in).close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (in == null) throw throwable;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    private void parseArguments(String[] args) throws IllegalArgumentException {
        boolean gotProp = false;
        boolean gotOut = false;
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("The number of arguments must be even.");
        }
        for (int index = 0; index < args.length; ++index) {
            if (args[index].equals("-properties") || args[index].equals("+properties")) {
                this.readProperties(args[++index]);
                gotProp = true;
                continue;
            }
            if (args[index].equals("-xAxisFile") || args[index].equals("+xAxisFile")) {
                this.properties.put("xAxisFile", args[++index]);
                continue;
            }
            if (args[index].equals("-yAxisFile") || args[index].equals("+yAxisFile")) {
                this.properties.put("yAxisFile", args[++index]);
                continue;
            }
            if (args[index].equals("-verbose")) {
                this.properties.put("verbose", args[++index]);
                continue;
            }
            if (args[index].equals("-simr.outputFile") || args[index].equals("+simr.outputFile")) {
                this.properties.put("simr.outputFile", args[++index]);
                continue;
            }
            if (args[index].equals("-gsa.outputFile") || args[index].equals("+gsa.outputFile")) {
                this.properties.put("gsa.outputFile", args[++index]);
                continue;
            }
            throw new IllegalArgumentException(args[index] + "is an invalid argument.");
        }
        if (!gotProp) {
            throw new IllegalArgumentException("Property file must be specified at the command line.");
        }
    }

    public boolean isJDK14only() {
        String v = System.getProperty("java.class.version", "48.0");
        System.err.println("version " + v);
        return "48.0".compareTo(v) <= 0;
    }

    public void setDefaults() {
        String pathGMA = System.getProperty("GMApath");
        System.err.println("pathGMA " + pathGMA);
        if (!this.properties.containsKey("simr.outputFile")) {
            System.err.println("no simr file specified.. writting to /tmp/temp.map");
            this.properties.put("simr.outputFile", "/tmp/temp.map");
        }
        if (!this.properties.containsKey("gsa.outputFile")) {
            System.err.println("no gsa file specified write alignment to std out");
        }
    }

    public void execute() {
        SIMR simr = new SIMR(this.properties);
        SortedSet mapPoints = simr.generateBitextCorrespondence();
        simr.printMapPoints(mapPoints);
        GSA gsa = new GSA(this.properties);
        List alignedBlocks = gsa.generateAlignedBlocks();
        gsa.printAlignedBlocks(alignedBlocks);
    }

    public static void main(String[] args) {
        GMA gma = new GMA(args);
        gma.setDefaults();
        boolean v = gma.isJDK14only();
        if (v) {
            System.err.println("Java version test...pass");
        } else {
            System.err.println("Java version test...fail");
            System.err.println("please use Java version 1.4.x");
            System.exit(1);
        }
        System.err.println("v" + v);
        gma.execute();
        System.exit(0);
    }
}

