/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grokkit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import opennlp.common.Pipeline;
import opennlp.common.PipelineException;
import opennlp.common.parse.LexException;
import opennlp.common.parse.Lexicon;
import opennlp.common.parse.ParseException;
import opennlp.common.parse.Parser;
import opennlp.common.synsem.Category;
import opennlp.common.synsem.Sign;
import opennlp.common.util.Pair;
import opennlp.common.xml.NLPDocument;
import opennlp.grok.expression.AtomCat;
import opennlp.grok.parse.CKY;
import opennlp.grok.parse.Chart;
import opennlp.grokkit.Grok;
import opennlp.grokkit.grokkit_grokButton_ActionAdapter;
import opennlp.grokkit.grokkit_inputText_ActionAdapter;
import opennlp.grokkit.grokkit_menuDisplayHelp_ActionAdapter;
import opennlp.grokkit.grokkit_menuEdit_ActionAdapter;
import opennlp.grokkit.grokkit_menuFileExit_ActionAdapter;
import opennlp.grokkit.grokkit_menuLoadGrammar_ActionAdapter;
import opennlp.grokkit.grokkit_menuPreprocessRadioButton_ActionAdapter;
import opennlp.grokkit.grokkit_menuRadios_ActionAdapter;
import opennlp.grokkit.grokkit_menuType_ActionAdapter;
import opennlp.grokkit.gui.NLPTextComponent;
import opennlp.grokkit.gui.Parameters;

class grokkit
extends JFrame {
    JMenuBar menuBar1 = new JMenuBar();
    JMenu menuFile = new JMenu();
    JMenu menuHelp = new JMenu();
    JMenuItem menuDisplayHelp = new JMenuItem();
    JMenu menuEdit = new JMenu();
    JMenuItem menuEditReadme = new JMenuItem();
    JMenuItem menuEditMorph = new JMenuItem();
    JMenuItem menuEditLexicon = new JMenuItem();
    JMenuItem menuEditRules = new JMenuItem();
    JMenuItem menuEditGrammar = new JMenuItem();
    JMenuItem menuEditFlatMorph = new JMenuItem();
    JMenuItem menuFileExit = new JMenuItem();
    JMenuItem menuLoadGrammar = new JMenuItem();
    BorderLayout borderLayout1 = new BorderLayout();
    JTabbedPane main = new JTabbedPane();
    JEditorPane NLP = new JEditorPane();
    JEditorPane plainText = new JEditorPane();
    JEditorPane chart = new JEditorPane();
    NLPTextComponent NLPText = new NLPTextComponent();
    JScrollPane sNLPPane = new JScrollPane(this.NLPText);
    JScrollPane nNLPPane = new JScrollPane(this.NLP);
    JScrollPane pNLPPane = new JScrollPane(this.plainText);
    JScrollPane cNLPPane = new JScrollPane(this.chart);
    JTextField inputText;
    JTextField outputText;
    Parameters PARAMS;
    Properties GRAMMAR;
    Grok grok;
    JLabel status = new JLabel("Status: Happy");
    JButton GROKButton = new JButton(Grok.getImage("brainTiny.gif"));
    Properties _grammarInfo = new Properties();
    Parser _parser;
    Pipeline _pipeline;
    Lexicon _lexicon;
    boolean showSyntax = true;
    boolean showSemantics = true;
    String[] ppLinks;
    ArrayList PPLinks = new ArrayList();
    String grokHome = new String(System.getProperties().getProperty("grok.dir"));
    String grammar_file = this.grokHome + "/samples/grammar/simple.gram";
    static /* synthetic */ Class class$opennlp$common$preprocess$Pipelink;

    public grokkit() {
        this.enableEvents(64L);
        try {
            this.Init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public grokkit(Parameters P) {
        super("Grok");
        this.PARAMS = P;
        ((Component)this).setSize(800, 600);
        ((Component)this).setLocation(200, 200);
        this.enableEvents(64L);
        try {
            this.Init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void loadGrammar(URL grammar) throws IOException {
        this._grammarInfo.load(grammar.openStream());
        String gram = grammar.toString();
        String dir = gram.substring(0, gram.lastIndexOf(47));
        Iterator it = ((Hashtable)this._grammarInfo).keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String file = this._grammarInfo.getProperty(key);
            if (file.charAt(0) == '/') {
                this._grammarInfo.setProperty(key, "file:" + file);
                continue;
            }
            this._grammarInfo.setProperty(key, dir + "/" + file);
        }
    }

    public Pair[] grok(String s) throws ParseException, PipelineException, LexException {
        if (s.equals("")) {
            throw new ParseException("Nothing to Parse!");
        }
        NLPDocument doc = this._pipeline.run((Object)s);
        this.NLP.setText(doc.toXml());
        List entries = this._lexicon.getWords(doc);
        Chart table = ((CKY)this._parser).getInitializedTable(entries);
        ((CKY)this._parser).parse(table, entries.size());
        System.setProperty("line.seperator", "\r");
        try {
            this.chart.read((InputStream)new FileInputStream(new File(this.redirectChart(table))), (Object)null);
        }
        catch (MalformedURLException m) {
            this.display(m);
        }
        catch (IOException o) {
            this.display(o);
        }
        ArrayList interps = this.getPreferredResult(this._parser.getResult());
        if (interps.isEmpty()) {
            throw new ParseException("No result ");
        }
        Pair[] answers = new Pair[interps.size()];
        int curIndex = 0;
        while (curIndex < answers.length) {
            Sign constit = (Sign)interps.get(curIndex);
            answers[curIndex] = new Pair((Object)constit.getCategory().toString(), (Object)"no LF");
            ++curIndex;
        }
        return answers;
    }

    public ArrayList grokAndReturnSigns(String s) throws ParseException, PipelineException, LexException {
        if (s.equals("")) {
            throw new ParseException("Nothing to Parse!");
        }
        NLPDocument doc = this._pipeline.run((Object)s);
        this.NLP.setText(doc.toXml());
        List entries = this._lexicon.getWords(doc);
        Chart table = ((CKY)this._parser).getInitializedTable(entries);
        ((CKY)this._parser).parse(table, entries.size());
        ArrayList interps = this.getPreferredResult(this._parser.getResult());
        if (interps.isEmpty()) {
            throw new ParseException("No result ");
        }
        return interps;
    }

    public String[] grokAndReturnStrings(String sentence) throws LexException, ParseException, IOException, PipelineException {
        Pair[] res = this.grok(sentence);
        String[] s = new String[res.length];
        if (this.showSyntax && this.showSemantics) {
            int i = 0;
            while (i < res.length) {
                s[i] = res[i].a.toString() + " : " + res[i].b.toString();
                ++i;
            }
        } else if (this.showSemantics) {
            int i = 0;
            while (i < res.length) {
                s[i] = res[i].b.toString();
                ++i;
            }
        } else {
            int i = 0;
            while (i < res.length) {
                s[i] = res[i].a.toString();
                ++i;
            }
        }
        return s;
    }

    private ArrayList getPreferredResult(ArrayList unranked) {
        ArrayList<Sign> reranked = new ArrayList<Sign>();
        Iterator i = ((AbstractList)unranked).iterator();
        while (i.hasNext()) {
            String type;
            Sign w = (Sign)i.next();
            Category syn = w.getCategory();
            if (!(syn instanceof AtomCat) || !(type = ((AtomCat)syn).getType()).equals("s")) continue;
            reranked.add(w);
            i.remove();
        }
        Iterator i2 = ((AbstractList)unranked).iterator();
        while (i2.hasNext()) {
            String type;
            Sign w = (Sign)i2.next();
            Category syn = w.getCategory();
            if (!(syn instanceof AtomCat) || !(type = ((AtomCat)syn).getType()).equals("n")) continue;
            reranked.add(w);
            i2.remove();
        }
        reranked.addAll(unranked);
        return reranked;
    }

    private String redirectChart(Chart table) {
        try {
            PrintStream temp = System.out;
            PrintStream newOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(this.grokHome + "/samples/grammar/chart.txt"))));
            System.setOut(newOut);
            table.printChart();
            newOut.flush();
            newOut.close();
            System.setOut(temp);
            return this.grokHome + "/samples/grammar/chart.txt";
        }
        catch (FileNotFoundException fileNotFoundException) {
            return "";
        }
    }

    private JMenu initPPLinks(String userhome) {
        JMenu ppMenu = new JMenu("Preprocess");
        JMenuItem help = new JMenuItem("Click to add-to/remove-from pipeline");
        JMenuItem help2 = new JMenuItem("Warning: order sensitive [I think]");
        ppMenu.add(help);
        ppMenu.add(help2);
        ppMenu.addSeparator();
        File preprocess = new File(userhome + "/opennlp/grok/preprocess/");
        File[] insides = preprocess.listFiles();
        int i = 0;
        while (i < insides.length) {
            File[] files;
            if (insides[i].isDirectory() && (files = insides[i].listFiles()) != null) {
                JMenu submenu1 = new JMenu(insides[i].getName());
                ppMenu.add(submenu1);
                int n = 0;
                while (n < files.length) {
                    if (files[n].isFile()) {
                        String name = "opennlp.grok.preprocess." + insides[i].getName() + "." + files[n].getName();
                        if (name.endsWith(".class")) {
                            name = name.substring(0, name.length() - 6);
                        }
                        try {
                            Class<?> test = Class.forName(name);
                            if ((class$opennlp$common$preprocess$Pipelink == null ? grokkit.class$("opennlp.common.preprocess.Pipelink") : class$opennlp$common$preprocess$Pipelink).isAssignableFrom(test)) {
                                JRadioButtonMenuItem classMI = new JRadioButtonMenuItem(name);
                                if (name.equals("opennlp.grok.preprocess.sentdetect.EnglishSentenceDetectorME") || name.equals("opennlp.grok.preprocess.tokenize.EnglishTokenizerME")) {
                                    classMI.setSelected(true);
                                    this.PPLinks.add(name);
                                }
                                classMI.addActionListener(new grokkit_menuPreprocessRadioButton_ActionAdapter(this));
                                submenu1.add(classMI);
                            }
                        }
                        catch (ClassNotFoundException c) {
                            // empty catch block
                        }
                    }
                    ++n;
                }
            }
            ++i;
        }
        return ppMenu;
    }

    private JMenu initParams() {
        JMenu menuParams = new JMenu("Parameters");
        JMenuItem help = new JMenuItem("Click to flip parameters");
        JMenuItem help2 = new JMenuItem("Or type value");
        menuParams.add(help);
        menuParams.add(help2);
        menuParams.addSeparator();
        JMenu radios = new JMenu("Boolean Parameters:");
        JMenu type = new JMenu("Other:");
        menuParams.add(radios);
        menuParams.add(type);
        this.PARAMS.setProperty("Results:Use Filter", "false");
        this.PARAMS.setProperty("Display:CKY Chart", "false");
        this.PARAMS.setProperty("Display:Features", "false");
        this.PARAMS.setProperty("Enable:Databases", "false");
        this.PARAMS.setProperty("Results:All Derivs", "false");
        Enumeration<?> e = this.PARAMS.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.PARAMS.getProperty(name);
            if (value.equals("false") || value.equals("true")) {
                JRadioButtonMenuItem paramMI = new JRadioButtonMenuItem(name);
                if (value.equals("true")) {
                    paramMI.setSelected(true);
                }
                radios.add(paramMI);
                paramMI.addActionListener(new grokkit_menuRadios_ActionAdapter(this));
                continue;
            }
            JLabel nameL = new JLabel(name);
            JTextField field = new JTextField(value);
            field.setText(value);
            field.setColumns(15);
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)nameL, "Center");
            p.add((Component)field, "East");
            field.addActionListener(new grokkit_menuType_ActionAdapter(this));
            type.add(p);
        }
        return menuParams;
    }

    private void Init() throws Exception {
        ((Component)this).setLocation(200, 200);
        ImageIcon icon = Grok.getImage("brainBig.gif");
        if (icon != null) {
            ((Frame)this).setIconImage(icon.getImage());
        }
        ((Component)this).setBackground(Grok.bgcolor);
        GridBagLayout ig = new GridBagLayout();
        GridBagConstraints ic = new GridBagConstraints();
        JPanel input = new JPanel(ig);
        ic.insets = new Insets(0, 10, 0, 10);
        ic.fill = 2;
        ic.gridwidth = 0;
        ic.insets = new Insets(0, 10, 10, 10);
        ic.gridwidth = 1;
        input.add(new JLabel(Grok.getImage("listen.gif")));
        this.inputText = new JTextField();
        this.inputText.setBackground(Grok.textBgcolor);
        this.inputText.setText("Hobbes devours mice");
        this.inputText.addActionListener(new grokkit_inputText_ActionAdapter(this));
        ic.fill = 2;
        ic.weightx = 1.0;
        ic.gridwidth = 0;
        ig.setConstraints(this.inputText, ic);
        input.add(this.inputText);
        input.add(new JLabel(Grok.getImage("talk.gif")));
        this.outputText = new JTextField();
        this.outputText.setEditable(false);
        this.outputText.setBackground(Color.white);
        ig.setConstraints(this.outputText, ic);
        input.add(this.outputText);
        this.main.addTab("XML Document", this.nNLPPane);
        this.main.addTab("Plain Text", this.pNLPPane);
        this.main.addTab("Chart", this.cNLPPane);
        this.main.addTab("NLP Document", this.sNLPPane);
        this.getContentPane().setLayout(this.borderLayout1);
        ((Component)this).setSize(new Dimension(800, 600));
        this.setTitle("Grok");
        this.menuFile.setText("File");
        this.menuFileExit.setText("Exit");
        this.menuHelp.setText("Help");
        this.menuDisplayHelp.setText("Help");
        this.menuLoadGrammar.setText("Set Grammar Path");
        this.menuDisplayHelp.addActionListener(new grokkit_menuDisplayHelp_ActionAdapter(this));
        this.menuLoadGrammar.addActionListener(new grokkit_menuLoadGrammar_ActionAdapter(this));
        this.menuFileExit.addActionListener(new grokkit_menuFileExit_ActionAdapter(this));
        this.menuEdit.setText("Edit");
        this.menuEditReadme.setText("Edit Readme");
        this.menuEditMorph.setText("Edit Morph.XML");
        this.menuEditLexicon.setText("Edit Lexicon.XML");
        this.menuEditRules.setText("Edit Rules.XML");
        this.menuEditGrammar.setText("Edit .gram file");
        this.menuEditFlatMorph.setText("Edit flat_morph_db");
        this.menuEdit.add(this.menuEditReadme);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuEditMorph);
        this.menuEdit.add(this.menuEditLexicon);
        this.menuEdit.add(this.menuEditRules);
        this.menuEdit.add(this.menuEditGrammar);
        this.menuEdit.add(this.menuEditFlatMorph);
        this.menuEdit.addSeparator();
        this.menuEditReadme.addActionListener(new grokkit_menuEdit_ActionAdapter(this));
        this.menuEditMorph.addActionListener(new grokkit_menuEdit_ActionAdapter(this));
        this.menuEditLexicon.addActionListener(new grokkit_menuEdit_ActionAdapter(this));
        this.menuEditRules.addActionListener(new grokkit_menuEdit_ActionAdapter(this));
        this.menuEditGrammar.addActionListener(new grokkit_menuEdit_ActionAdapter(this));
        this.menuEditFlatMorph.addActionListener(new grokkit_menuEdit_ActionAdapter(this));
        this.menuFile.add(this.menuLoadGrammar);
        this.menuFile.addSeparator();
        this.menuFile.add(this.menuFileExit);
        this.menuHelp.add(this.menuDisplayHelp);
        this.menuBar1.add(this.menuFile);
        this.menuBar1.add(this.menuEdit);
        this.menuBar1.add(this.initPPLinks(this.grokHome + "/output/classes"));
        this.menuBar1.add(this.initParams());
        this.menuBar1.add(this.menuHelp);
        this.setJMenuBar(this.menuBar1);
        JPanel seperator = new JPanel();
        BorderLayout updown = new BorderLayout();
        seperator.setLayout(updown);
        JPanel grokButton = new JPanel();
        BorderLayout cenleft = new BorderLayout();
        grokButton.setLayout(cenleft);
        grokButton.add((Component)input, "Center");
        grokButton.add((Component)this.GROKButton, "East");
        seperator.add((Component)grokButton, "South");
        this.GROKButton.addActionListener(new grokkit_grokButton_ActionAdapter(this));
        this.getContentPane().add((Component)seperator, "North");
        this.getContentPane().add((Component)this.main, "Center");
        this.getContentPane().add((Component)this.status, "South");
        File f = new File(".");
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.fileExit_actionPerformed(null);
        }
    }

    protected void fileExit_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    void display(String s) {
        String err = "An internal error occurred.\nPlease report this message to the maintainers\nAs well as the garbage that probably appearedin your terminal window\n\n";
        System.out.println(err + " ERROR " + s);
        this.status.setText("Status: ERROR");
        JOptionPane.showMessageDialog(this, err + s, "Error", 0);
    }

    void display(Exception e) {
        System.out.println(" ERROR " + e);
        this.status.setText("Status: ERROR");
        JOptionPane.showMessageDialog(this, e.toString(), "Error", 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

