#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::ExpressSellingPreferenceCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ExpressSellingPreferenceCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::ExpressSellingPreferenceCodeType

=head1 DESCRIPTION

Specifies the kinds of eligible listings tht the seller prefers to include on Express.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 All

The seller wants all of their eligible listings to appear on Express
(in addition to the main eBay site), regardless of the listing format.
Only applicable to sellers who are eligible for Express US or Express Germany.
(By default, eBay sets this option for every eligible seller.)



=cut


use constant All => scalar('All');


=head2 ExpressOnly

The seller only wants their Express format listings
to appear on Express.
(They don't want their fixed-price and Store Inventory format listings
to appear on Express.)
Only applicable to sellers who are eligible for Express Germany.



=cut


use constant ExpressOnly => scalar('ExpressOnly');


=head2 OptOut

The seller does not want any of their eligible listings to appear on Express.
That is, the seller prefers to completely opt out of Express.
Only applicable to sellers who are eligible for Express US.
(Germany sellers can't use the API to opt out of Express.
Germany sellers should see the Express Web site online help for information on how
to end their Express qualification.)



=cut


use constant OptOut => scalar('OptOut');


=head2 CustomCode

Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
