#!/usr/bin/perl

package eBay::API::XML::Call::GetWantItNowPost::GetWantItNowPostRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetWantItNowPostRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetWantItNowPost::GetWantItNowPostRequestType

=head1 DESCRIPTION

Retrieves data for a specific, active Want It Now post identified by a post ID.
The response includes the following fields: CategoryID, Description, PostID,
Site, StartTime, ResponseCount, and Title. Although GetWantItNowSearchResults
returns most of this information, only GetWantItNowPost returns Description for
a post.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetWantItNowPost::GetWantItNowPostRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::ItemIDType;


my @gaProperties = ( [ 'PostID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setPostID()

Specifies the post ID that uniquely identifies the Want It Now post for
which to retrieve the data. PostID is a required input. PostID is unique
across all eBay sites.

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut

sub setPostID {
  my $self = shift;
  $self->{'PostID'} = shift
}

=head2 getPostID()

#    Returns: 'ns:ItemIDType'

=cut

sub getPostID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PostID'
		,'eBay::API::XML::DataType::ItemIDType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
