# This Makefile.PL for App-Sandy was generated by
# inc::SandyMakeMaker <self>
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT" => "A straightforward and complete next-generation sequencing read simulator",
  "AUTHOR" => "Thiago L. A. Miller <tmiller\@mochsl.org.br>, J. Leonel Buzzo <lbuzzo\@mochsl.org.br>, Felipe R. C. dos Santos <fsantos\@mochsl.org.br>, Helena B. Concei\x{e7}\x{e3}o <hconceicao\@mochsl.org.br>, Rodrigo Barreiro <rbarreiro\@mochsl.org.br>, Gabriela Guardia <gguardia\@mochsl.org.br>, Fernanda Orpinelli <forpinelli\@mochsl.org.br>, Rafael Mercuri <rmercuri\@mochsl.org.br>, Rodrigo Barreiro <rbarreiro\@mochsl.org.br>, Pedro A. F. Galante <pgalante\@mochsl.org.br>",
  "BUILD_REQUIRES" => {
    "LWP::Simple" => 0
  },
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::ShareDir::Install" => 0
  },
  "DISTNAME" => "App-Sandy",
  "EXE_FILES" => [
    "script/sandy"
  ],
  "INC" => "-I. -Ixs",
  "LIBS" => [
    "-lm"
  ],
  "LICENSE" => "gpl",
  "NAME" => "App::Sandy",
  "OBJECT" => "xs/RNG\$(OBJ_EXT) xs/gauss\$(OBJ_EXT) xs/ranlxd\$(OBJ_EXT) xs/rng\$(OBJ_EXT)",
  "PREREQ_PM" => {
    "Carp" => 0,
    "Compress::BGZF::Writer" => 0,
    "DBIx::Class::Core" => 0,
    "DBIx::Class::Schema" => 0,
    "Data::OptList" => 0,
    "Exporter" => 0,
    "File::Cat" => 0,
    "File::Path" => 0,
    "Getopt::Long" => 0,
    "Hook::AfterRuntime" => 0,
    "IO::Compress::Gzip" => 0,
    "IO::Handle" => 0,
    "IO::Uncompress::Gunzip" => 0,
    "Import::Into" => 0,
    "List::Util" => "1.44",
    "Module::Runtime" => 0,
    "Moose" => 0,
    "Moose::Role" => 0,
    "Moose::Util::TypeConstraints" => 0,
    "MooseX::Singleton" => 0,
    "MooseX::StrictConstructor" => 0,
    "MooseX::UndefTolerant" => 0,
    "Parallel::ForkManager" => "1.19",
    "Path::Class" => 0,
    "PerlIO::gzip" => "0.19",
    "Pod::Usage" => 0,
    "Scalar::Util" => 0,
    "Storable" => "2.51",
    "Text::ASCIITable" => 0,
    "Try::Tiny" => 0,
    "XSLoader" => 0,
    "base" => 0,
    "constant" => 0,
    "feature" => 0,
    "namespace::autoclean" => 0,
    "strict" => 0,
    "true" => 0,
    "utf8" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Class::Data::Inheritable" => "0.08",
    "Test::Class" => "0.50",
    "Test::Most" => "0.35",
    "Test::UseAllModules" => 0,
    "autodie" => 0
  },
  "VERSION" => "0.25",
  "XS" => {
    "xs/RNG.xs" => "xs/RNG.c"
  },
  "clean" => {
    "FILES" => "xs/RNG\$(OBJ_EXT) xs/gauss\$(OBJ_EXT) xs/ranlxd\$(OBJ_EXT) xs/rng\$(OBJ_EXT)"
  },
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Carp" => 0,
  "Class::Data::Inheritable" => "0.08",
  "Compress::BGZF::Writer" => 0,
  "DBIx::Class::Core" => 0,
  "DBIx::Class::Schema" => 0,
  "Data::OptList" => 0,
  "Exporter" => 0,
  "File::Cat" => 0,
  "File::Path" => 0,
  "Getopt::Long" => 0,
  "Hook::AfterRuntime" => 0,
  "IO::Compress::Gzip" => 0,
  "IO::Handle" => 0,
  "IO::Uncompress::Gunzip" => 0,
  "Import::Into" => 0,
  "LWP::Simple" => 0,
  "List::Util" => "1.44",
  "Module::Runtime" => 0,
  "Moose" => 0,
  "Moose::Role" => 0,
  "Moose::Util::TypeConstraints" => 0,
  "MooseX::Singleton" => 0,
  "MooseX::StrictConstructor" => 0,
  "MooseX::UndefTolerant" => 0,
  "Parallel::ForkManager" => "1.19",
  "Path::Class" => 0,
  "PerlIO::gzip" => "0.19",
  "Pod::Usage" => 0,
  "Scalar::Util" => 0,
  "Storable" => "2.51",
  "Test::Class" => "0.50",
  "Test::Most" => "0.35",
  "Test::UseAllModules" => 0,
  "Text::ASCIITable" => 0,
  "Try::Tiny" => 0,
  "XSLoader" => 0,
  "autodie" => 0,
  "base" => 0,
  "constant" => 0,
  "feature" => 0,
  "namespace::autoclean" => 0,
  "strict" => 0,
  "true" => 0,
  "utf8" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

package MY;

use File::ShareDir::Install;

# These two are necessary to keep bmake happy
sub xs_c {
	my $self = shift;
	my $ret = $self->SUPER::xs_c(@_);
	$ret =~ s/\$\*\.xs/\$</g;
	$ret =~ s/\$\*\.c\b/\$@/g;
	return $ret;
}

sub c_o {
	my $self = shift;
	my $ret = $self->SUPER::c_o(@_);
	$ret =~ s/\$\*\.c\b/\$</g;
	$ret =~ s/\$\*\$\(OBJ_EXT\)/\$@/g;
	return $ret;
}

sub const_cccmd {
	my $ret = shift->SUPER::const_cccmd(@_);
	return q{} unless $ret;

	$ret .= ' -o $@';

	return $ret;
}

# Fix shared object path
sub constants {
	my $self = shift;
	my $ret = $self->SUPER::constants(@_);
	$ret =~ s|(?<=\nFULLEXT).*\n| = App/Sandy/RNG\n|;
	$ret =~ s|(?<=\nBASEEXT).*\n| = RNG\n|;
	return $ret;
}

sub postamble {
	my $self = shift;
	my @ret = File::ShareDir::Install::postamble($self);

	my $cmd = q{
# --- App::Sandy custom postamble section:
LFS_URL = https://media.githubusercontent.com/media/galantelab/sandy/master/share/assets/db.sqlite3
INST_DB = $(INST_LIB)/auto/share/dist/$(DISTNAME)
INST_SHARE = blib/share
INSTALLSHARE = /usr/share
DESTINSTALLSHARE = $(DESTDIR)$(INSTALLSHARE)
PERM_DB_DIR = 0777
PERM_DB = 666

pure_perl_install :: all
	-$(NOECHO) $(CHMOD) $(PERM_DB_DIR) "$(DESTINSTALLPRIVLIB)/auto/share/dist/$(DISTNAME)"
	-$(NOECHO) $(CHMOD) $(PERM_DB) "$(DESTINSTALLPRIVLIB)/auto/share/dist/$(DISTNAME)/db.sqlite3"
	-$(NOECHO) $(CHMOD) $(PERM_DB_DIR) "$(DESTINSTALLARCHLIB)/auto/share/dist/$(DISTNAME)"
	-$(NOECHO) $(CHMOD) $(PERM_DB) "$(DESTINSTALLARCHLIB)/auto/share/dist/$(DISTNAME)/db.sqlite3"

pure_site_install :: all
	-$(NOECHO) $(CHMOD) $(PERM_DB_DIR) "$(DESTINSTALLSITELIB)/auto/share/dist/$(DISTNAME)"
	-$(NOECHO) $(CHMOD) $(PERM_DB) "$(DESTINSTALLSITELIB)/auto/share/dist/$(DISTNAME)/db.sqlite3"
	-$(NOECHO) $(CHMOD) $(PERM_DB_DIR) "$(DESTINSTALLSITEARCH)/auto/share/dist/$(DISTNAME)"
	-$(NOECHO) $(CHMOD) $(PERM_DB) "$(DESTINSTALLSITEARCH)/auto/share/dist/$(DISTNAME)/db.sqlite3"

pure_vendor_install :: all
	-$(NOECHO) $(CHMOD) $(PERM_DB_DIR) "$(DESTINSTALLVENDORLIB)/auto/share/dist/$(DISTNAME)"
	-$(NOECHO) $(CHMOD) $(PERM_DB) "$(DESTINSTALLVENDORLIB)/auto/share/dist/$(DISTNAME)/db.sqlite3"
	-$(NOECHO) $(CHMOD) $(PERM_DB_DIR) "$(DESTINSTALLVENDORARCH)/auto/share/dist/$(DISTNAME)"
	-$(NOECHO) $(CHMOD) $(PERM_DB) "$(DESTINSTALLVENDORARCH)/auto/share/dist/$(DISTNAME)/db.sqlite3"

pure_perl_install :: all
	-$(NOECHO) $(MOD_INSTALL) \
		read "$(PERL_ARCHLIB)/auto/$(FULLEXT)/.packlist" \
		write "$(DESTINSTALLARCHLIB)/auto/$(FULLEXT)/.packlist" \
		"$(INST_SHARE)" "$(DESTINSTALLSHARE)"

pure_site_install :: all
	-$(NOECHO) $(MOD_INSTALL) \
		read "$(SITEARCHEXP)/auto/$(FULLEXT)/.packlist" \
		write "$(DESTINSTALLSITEARCH)/auto/$(FULLEXT)/.packlist" \
		"$(INST_SHARE)" "$(DESTINSTALLSHARE)"

pure_vendor_install :: all
	-$(NOECHO) $(MOD_INSTALL) \
		read "$(VENDORARCHEXP)/auto/$(FULLEXT)/.packlist" \
		write "$(DESTINSTALLVENDORARCH)/auto/$(FULLEXT)/.packlist" \
		"$(INST_SHARE)" "$(DESTINSTALLSHARE)"

config :: config_lfs
	$(NOECHO) $(ABSPERLRUN) -MExtUtils::Install -e 'pm_to_blib({@ARGV}, '\''$(INST_DB)'\'')' -- \
		'share/assets/db.sql' '$(INST_DB)/db.sql' \
		'share/assets/db.sqlite3' '$(INST_DB)/db.sqlite3'

config ::
	$(NOECHO) $(ABSPERLRUN) -MExtUtils::Install -e 'pm_to_blib({@ARGV}, '\''$(INST_SHARE)'\'')' -- \
		'share/completions/sandy-completion.bash' '$(INST_SHARE)/bash-completion/completions/sandy' \
		'share/completions/sandy-completion.zsh' '$(INST_SHARE)/zsh/site-functions/_sandy'

.PHONY : config_lfs
config_lfs :
ifndef GITHUB_ACTIONS_CI
	$(NOECHO) if ! perl -E 'exit((-s $$ARGV[0] && -B $$ARGV[0])?0:1)' 'share/assets/db.sqlite3'; \
	then \
		echo 'Database share/assets/db.sqlite3 is not a binary file.'; \
		echo 'Maybe it is a git-lfs pointer, so I will try to download it for you'; \
		perl -MLWP::Simple -e 'getprint "$(LFS_URL)"' > './db.sqlite3'; \
		if ! perl -E 'exit((-s $$ARGV[0] && -B $$ARGV[0])?0:1)' './db.sqlite3'; \
		then \
			echo 'Something went wrong. Abort.'; \
			exit 1; \
		fi; \
		mv './db.sqlite3' 'share/assets/db.sqlite3'; \
	fi
endif

# --- END: App::Sandy custom postamble section
};

	push @ret, $cmd;
	return join "\n", @ret;
}
