package Armadito::Agent::Task::State::Armadito;

use strict;
use warnings;
use base 'Armadito::Agent::Task::State';

use FusionInventory::Agent::Config;
use FusionInventory::Agent::Logger;
use Data::Dumper;
use JSON;

sub isEnabled {
	my ($self) = @_;

	return 1;
}

sub new {
	my ( $class, %params ) = @_;

	my $self = $class->SUPER::new(%params);

	my $antivirus = {
		name    => "Armadito",
		version => ""
	};

	$self->{jobj}->{task}->{antivirus} = $antivirus;

	return $self;
}

sub _handleResponse {

	my ( $self, $response ) = @_;

	$self = $self->SUPER::_handleResponse($response);

	return $self;
}

sub _handleError {

	my ( $self, $response ) = @_;

	$self = $self->SUPER::_handleError($response);

	return $self;
}

sub run {
	my ( $self, %params ) = @_;

	$self = $self->SUPER::run(%params);
	$self->{av_client} = Armadito::Agent::HTTP::Client::ArmaditoAV->new( taskobj => $self );
	$self->{av_client}->register();

	my $response = $self->{av_client}->sendRequest(
		"url"  => $self->{av_client}->{server_url} . "/api/status",
		method => "GET"
	);

	die "Unable to get AV status with ArmaditoAV api."
		if ( !$response->is_success() );

	$self->{av_client}->pollEvents();
	$self->{av_client}->unregister();

	return $self;
}

1;

__END__

=head1 NAME

Armadito::Agent::Task::State::Armadito - State Task for Armadito Antivirus.

=head1 DESCRIPTION

This task inherits from L<Armadito::Agent::Task:State>. Ask for Armadito Antivirus state using AV's API REST protocol and then send it in a json formatted POST request to Armadito plugin for GLPI. 

=head1 FUNCTIONS

=head2 isEnabled ( $self )

Returns true if the task is enabled.

=head2 run ( $self, %params )

Run the task.

=head2 new ( $self, %params )

Instanciate Task.

