package Microsoft::AdCenter::V7::CustomerManagementService::Industry;
# Copyright (C) 2012 Xerxes Tsang
# This program is free software; you can redistribute it and/or modify it
# under the terms of Perl Artistic License.

use strict;
use warnings;

=head1 NAME

Microsoft::AdCenter::V7::CustomerManagementService::Industry - Represents "Industry" in Microsoft AdCenter Customer Management Service.

=head1 SYNOPSIS

See L<http://msdn.microsoft.com/en-us/library/ee730327.aspx> for documentation of the various data objects.

=head1 ENUMERATION VALUES

    AgencySalesHouse
    Automotive
    ConsumerPackagedGoods
    Education
    Entertainment
    FinancialServices
    FoodServices
    Gaming
    GovernmentNonprofitPolitical
    Healthcare
    Internal
    NA
    Other
    PublishingAndWebMedia
    RealEstate
    Retail
    Services
    Technology
    Telecommunications
    TravelHospitality

=cut

sub AgencySalesHouse {
    return 'AgencySalesHouse';
}

sub Automotive {
    return 'Automotive';
}

sub ConsumerPackagedGoods {
    return 'ConsumerPackagedGoods';
}

sub Education {
    return 'Education';
}

sub Entertainment {
    return 'Entertainment';
}

sub FinancialServices {
    return 'FinancialServices';
}

sub FoodServices {
    return 'FoodServices';
}

sub Gaming {
    return 'Gaming';
}

sub GovernmentNonprofitPolitical {
    return 'GovernmentNonprofitPolitical';
}

sub Healthcare {
    return 'Healthcare';
}

sub Internal {
    return 'Internal';
}

sub NA {
    return 'NA';
}

sub Other {
    return 'Other';
}

sub PublishingAndWebMedia {
    return 'PublishingAndWebMedia';
}

sub RealEstate {
    return 'RealEstate';
}

sub Retail {
    return 'Retail';
}

sub Services {
    return 'Services';
}

sub Technology {
    return 'Technology';
}

sub Telecommunications {
    return 'Telecommunications';
}

sub TravelHospitality {
    return 'TravelHospitality';
}

1;
