#!/usr/bin/perl
use Smart::Comments;
use AI::NaiveBayes;

my $classifier = AI::NaiveBayes->train( 
		    {
			        attributes => _hash(qw(我 喜欢 跳舞)),
					        labels => ['娱乐']
							    },
								    {
									        attributes => _hash(qw(他 爱 唱歌)),
											        labels => ['其他']
													    },
		);
 
# Classify a feature vector
my $result = $classifier->classify({'我' => 1,'爱'=> 1 ,'跳舞'=>1});
 
# $result is now a AI::NaiveBayes::Classification object
 
### $result
my $best_category = $result->best_category;

print $best_category ."\n";
sub _hash
{
my $ha;
my $line=$_[0];
my @arr=split(" ",$line);
map {$ha->{$_}=1 } @arr;
$ha;
}
