#!/usr/bin/perl
use FindBin;
BEGIN { chdir $FindBin::Bin };

BEGIN { 
    if( $ENV{PERL_CORE} ) {
        chdir '../lib/CPANPLUS' if -d '../lib/CPANPLUS';
        unshift @INC, '../../../lib';
    
        ### fix perl location too
        $^X = '../../../t/' . $^X;
    }
} 


### include lib to @INC ###
BEGIN { 
    use File::Spec;
    use vars qw[@ORIG_INC];
    @ORIG_INC = @INC;       # store for later use

    require lib;
    my $l = 'lib'; $l->import( qw[lib], File::Spec->catdir(qw[inc bundle]) );

    $l->import('../../lib' ) if $ENV{PERL_CORE}
}


### we /need/ perl5.6.1 or higher -- we use coderefs in @INC,
### and 5.6.0 is just too buggy
use 5.006001;


use strict;
use CPANPLUS::inc;
use Config;
use File::Copy                  qw[copy];
use IPC::Cmd                    qw[can_run];
use Module::Load::Conditional   qw[check_install];
use ExtUtils::MakeMaker;
use CPANPLUS::Internals::Constants;
use inc::Module::Install;

use constant BASIC_TESTS =>     qq[t/00_CPANPLUS-Internals-Utils.t];

###################################################################

require Term::UI;
require Term::ReadLine;
require Locale::Maketext::Simple;

require CPANPLUS::Configure;
require CPANPLUS::Configure::Setup;

Locale::Maketext::Simple->import(
    Class => 'CPANPLUS',
    Style => 'gettext',
);

### we need to auto_install() stuff still, because the included modules
### are just for b-strapping; $AutoInstall will be used to control that
my $ConfigObj;      # config object
my $AutoInstall;    # flag to really perform autoinstallation
my $HasPrev;        # flag to indicate a config from previous versions found
my $HasOld;         
my $RunSetup;       # should we run setup at all?
my $Prereq_pm = {}; # any prereqs we find we have
my $JFDI;           # just write the bloody makefile.pl already


### first, look for SETUP=1 or SETUP=yes, AUTOINSTALL=.., JFDI=.. in @ARGV
{   foreach my $arg (@ARGV) {
        $RunSetup    = (($1 =~ /[1yY]/) ? 1 : 0) 
                                    if $arg =~ /^SETUP=(.)/i;
        $AutoInstall = (($1 =~ /[1yY]/) ? 1 : 0) 
                                    if $arg =~ /^AUTOINSTALL=(.)/i;
        $JFDI        = (($1 =~ /[1yY]/) ? 1 : 0) 
                                    if $arg =~ /^JFDI=(.)/i;
    
    }

    ### removes the SETUP=* and AUTOINSTALL=*, JFDI=* to make 
    ### MakeMaker happier
    @ARGV = grep { $_ !~ /^(?:SETUP|AUTOINSTALL|JFDI)=./i } @ARGV;

    ### this also means Just Figure It Out
    $AutoInstall = 1 if $ENV{PERL_MM_USE_DEFAULT};
}

### just f***ing do it
if( $JFDI ) {
     $ConfigObj = CPANPLUS::Configure->new;
    write_makefile(); 
    exit;
}


### there's issues with redhat 9.0's stock perl -- they applied some
### custom patches on their 5.8.0 and it breaks use constant a => sub {};
if( $^O eq 'linux' and -e '/etc/redhat-release' and 
    $] == '5.008' and (grep /Red Hat, Inc/, values %Config::Config)
) {
    print loc("
### IMPORTANT! ######################################################

You are using perl $] supplied by RedHat, who have applied custom
patches that break various perl modules, including this one.

You will have to migrate to a perl without these flaws. You could
do this for example by building a perl installation by hand. 
You can obtain the sources from www.cpan.org.

We're sorry for the inconvenience.

#####################################################################

    ") . $/;

    require 5.008001;
}

print loc("
### PLEASE NOTE ###################################################

CPANPLUS will be shipped alongside CPAN.pm in the 5.10 core. 
Although you should *NOT* expect it to work just like CPAN.pm, 
there is a compatible shell available. See perldoc CPANPLUS::Shell 
after installation

You are strongly urged to configure CPANPLUS now, since otherwise
non-privileged (non-root) users may be unable to use CPANPLUS until
you configure it properly.

###################################################################
");

### check if we found some config that we can use as a base config;
### if not, put a copy of the config.pm-orig in place;
if( $HasPrev = is_configured() ) {

    ### tell the user where we found the previous config;
    ### XXX this doesn't take into account any environment settings
    #my $where = $INC{'CPANPLUS/Config.pm'} || local_config();
    #print "\n\tExisting config found at '$where'\n\n" if -e $where;

} else {
    my $lc = local_config();
    
    my $require = -e $lc ? $lc : $lc . '-orig';
    
    ### you might already have a config.pm generated by a 
    ### previous invocation of perl Makefile.PL
    #unless( $HasOld ) {
    #    copy( $lc.'-orig', $lc )
    #        or die loc("Cannot write to %1", $lc );
    #}
    
    ### now we read in the config from the local tree 
    ### note that is_configured() may have already require another
    ### CPANPLUS::Config too, and we don't want it to start warning about 
    ### redefined subroutines
    {   local $^W; 
        require $require; 
        
        ### we may have loaded from -orig, means we have to prented we
        ### loaded .pm as well
        $INC{'CPANPLUS/Config.pm'} = $INC{'CPANPLUS/Config.pm-orig'}
            if $require ne $lc;
    }      
}


### by now we have required a workable CPANPLUS::Config, which we can
### pass to setup.pm's constructor.
my $term = Term::ReadLine->new('');
if( setup_needed() ) {
    $ConfigObj = CPANPLUS::Configure->new;

    unless( CPANPLUS::Configure->_config_version_sufficient ) {
        die "\n\nConfig and CPANPLUS version are non-compatible!\n" .
            "Please remove your config (". $INC{'CPANPLUS/Config.pm'} .
            ") and try again!\n\n";
    }

    my $setup = CPANPLUS::Configure::Setup->new(
                    term                => $term,
                    configure_object    => $ConfigObj,
                    autoreply           => $AutoInstall,
                );

    $setup->use_previous( $HasPrev ? 1 : 0 );
    
    $setup->init or die loc("Setup failed");
    
    write_makefile();

### you don't want to set up ###
} elsif ( $HasOld ) {
    write_makefile();

} else {
    print loc("Skipping setup; Advanced tests disabled!");
    
    ### XXX what to do with the tests??? ###
    write_makefile( BASIC_TESTS );
}    

### check if the user wants to run setup ###
sub setup_needed {
    my $run_setup = $RunSetup;

    ### removes the SETUP=* and AUTOINSTALL=* to make MakeMaker happier
    if (defined $run_setup) {  
    
    ### can't tell from @ARGV, so ask the user instead
    } else {     
        my $prompt = (
            $HasPrev ? loc("Use previous settings to configure CPANPLUS?") :
            $HasOld  ? loc("Old settings detected. Do you " .
                            "want to modify them?")
                      : loc("Do you want to configure CPANPLUS now?")
        );
    
        $run_setup = $AutoInstall || $term->ask_yn(
            prompt  => $prompt,
            default => (($HasOld and not $HasPrev) ? 'n' : 'y'),
        );
    
        print loc("Okay, existing settings are preserved") . $/
            unless $run_setup;
    
    }
    
    ### ok, if you have previous settings, but you don't want to 
    ### manually reconfigure, then we still have to run setup, 
    ### just automatically.
    if( $HasPrev and !$run_setup ) {
        $AutoInstall = 1; $run_setup = 1;
    }
    
    return $run_setup;
}

sub is_configured {
    ### perhaps you ran perl Makefile.PL already, and there's a 
    ### config.pm in this tree. In that case, we should use it.
    ### if the fie exists, and the file size is not the same as the
    ### config template, we'll assume you configured it.
    my $local_conf = local_config();
    return $HasOld = 1 if -e $local_conf and 
                          (-s $local_conf != -s $local_conf."-orig");    
    
    ### no config found in the local tree, let's go looking on the rest
    ### of the filesystem
    ### silence any error coming out of this, 
    my $load_ret = eval {  local $CPANPLUS::Error::ERROR_FH;
            CPANPLUS::Configure->_load_cpanplus_config };
   
    ### so we couldn't load a suitable config ###
    return 0 if ($@ || !$load_ret);
    
    ### ok, we found a config.pm, but is it a high enough version? 
    return 1 if CPANPLUS::Configure->_config_version_sufficient;

    ### all failed, no config.pm found ###
    return 0;
}    
    
sub local_config { return File::Spec->catfile(qw|lib CPANPLUS Config.pm|); }

sub write_makefile {
    my $tests = shift;

    my $string;
    my $mods = CPANPLUS::inc->interesting_modules;
    for my $mod ( sort keys %$mods ) {
        $string .= sprintf( "\t%-26s %-8s\n", $mod, $mods->{$mod} );
    }       

    print loc("
### PLEASE NOTE ###################################################

Since CPANPLUS 0.050 has a few prerequisites that are not core
perl (yet), they are bundled with the distribution for boot-
strapping purposes.

You should install these prerequisites before continueing to
install CPANPLUS. You can use the bootstrapped CPANPLUS to do
this for you with the following command:

    %1

###################################################################
    
    ", "$^X bin/cpanp-boxed -i --force Bundle::CPANPLUS::Dependencies" );  


    $Prereq_pm = { %$Prereq_pm, %$mods };

    ### depending on your choices, we might need to add some modules
    ### to your PREREQ_PM
    {   if( $ConfigObj && !$ConfigObj->get_conf('prefer_makefile')  ) {
            $Prereq_pm->{ 'CPANPLUS::Dist::Build' } = '0.01';
        }
    
        
        if( $^O eq 'MSWin32') {
            $Prereq_pm->{ 'Win32::Process' } = 0;
        }
    }


    ### we use 'no_plan' in our tests -- older T::H, like the one shipped
    ### with perl5.6.1 can't cope with that. So if the version of T::H
    ### is too old, we print a warning and use only the basic test
    ### which uses a proper plan
    {   eval "use Test::Harness 2.28";

        if( $@ ) {
            print loc("
### IMPORTANT #####################################################

Your version of '%1' is too old. You need at least 
version '%2' to run all of the CPANPLUS tests. 

For your convenience a more recent version is bundled with this 
module, in the following directory:

    '%3'
    
Please add this to your path and reinvoke this program, or ideally
upgrade your version of '%4' before installing CPANPLUS.

For now, we will run only the basic tests that will run safely 
under your version.

###################################################################

",  'Test::Harness', '2.28', 't/inc/harness', 'Test::Harness' );
            
            $tests = BASIC_TESTS;
        }
    }        

    ### to make sure all warnings align nicely again
    print "\n\n";

    ### restore the original @INC, so proper probing of missing 
    ### prereqs can be done
    @INC = @ORIG_INC;
    name            ('CPANPLUS');
    author          ('Jos Boumans <kane@cpan.org>');
    abstract        ('Ameliorated interface to the CPAN');
    version_from    ('lib/CPANPLUS/Internals.pm');
    license         ('perl');
    no_index        ( directory => 'lib/CPANPLUS/inc' );
    install_script  ($_) for glob('bin/*');
    requires        (%$Prereq_pm);
    makemaker_args  ( test => { TESTS => $tests } ) if $tests;
    makemaker_args  ( clean => { FILES => 't/.*.output' } );

    ### write the makefile 
    ### this makes all prereqs rediscovered
    {   use Module::Loaded;
        for ( keys %{ CPANPLUS::inc->interesting_modules } ) {
            mark_as_unloaded( $_ ) if is_loaded( $_ );
        }            
        
        ### silence warnings about redefines... 
        ### this will still warn about redefine of CONSTANTS subs...
        no warnings; local $^W;
        &WriteAll( check_nmake => 1 ); 
    }

    print loc("Now, please type '%1' to test, and '%2' to install.",
              "$Config{make} test", "$Config{make} install"), "\n";

    ### make an educated guess of whether we'll need root permission.
    ### here '$>' needs to be in eval"" because some platforms don't 
    ### support it, and will die promptly just by seeing that variable.
    ### XXX not installing any dependencies now, so don't bother warning
    ### either
    #if (eval '$>' and $AutoInstall) {
    #    print loc("You may need to do that as the 'root' user to " .
    #              "install dependencies."), "\n";
    #}
}

__END__


