#!/usr/bin/env perl

use 5.010;
use strict;
use warnings;

package Medical::Growth::NHANES_2000::Weight_for_Age::Child::Male;

our ($VERSION) = '1.00';

use Moo::Lax;    # Vanilla Moo considered harmful

extends 'Medical::Growth::NHANES_2000::Base';

__PACKAGE__->_declare_params_LMS;

1;

# wtage, sex = 1

__DATA__

24	-0.20615245	12.6707633	0.108125811
24.5	-0.216501213	12.74154396	0.108166006
25.5	-0.239790488	12.88102276	0.108274706
26.5	-0.266315853	13.01842382	0.108421025
27.5	-0.295754969	13.1544966	0.10860477
28.5	-0.327729368	13.28989667	0.108825681
29.5	-0.361817468	13.42519408	0.109083424
30.5	-0.397568087	13.56088113	0.109377581
31.5	-0.434520252	13.69737858	0.109707646
32.5	-0.472188756	13.83504622	0.110073084
33.5	-0.510116627	13.97418299	0.110473254
34.5	-0.547885579	14.1150324	0.1109074
35.5	-0.58507011	14.25779618	0.111374787
36.5	-0.621319726	14.40262749	0.111874514
37.5	-0.656295986	14.54964614	0.112405687
38.5	-0.689735029	14.69893326	0.112967254
39.5	-0.721410388	14.85054151	0.11355811
40.5	-0.751175223	15.00449143	0.114176956
41.5	-0.778904279	15.16078454	0.114822482
42.5	-0.804515498	15.31940246	0.115493292
43.5	-0.828003255	15.48030313	0.116187777
44.5	-0.849380372	15.64343309	0.116904306
45.5	-0.86869965	15.80872535	0.117641148
46.5	-0.886033992	15.97610456	0.118396541
47.5	-0.901507878	16.14548194	0.119168555
48.5	-0.915241589	16.31676727	0.11995532
49.5	-0.927377772	16.4898646	0.120754916
50.5	-0.938069819	16.66467529	0.121565421
51.5	-0.94747794	16.84109948	0.122384927
52.5	-0.955765694	17.01903746	0.123211562
53.5	-0.963096972	17.1983908	0.124043503
54.5	-0.969633434	17.37906341	0.124878992
55.5	-0.975532355	17.56096245	0.125716348
56.5	-0.980937915	17.74400082	0.126554022
57.5	-0.986006518	17.92809121	0.127390453
58.5	-0.99086694	18.11315625	0.128224294
59.5	-0.995644402	18.29912286	0.129054277
60.5	-1.000453886	18.48592413	0.129879257
61.5	-1.005399668	18.67349965	0.130698212
62.5	-1.010575003	18.86179576	0.131510245
63.5	-1.016061941	19.05076579	0.132314586
64.5	-1.021931241	19.24037019	0.133110593
65.5	-1.028242376	19.43057662	0.133897752
66.5	-1.035043608	19.62136007	0.134675673
67.5	-1.042372125	19.8127028	0.13544409
68.5	-1.050254232	20.0045944	0.13620286
69.5	-1.058705595	20.19703171	0.136951959
70.5	-1.067731529	20.39001872	0.137691478
71.5	-1.077321193	20.58356862	0.138421673
72.5	-1.087471249	20.77769565	0.139142773
73.5	-1.098152984	20.97242631	0.139855242
74.5	-1.10933408	21.16779192	0.140559605
75.5	-1.120974043	21.36383013	0.141256489
76.5	-1.133024799	21.56058467	0.141946613
77.5	-1.145431351	21.75810506	0.142630785
78.5	-1.158132499	21.95644627	0.143309898
79.5	-1.171061612	22.15566842	0.143984924
80.5	-1.184141975	22.35583862	0.144656953
81.5	-1.197307185	22.55702268	0.145327009
82.5	-1.210475099	22.75929558	0.145996289
83.5	-1.223565263	22.9627344	0.146666
84.5	-1.236497304	23.16741888	0.147337375
85.5	-1.249186293	23.37343341	0.148011715
86.5	-1.261555446	23.58086145	0.148690256
87.5	-1.273523619	23.78979096	0.149374297
88.5	-1.285013783	24.00031064	0.150065107
89.5	-1.295952066	24.21251028	0.150763933
90.5	-1.306268473	24.42648043	0.151471982
91.5	-1.31589753	24.642312	0.152190413
92.5	-1.324778843	24.86009596	0.152920322
93.5	-1.332857581	25.07992303	0.153662731
94.5	-1.340080195	25.30188584	0.154418635
95.5	-1.346412105	25.52606977	0.155188768
96.5	-1.351813296	25.75256528	0.155973912
97.5	-1.356253969	25.9814599	0.156774684
98.5	-1.359710858	26.2128399	0.157591579
99.5	-1.362167159	26.44679027	0.158424964
100.5	-1.363612378	26.68339457	0.159275071
101.5	-1.364042106	26.92273494	0.160141995
102.5	-1.363457829	27.16489199	0.161025689
103.5	-1.361865669	27.40994539	0.161925976
104.5	-1.35928261	27.65796978	0.162842452
105.5	-1.355720571	27.90904433	0.163774719
106.5	-1.351202536	28.16324264	0.164722138
107.5	-1.345754408	28.42063744	0.165683945
108.5	-1.339405453	28.68130005	0.166659247
109.5	-1.332188093	28.94530029	0.167647017
110.5	-1.324137479	29.21270645	0.168646104
111.5	-1.315291073	29.48358527	0.169655235
112.5	-1.30568824	29.75800198	0.170673022
113.5	-1.295369867	30.03602021	0.17169797
114.5	-1.284374967	30.31770417	0.17272854
115.5	-1.272750864	30.60311107	0.173762961
116.5	-1.260539193	30.89230072	0.174799493
117.5	-1.247783611	31.18532984	0.175836284
118.5	-1.234527763	31.48225315	0.176871417
119.5	-1.220815047	31.78312329	0.177902912
120.5	-1.206688407	32.08799062	0.17892874
121.5	-1.19219015	32.39690313	0.17994683
122.5	-1.177361786	32.7099062	0.180955078
123.5	-1.162243894	33.02704244	0.181951361
124.5	-1.146876007	33.34835148	0.182933537
125.5	-1.131296524	33.67386973	0.183899465
126.5	-1.115542634	34.00363017	0.184847006
127.5	-1.099650267	34.33766207	0.185774041
128.5	-1.083654055	34.67599076	0.18667847
129.5	-1.067587314	35.01863732	0.187558229
130.5	-1.051482972	35.36561737	0.18841128
131.5	-1.035367321	35.71694723	0.189235738
132.5	-1.019277299	36.07262569	0.190029545
133.5	-1.003235326	36.43265996	0.190790973
134.5	-0.987269866	36.79704392	0.191518224
135.5	-0.971406609	37.1657671	0.192209619
136.5	-0.955670107	37.53881268	0.192863569
137.5	-0.940083834	37.91615721	0.193478582
138.5	-0.924670244	38.2977703	0.194053274
139.5	-0.909450843	38.6836143	0.194586368
140.5	-0.894446258	39.07364401	0.195076705
141.5	-0.879676305	39.46780643	0.195523246
142.5	-0.865160071	39.86604044	0.195925079
143.5	-0.850915987	40.26827652	0.196281418
144.5	-0.836961905	40.67443658	0.196591612
145.5	-0.823315176	41.08443363	0.19685514
146.5	-0.809992726	41.49817164	0.19707162
147.5	-0.797011132	41.91554528	0.197240806
148.5	-0.784386693	42.33643978	0.197362591
149.5	-0.772135506	42.76073078	0.197437004
150.5	-0.760273528	43.18828419	0.19746421
151.5	-0.748815968	43.61895703	0.197444522
152.5	-0.737780398	44.0525931	0.197378345
153.5	-0.727181568	44.48903027	0.197266263
154.5	-0.717035494	44.92809483	0.197108968
155.5	-0.707358338	45.36960315	0.196907274
156.5	-0.698166437	45.81336172	0.196662115
157.5	-0.689476327	46.25916729	0.196374538
158.5	-0.68130475	46.70680701	0.196045701
159.5	-0.673668658	47.15605863	0.195676862
160.5	-0.666585194	47.60669074	0.19526938
161.5	-0.660069969	48.05846572	0.19482473
162.5	-0.654142602	48.51113138	0.19434441
163.5	-0.648819666	48.96443224	0.193830046
164.5	-0.644118611	49.41810374	0.193283319
165.5	-0.640056805	49.87187409	0.192705974
166.5	-0.636651424	50.32546478	0.192099812
167.5	-0.633919328	50.77859121	0.191466681
168.5	-0.631876912	51.23096332	0.190808471
169.5	-0.63053994	51.68228625	0.190127105
170.5	-0.629923353	52.13226113	0.18942453
171.5	-0.630041066	52.58058583	0.188702714
172.5	-0.630905733	53.02695588	0.187963636
173.5	-0.632528509	53.47106525	0.187209281
174.5	-0.634918779	53.91260737	0.18644163
175.5	-0.638083884	54.35127608	0.185662657
176.5	-0.642028835	54.78676659	0.184874323
177.5	-0.646756013	55.21877657	0.184078567
178.5	-0.652262297	55.64701131	0.183277339
179.5	-0.658551638	56.07116407	0.182472427
180.5	-0.665609025	56.49095862	0.181665781
181.5	-0.673425951	56.90610886	0.18085918
182.5	-0.681987284	57.31634059	0.180054395
183.5	-0.691273614	57.72138846	0.179253153
184.5	-0.701261055	58.12099696	0.178457127
185.5	-0.711921092	58.51492143	0.177667942
186.5	-0.723218488	58.90293208	0.176887192
187.5	-0.735121189	59.28479948	0.176116307
188.5	-0.747580416	59.66032626	0.175356814
189.5	-0.760550666	60.02931704	0.174610071
190.5	-0.773984558	60.39158721	0.173877336
191.5	-0.787817728	60.74698785	0.173159953
192.5	-0.801993069	61.09536847	0.172459052
193.5	-0.816446409	61.43660077	0.171775726
194.5	-0.831110299	61.77057372	0.171110986
195.5	-0.845914498	62.09719399	0.170465756
196.5	-0.860786514	62.41638628	0.169840869
197.5	-0.875652181	62.72809362	0.169237063
198.5	-0.890436283	63.03227756	0.168654971
199.5	-0.905063185	63.32891841	0.168095124
200.5	-0.91945749	63.61801537	0.16755794
201.5	-0.933544683	63.89958662	0.167043722
202.5	-0.947251765	64.17366943	0.166552654
203.5	-0.960507855	64.44032016	0.166084798
204.5	-0.973244762	64.69961427	0.16564009
205.5	-0.985397502	64.95164625	0.165218341
206.5	-0.996904762	65.1965295	0.164819236
207.5	-1.007705555	65.43440186	0.16444238
208.5	-1.017756047	65.66540015	0.164087103
209.5	-1.027002713	65.88970117	0.163752791
210.5	-1.035402243	66.10749114	0.163438661
211.5	-1.042916356	66.31897311	0.163143825
212.5	-1.049511871	66.52436618	0.162867311
213.5	-1.055160732	66.72390443	0.162608072
214.5	-1.059840019	66.91783563	0.162365006
215.5	-1.063531973	67.10641956	0.162136973
216.5	-1.066224038	67.28992603	0.161922819
217.5	-1.067908908	67.46863255	0.161721398
218.5	-1.068589885	67.64281378	0.16153153
219.5	-1.068261146	67.8127675	0.161352313
220.5	-1.066933756	67.97877331	0.161182785
221.5	-1.064620976	68.14111022	0.161022184
222.5	-1.061341755	68.30004741	0.160869943
223.5	-1.057116957	68.4558454	0.160725793
224.5	-1.051988979	68.60872174	0.160589574
225.5	-1.04599033	68.75889263	0.1604617
226.5	-1.039168248	68.90653028	0.160342924
227.5	-1.031579574	69.05176427	0.160234478
228.5	-1.023291946	69.19467288	0.160138158
229.5	-1.014385118	69.33527376	0.160056393
230.5	-1.004952366	69.47351373	0.159992344
231.5	-0.995101924	69.60925782	0.159949989
232.5	-0.984958307	69.74227758	0.159934231
233.5	-0.974663325	69.87223885	0.159951004
234.5	-0.964376555	69.99868896	0.160007394
235.5	-0.954274945	70.12104381	0.160111769
236.5	-0.944551187	70.23857482	0.160273918
237.5	-0.935410427	70.35039626	0.160505203
238.5	-0.927059784	70.45546105	0.160818788
239.5	-0.919718461	70.55252127	0.161229617
240	-0.91648762	70.59761453	0.161476792

__END__

=head1 NAME

Medical::Growth::NHANES_2000::Weight_for_Age::Child::Male

=head1 SYNOPSIS

  use Medical::Growth::NHANES_2000;
  Medical::Growth::NHANES_2000->find_measure_class(
    ages => 'Child', sex => 'Male',
    measure => 'Weight for Age')->pct_for_value($wt,$age);

=head1 DESCRIPTION

This class provides the NHANES 2000 parameters for weight-for-age
tables for boys ages 2-20 years.

Weight values are expressed in kilograms, and ages in months.

For details of the methods provided to operate on observations, please see
L<Medical::Growth::NHANES_2000::Base>.  For overall information on use of
the NHANES 2000 system, please see L<Medical::Growth::NHANES_2000>.

=head1 VERSION

version 1.00

=head1 AUTHOR

Charles Bailey <cbail@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2012-2014 Charles Bailey.

This software may be used under the terms of the Artistic License or
the GNU General Public License, as the user prefers.

=head1 ACKNOWLEDGMENT

The code incorporated into this package was originally written with
United States federal funding as part of research work done by the
author at the Children's Hospital of Philadelphia.

=cut
