=encoding iso-8859-1

=cut

package Acme::MetaSyntactic::donmartin;
use strict;
use Acme::MetaSyntactic::List;
our @ISA = qw( Acme::MetaSyntactic::List );
our $VERSION = '1.004';
__PACKAGE__->init();

our %Remote = (
    source  => 'http://madcoversite.com/dmd-alphabetical.html',
    extract => sub {
        return
            # split a few items that are way too long
            map /CHIRP_TIK_TIK_KRIK_BREET_BREET_TOOD_TOOD_KRIDIT_KRIDIT_BREET/
                ? ( substr( $_, 0, 163 ), substr( $_, 164 ) )
                : $_,
            map /TIKAK_KAK_BINGCHIKA_CHUNK_THWIZZIK_ZAK/
                ? ( substr( $_, 0, 164 ), substr( $_, 165 ) )
                : $_,

            # pick and clean up items from the HTML table
            map {
                s/\s+/ /g;

                # remove HTML
                s/<[^>]+>//g;
                s/&(?:hellip|nbsp);/_/g;
                s/\(etc\. etc\.\)//g;

                # do the "n times" math, but shorten items that are too long
                s/twice/2 times/;
                s/four times/4 times/;
                s/nine times/9 times/;
                s/eleven times/11 times/;
                s/52 times/24 times/;
                s/FOOM FWEE BOOM DOOM DING \(12 times\)/FOOM FWEE BOOM DOOM DING \(10 times\)/;
                s/(.*?)\([^\)\d]*?(\d+) times[^\)]*\)/$1x$2/eg;

                # remove unsightly characters
                y/-_ !'.,/_/s;
                s/^_+|_+$//g;

                # send the final result
                $_;
            }
            $_[0] =~ m!<tr[^<]+<td[^<]+<font[^<]+size=4>\s*(.*?)\s*</font>!igs;
    },
);

1;

=head1 NAME

Acme::MetaSyntactic::donmartin - The Don Martin theme

=head1 DESCRIPTION

The sound effects from Don Martin's comics.

The comprehensive list is found on Doug Gilford's Mad Cover Site:
L<http://www.madcoversite.com/dmd.html>.

=head1 CONTRIBUTOR

Vahe Sarkissian.

=head1 CHANGES

=over 4

=item *

2016-03-21 - v1.004

Updated from the source web site in Acme-MetaSyntactic-Themes version 1.049.

In the source material, several items that were listed independently have
been merged together.

=item *

2013-10-14 - v1.003

Updated from the source web site in Acme-MetaSyntactic-Themes version 1.037.

One very long item (367 characters) is split in two smaller ones.

=item *

2012-06-04 - v1.002

Updated the source URL, and updated the data from the source web site
in Acme-MetaSyntactic-Themes version 1.004.

=item *

2012-05-14 - v1.001

Updated with an C<=encoding> pod command
in Acme-MetaSyntactic-Themes version 1.001.

=item *

2012-05-07 - v1.000

Received its own version number in Acme-MetaSyntactic-Themes version 1.000.

=item *

2006-07-24

Updated from the online list in Acme-MetaSyntactic version 0.84.

=item *

2006-01-30

Flavio Poletti told me that a few onomatopoeias were missing. I didn't
add them, but made the list updatable from the original list URL.
I had to cut two items that were more than 251 character long, so that
list items are still valid Perl identifiers.

List entirely updated in Acme-MetaSyntactic version 0.59.

=item *

2005-03-28

Duplicates removed in Acme-MetaSyntactic version 0.15.

=item *

2005-01-14

Introduced in Acme-MetaSyntactic version 0.03.

=back

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::List>.

=cut

__DATA__
# names
AAAAGH_EEEEEOOOW_ACK_UGH_UGH_MMP_AGH_AEEK
AAAK_AAK
AAEEFWOFAAEE
AAHT_AAHHT_BLOOOOT
ACK_GAK_GARK
AGH_UGH_ARG
AHH_AHH_Ahh_THOONOONN
AHHHHHHHHHH
AHWEEEEEE_AK
aling
aling_aling
AOOGA_AOOOGA_AOOOGA_AOOGA
APPLAUD_YEA
ARARAGH
ARARGH
ARGLE_GLARGLE_GLORGLE_GLUK
ARRARGH_WAMP_BLAMP_OOF_YUG
ARRARGH_YAK_FITZROWER_RIP
ARRARGH_RIP_TEAR
ARRARGHNNARRGH
ARRARGLE
AWK
AWK_GAK_ARGH_GASP
B_B_B_BORFFT
BAHOO_BAHOO_BAHOO
BAM_BAM_BOOM_BOOM
BAM_BAM_BAM_BAM_BAM
BAM
BAP
BAP_KRAK_KIK_HIT
BARF_BARF
BBFRPRAFPGHPP
BBLLBBLLBBLLBBLLBBLL
BEEYOOP
BING_BING_BING_BING_BING
BING_BING_BING_BING_BING_BING_BING_BING_BING_BING_BING_BING
BING_BONG
BIZZZT
BLAM
BLAM_BAM_BAM_BLAM
BLAM_BLAM
BLAM_BLAM_BLAM
BLAM_BLAM_PoiT
BLAM_BLOOM_BLAM_BLOOM
BLAM_PLOOM_TATTATATTAT_PWEEN_PHOON_KRAK_PATWEEEE_PLAM_KAKKAKKAKAK_PLOOMPLOOMPLOOM
BLAMP_BLAMP
BLEEGH_YAAUGH_RAWGH_BRAGHK_SPROP_BLOP_BLOP_GUKGUK_BWAUGHK_GYAAUGHT_BLOBBLE_SPLOP_BLAP_BLAP_BEAUGH_GUWK_SPLAPPLE_PLAP_SPLORPLE_BLAPPLE
BLEEP
BLIB_BLIB_BLIB_BLIB
BLINK_BLINK
BLiNK_BLiNK
BLINK_BLONK_BLINK_BLONK
BLIOMP
BLIT
BLOIT
BLOOM_BLOOM
BLOOP
BLORP
BLUB_BLUB_BLUB_BLUB
BLUB_BLUB_BLUB_BLUB_BLUB
BONG
BONG_BONG_BONG_BONG_BONG_BONG_BONG
BONG_BONG_BONG_BONG_BONG_BONG_BONG_BONG
BOOM
BOOMA_DOOMA_BOOMA_DOOMA_BOOMA_DOOMA_BOOMA_DOOMA
BOOMER_ROOM
BPLFLT
BRAK_GRAK
BRAP
BRAVO_BRAVO
BRAVO_BRAVO_BRAVO
BRAVO_BRAVO_HOORAY_BRAVO_YIPPEE
BREET_BREET_TOOD_TOOD
BRING
BRING_A_LING
BRLFFSP
BRNNGT_BRNNGT
BROOM
BROOM_GROOM_BROOM
BROOM_PUCKA_PUCKA_PUCKA_BROOM_PUCKA_PUCKA
BRRRAPP
BRRRNNG_BRRRNNG
BUKKIDA_BUKKIDA_BAKKIDA_BAKKIDA_BUKKIDA_BUKKIDA_BAKKIDA_BAKKIDA
BUR_RP
BURP
BWEEP
BZOWNT
BZZNNT
BZZOWNT
BZZT_BZZT
BZZZ_BZZT
BZZZT_CHUNKA_CHUNKA_ZIKKIK_ZIKKIK_FWEEN_ZOOKA_ZOOKA
BZZZT_KLIK_KLIK_KLIK_KLIK_KLIK_KLIK_GAZOWNT_GAZIKKA
BZZZT_WHiR_SCREEEEZT
CAW_CAW_CAW
CHAKA_CHAKA_CHAKA_CHAKA
CHAKUNK_DING_RIP
CHEEOMP_CHOMP_CHOMP_CHOMP
CHIKA_CHUNK_KLIK_SPUKKONK_SPUTZ_SPAZAT_KLOON_SPOP_SPOP_SPOP_KAZOP_KLOON_PUTT_PUTT_PUTT_SPOP_KLOON_PUTT_KALLOON
CHIMP_CHIMP
CHIP_CHIP_CHIP_CHIP
CHIRP_TIK_TIK_KRIK_BREET_BREET_TOOD_TOOD_KRIDIT_KRIDIT_BREET_BROOT_TIKA_TIKA_CHEEP_KIKATIK_BLIDIT_TOOWIT_TOOWOO_KATY_DID_KATY_DIDN_T_JUGARUM_HOOT_KRIK_KRIKIT_BREEP
BREEP_TIK_TIKA_BEEDOOP_GLOOT_GLOOT_GLIKA_GLIKA_TIKATIK_CHIRP_GLEET_GLEET_WHOOOOOOOO_BREEBEEP_BREEDEET_BROODOOT
CHK_CHK_CHA_GONK_BRBBRBBRING
CHOMP
CHOMP_CHOMP
CHOMP_CHOMP_CHOMP
CHOMP_CHOMP_CHOMP_CHOMP_CHOMP_CHOMP_CHOMP
CHOMP_CHOMP_GLUK_CLOMP
CHOMP_CHOMP_URP_SLURP_GLURK
CHOMP_CHOMPLE_SLURP_GLUP
CHOMP_GLORK_GLURKLE_CHOMP
CHOMP_GLORT_CHONK_SHLURP
CHOMP_GLUKKLE_SHLORP
CHOMP_CHOMP_CHOMP_CHOMP
CHONK
CHONK_CHONK_CHONK
CHONK_KRAKLE_GLUK
CHOOK_CHOOK_CHOOK_CHOOK
CHOP_CHOP_CHOP_CHOP
CHOP_CHOP
CHUGA_CHUGA_CHUGA_CHUGA
CHUNK
CHUNK_KASHINK_CHUNK_KASHINK_CHUNK_KASHINK_CHUNK_KASHINK
CLACK_CLACK_CLATTER_CLATTER
CLANG
CLANG_CLANG_CLANG
CLAP_CLAP_CLAP_CLAP_CLAP_CLAP_CLAP_CLAP_CLAP_CLAP_CLAP
CLAP_CLAP_CLAP_CLAP_CLAP
CLAP_CLAP_CLAP_CLAP_CLAP_CLAP_CLAP_CLAP_CLAP
CLAP_CLAP_CLAP_CLAP_CLAP_CLAP_CLAP_CLAP_CLAP_CLAP
CLAP_CLAP
CLAP_CLAP_CLAP_CLAP
CLATTA_CAK_CLAKA
CLICK
CLIK_CLIK
Clik_Clik
CLiK_KLAK
CLIK_RRROOOOM
CLIK_CLIK_CLIK_CLIK
CLINK
CLINK_CLOINK_BZZT
CLIP_CLAP_CLIP_CLAP_CLIP_CLAP
CLOMP_CLOMP_CLOMP_CLOMP
CLONK
CRASH_BASH_RIP_GAZAP
CRUGAZUNCH
CRUNCH
DANG
DANG_DANG_DANG_DANG_DANG_DANG_DANG_DANG_DANG
DIG_DIG_DIG_DIG_DIG
DIG_DIG_DIG_DIG_DIG_DIG
DIK_DIK_DIK_DAK_DIK_DAKKA_DAK_DAKKA_DIKKA_DIKKA_DAKKA_DIK_DIK_DAKKA_DAKKA_DAK_DIKKA_DAK
DIKKA_DIK_DEEP_DAKKA_DAKKA_DAKKA_DAK_DAK_DAGIK_DOOT_DOOT_DAK_DIK_DABWAK_DIKKA_DIKKA_DIKKA_DIKKA_OONT_DIKKADIKKA_DAGAK_DIKKA_DOOT_BWEET_DIT_DIT_DIT_GIKKADIK_DIKKA_DIKKA_DIKDOKKA_DAK_DEEP_DAKKITY_DAK_DAKKA_DAKKA_DIKKA_DIK
DIKKA_DIKKA_DIKKA
DIKKA_DIKKA_DIKKA_DAK_DIKDIKDIK_DAKKA_DAKKA_DIKKA_DIKKA_DIKKA_DAGAK_DAK_DIKKADAK_DIKKA_DIKKA_DAKDAKDAK_DAKKA_DAKKA_DEEP_DABWAK_DOOTBWEET_DAKKITYDAK_OONT_GIKKADIK_DIK_DOKKA_DAK_DEEP
DING
DING_DING_DING_DING_DING_DING_DING_DING_DING_DING_DING_DING_DING
DING_DING_DING_DING_DING
DING_DING_DING_DING_DING_DING_DING_DING
DING_DING_DING_DING_DING_DING_DING_DING_DING
DING_DING_DING_DING_DING_DING_DING_DING_DING_DING
DING_DING_DING_DING_DING_DING_DING_DING_DING_DING_DING_DING_DING_DING
DING_DING_DING_DING_DING_DING_DING_GLUK
DINGALINA_DINGALINGA
DINGALINGA_DINGALINGA
DINK_DINK_DINK_DINK
DIT
DIT_DIT_DIT_DIT_DIT
DIT_CLUNK
DOINK_DOINK_DOINK_DOINK
DOiP
DOMP_DOMP_DOMP
DOOBA_DOOBA_DEEBE_DEEBE_DOOBA_DOOBA_DEEBE_DEEBE_DOOBA_DOOBA_DEEBE_DEEBE_DOOBA_DOOBA_DEEBE_DEEBE
DOOBADOOBADOOBA
DOONT
doont
DOOOT
doop
DOOT
DRIPPLE_BLIT
DUBBA_DUBBA_DUBBA
DUBDUBDUBDUBDUBDUB
ECCH_YAACH_BARF_GAHORK
ECKECK
EEAHEEAHEEAHEEAHEEAH
EECH_YAK_OOOH_OGH_OOF_ACK_AAGH_GAAH_OGGOCK_YAAH_YARGH_OOH_THUD_GACK
EEEAAAGH
EEEEEEEEEEEEEEEEE
EEYAAAOOORRNNNNN_OHH_AHHHH_FONDLE_YEAH_MMMM_SLURP_UHHH
FABA_DABA_ZAP
FABADAP
FAGROOLANA_FASHUNK_FAGROOLANA_FASHUNK_FAGROOLANA
FAGROON_KLUBBLE_KLUBBLE
FAGROOOSH_SHUSSHH_SHPISHLE_FROOM
FAGWOOSH_SHOSSH_GOOGLOOOM_FUSH
FAP
FARRAPPGHT_FPFWORPFT_FFFPFWRAP
FASHKLORK
FERRAP
FERRIP
FFFFOOOOOOOO
FFFRRRAAPFT
FFPGHFTP
FIDIP_FIDIP
FINK
FIP_FOP_FIDDIT_FAP
FIP_FIP
FIT
FITZ_ROWR
FIZZAZZIT
FLABADAP
FLADAT
FLADIP
FLAFFLIFF
FLAK_FLOK_SWIT_GLAP
FLAP_FLAP
FLEEDLE_LEDDLE_FLORK_LAFLATCH_DOODLE_GLOODLE_PHLAKFFA_BBBLPLAST
FLIBADIP
FLIF_FLAF_FLIZAFF
FLIFF_FLIFF
fliff_fliffle_florf_sworf
FLIFFLAFF
FLIK
FLiK
FLIP
FLIP_BLAP_BLAP
FLiP_FLiP_FLiP_FliP
FLIT
FLOBA_DAP
FLOIDOIP
floof
FLOOF
FLOOF_FLOOF_FLIFFLE_FLIF
floof_floofiTy_flif_flif_flof_da_flaf
FLOON
FLOOT_THWIP_THOP_KLOP
FLOPLOPLOPLOP
FLOT
FLUK
FLUK_GROON_GROON_GROON_GROON_SPLAZITCH_SPLAZATCH
FOINSAPP
FOOF
FOOM
FOOM_FWEE_BOOM_DOOM_DING_FOOM_FWEE_BOOM_DOOM_DING_FOOM_FWEE_BOOM_DOOM_DING_FOOM_FWEE_BOOM_DOOM_DING_FOOM_FWEE_BOOM_DOOM_DING_FOOM_FWEE_BOOM_DOOM_DING_FOOM_FWEE_BOOM_DOOM_DING_FOOM_FWEE_BOOM_DOOM_DING_FOOM_FWEE_BOOM_DOOM_DING_FOOM_FWEE_BOOM_DOOM_DING
FOOMP
FOOSH
FOOSH_FWIZZISH
FOOSHT
FOOWOOM
FORCHA_GORCHA_GOOCHA_GITCHA
fordort
FOWM
FROOM
FRUGGA_DUGGA_DUGGA_DUGGA
FUMP
FUNK
FUNKADA_WUNKADA_FUNKADA_WUNKADA
FURSH_GLURGLE_GLUG_GLUG_GLUG
FURSHGLURK
FUT
FWABADAP_PLAP_PLAP_PLAP_PLAP
FWADDAPP
FWAK
FWAM
FWAP
FWAPADA_DAPADA_FWAPADA_DAPADA
FWEE
FWEEE
FWEEEEE
FWEEP_GING_GOING_WALK_DON_T_WALK_DIT_DIT_DONG_RRRRREERRR_ING_DING_DING_DING_DIN
FWIFFFFFF_FFFFFFFFFFFFFF
FWiP
FWIP
fwip
FWIP_FWAP_FWIZZAP_ZIP
FWIPADA_DIPADA_FWIPADA_DIPADA
FWiSK
FWISK
FWISK_FWISK
FWISK_FWISK_FWISKITTY_FWASK
FWISK_FWISK_FWIZZACH_FWACH_ZACHITTY_ZICH_SHAZZATZ_FWISK
FWISK_GLURK
FWIT_FWAP_ZOT_SWIT_FOOP
FWIT_THHAT_FIP_THWAT_FAP_SIT_THUMP
FWIZZ
FWOF
FWOOF
FWOOSH
FWOOSH_SPASHLE
FWOOSHSH_SPLOSH_GALOOOM_FSSSH
FWOP
FWUMP
Fxlgxtlkfxg
GA_SHKLURTZ
GA_SHPLUCT
GA_SPLORTCH
GAHOOGA_HOOGA
GALINK_GALOINK_GALINK_GALOINK
GARRARGH
GARUNK_GASPLOOSH_GARUNK_GASPLOOSH
GASHKLITZ
GASHKLITZKA
GASHKUTZGA
GASHOOK_GRUNCH
GASHPLUTZGA
GASKROOCH
GASPLUSH
GEEEN
GIGAZING
GING_GEEEN
GING_GING
GiNG_GiNG
GING_GING_THWAT
GING_GOYNG
GING_POING_SWAP_ZIT_SHTIK_FLIK_GLUT
GISHKLORK
GISHKLURK
GLADINK_BZZZT_KLADWAK_SPROINK_FWAK_KAZIK
GLANGADANG_GALOON_GLONG_GADONG
GLANK
GLAWK
GLIK_GLIK_GLIK_GLIK
GLIMP
GLiNK
GLINK
glinK
GLINK_PLINK_GLUNK_DINK
GLIP_SHPIKKLE_GLUP_GAPLORK_SHLIPP_SPLOP_GLIT_PLOBBLE_SHLORP_GLOOP_BLOP_SKLOP_SHLURP_PLiPPLE_SLOTCH_SHLOOP
GLISH_GLUTCH_ARRAGGH_YAK_BLAM_BLAM_AWK_GAROOF_GAROOF_WEEOOOEEEOOO_BLOOM_BLOOM_BLAM_BLAM_YAGGAK_WHAP_WHAP_ROWR_GROWR_RIP_MANGLE_GURGLE_GLUK
GLIT
GLIT_GLIT_GLIT
GLIT_GLIT_GLIT_GLIT
GLIT_GLIT_GLIT_GLIT_GLOYDOIP_GLIT_GLIKITY_GLIT_GLONT
GLIT_GLORT_BLEEBLE_DURP_GLIT_GLORT_BLEEBLE_DURP_GLIT_GLORT_BLEEBLE_DURP_GLIT_GLORT_BLEEBLE_DURP
GLIT_GLORT_BLEEBLE_DURP_GLIT_GLORT_BLEEBLE_DURP
GLITCH
GLOMP_GLUKKLE_SHLIK_SHLORP_CHOMP_GLUNK_GLIK_SHTORK
GLOOCHLE_GLOOCHLE_GLUTCH
GLOOK
GLOOP
GLOOP_GLOOP_GLOOP_GLOOP_GLOOP_GLOOP_GLOOP_GLUT
GLOOP_GLOOP_GLOOP_GLOIP
GLORP
GLUG_GLUG_GLUG_GLUG
GLUK
GLUK_GLUK_GLOOPLE_SPLORT
GLUK_GLUK_GLUK_GLUK
GLUNK_GLUNK_GLUNK
GLURKLE_GLOOK_GLORKLE_GLUT
GLUT
GOING_GADOING_GADANG_GLOING
GOOMA_DOOM
GORSHLE_GUSH
GRING
GROINK_RIP_RIP
GROWWWWMMM
GRRM
GRROWN
GRRR
GRRRRRR
GRUNCH_GRUNCH_GASHLIKT
GURN_GURN_GURN_GURN_GURN_GURN_GURN_GURN
GWAP
HAKKLE_SLiCE_SHLURP_BOiL_RIP_HAC_CHOMP_COOK_EAT_TEAR_CHOMPiTY_CHOMP_ETC
HAR_HAR_YUKKLE_YUK_HEE_DE_HEE_HEE_SNIKKER_CHUCKLE_HEH_HEH_HO_HA_YAHHAH
HIC_HIC_HIC_HIC_HIC_HIC_HIC_HIC_HIC_HIC_HIC_HIC_HIC
HiC_Hic_Hic_Hic
Hm_m_m_m_m_m_m_m_m_m_m_m_m_m_m
HO_HUM
Huff_puff_Hmmmm_Ahhh_Mmmmmm_Huffa_puffa_gasp
HUFFLE_PUFFLE
INKLE_KLINK
K_CHOOK
KABOOMM
KACHOO_KACHAAH_KASH_SLAPTH
KACHUGH_CHUH
KACHUNK
KACHUNK_GING_PSSSSH
KACHUNK_KACHUNKA_KACHUNK_KACHUNK_KA_BONG
KACHUNK_KKKSH
KACHUNK_SHOOK_SHOOK_SHOOK_SHOOK
KACHUNK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK
KACHUNK_TING_KACHUNK_TING
KACHUNKA
KADOONK
KAPF_KAPF_KAHIKF_KOFF_KAHAK_KAPF_GAK_GAHAK
KAPLAK_KAK_PLOOF_BARRAMM_SPA_DOW_BLUKA_BLUKA_KAKA_SPLAK_BLORT_SPAP_PLORF_GADOON_BLUT_BLUT_BLUT
KAPOOOSHSHISH
KARRAK_FIZZITZ_POW
KASHOOK_KASHOOK_KASHOOK
KASHPRITZA
KATOOF
KATOOF_THITH_THITH_THITH_PAF_FSSSSSH
KAWK_ACK_GAK
KAZASH
KCHGGHCK
KERACKK
KING_DING_PLINK
KIPF_KAPF_KOFF_KOFF
KIPF_KIPF
KISS_KISS_KISS_KISS
KITTOONG_SHKLUNK
KKCHK_CRACKLE_CRUNCH
KKCHK_FEW
KKKKKKKKKKKK_KAKROOSH
KKKSH_KKKSH
KKKSSH
KLAK
KLAK_KLAK_KLAK_KLAK
KLAK_KLAK_KLAK_KLAK_KLAK_KLAK_KLAK_KLAK_KLAK_KLAK_KLAK_KLAK
KLAK_KLAK_CLATTER_CLATTER_GLIKLE_KLIK_KLAK_GLAKKLE
KLAKADAK_SPRITZ
KLANG
KLANG_BANG_KALOONG_KLONG
KLANG_KLANG_KLANG
KLANK
KLANK_FUSHSHKLORK
KLEP_KLEP_KLIPPITY_KLEP_KLAP_KLAP_KLEP_KLEP
KLIK
KLiK
KLIK_dink
KLIK_KLAK
KLIK_KLAK_GRAK_THAK
KLIK_KLAK_KLIK_KLAK
KLIK_KLAK_ZIK_KAZAK_PLOIP
KLIK_KLIK
KLIK_KLIK_CHAKLAK
KLIK_KLIK_KLIK
KLIK_KLIK_KLIK_KLIK
KLIK_KLIK_KLIK_SKREEK_SKRAWK
KLIK_PLUF_KLIK_PLUF
KLIK_VROOM_SPOOSH
KLIK_CHIKAKLAK_CHAKLAK
KLIK_KLIK_CHAKLIK
KLiK_SPROiNG
KLIKRUNK_GLINK_CHAKUNK
KLINGDINGGOON
KLINK
KLINK_GALINK
KLINK_GLINK
KLINK_GLINK_GLUNK
KLINK_KLINK_KLINK_KLINK
KLINK_KLUNK_GADINK
KLiNK_KLiNK_KLiNK
KLINKADINK
KLIP_KLIP_KLIP_KLIP
KLOINK
KLOMP
KLOMP_KLOMP_KLOMP_KLOMP
KLONK
KLOOBADA_DOOBADA_KLOOBADA_DOOBADA
KLOON
KLOONK_KA_DOONK
KLOOONN
KLUK_GAZOONT_BLAM_BLAM
KLUK_KLUK_KLUK_KLUK_KLUK_KLUK_KLUK_KLUK
KLUMP_KLUMP_KLUMP
KLUMP_KLUMP_KLUMP_KLUMP_KLUMP_KLUMP_KLUMP_KLUMP
KLUNK
KLUNKA_CHUNKA_KLUNKA_CHUNKA
KLUP_KLUP_KLUP_KLUP
KLUPADA_KLUPADA_KLUPADA_KLUPADA_KLUPADA_KLUPADA_KLUPADA_KLUPADA
KNOCK_KNOCK_KNOCK
KooKooK_KooKooK
KOONG
KOPF_GAHOFF_PUFF_KAPF
KRAK
KRAKKLE_KRAK
KRASH
KREEK_KREEK
KREEK_KREEK_CLANK_CLANK
KRUGAZUNCH
KRUNCH
KRUNCH_KRAK_KRARKLE_CHOMP
KRUNCHLE_KRAKLE_SHKLINK_SKROTCH
KSSHFWOOM
KSSSH
KUK_UK_AK
KWAPP
KWEEE
KWEEK_KWEEK
KWOIP
KWONG
KWONK
KWOP
MAMP_SPWAT_TOK
MAP_MAP
McPWAF
MMMMM_SMACK
MMMMMMMM
MMMP_AARH_GA_SHLOIP
MMP_ARG_ECK
MMP_UGH_ARG
MMP_ARRGH
MMPH_UMPH
MOWM
NNYEEOWNNT
NOK_NOK_NOK_NOK
ONNNNNGHK_FWEEEEEEEEEEE_ONNNNNNNGHFK_FWEEEEEEEEEEE_ONNNNNGKFPK
OOMP_DOOMP
OONK_OONK_BLEEP
OOOKK_AWK
OOOOOOiiiiiiYYYYY
PADAP_PADAP_PADAP_PADAP
PAF
PAF_TOOONG
PAK_POW
PAM
PAT_PAT_PAT_PAT
PATWANG_FWEEEE
PBLRBLPSFT
PFFFT_FRACK_POP_SPROiNG_GiNG
PFFFT_FRACK_POP_SPROiNG_GiNG_PFFFT_FRACK_POP_SPROiNG_GiNG
PFLAP
PHOOM
PHOOO_PHOOO
PHWAM
PIK_PIK_PIK
PING_PING_PING_PING_PING_PING_PING_PING_PING_PING_PING_PING_PING_PING_PING_PING_PING_PING
PiNG_THWAP
PINK
PITOOIE
PiTTOO_TFFP_THOOO_THAFF_PiTTOOiE
PITTOOIE
PITTWEEN_SPLATCH_THORK_BLOOF_THLIK_GLITCH_GLUTCH_PITTWOON_PLAF_PLOOF_SPLITCH_THUK_THAP_PLOOP
PLABLABLABLAB
PLABLABLABLABL
PLAK_DAK_THUK_FRIT
PLAK_FLOP_CLATTER
PLAM
PLAM_PLAM
PLAP
PLING
PLINK_PLINK_PLINK_PLINK_PLINK_PLINK_PLINK_PLINK
plink_plink_plink_plink
PLINK_PLINK_PLONK
PLOIP
PLOiP
PLOOSH_FLAPF
PLOP
PLOP_PHELOP
PLORK
PLORK_BLUT
PLORTCH
PLUNK
PLUNK_PLUNK_PLUNK_PLUNK
PLUNK_SPLOOSH_SPLASH_SPLISH
PLURP
POFFISSS
Poing
POING
POING_GEEN_GEEN
POING_POING_POING
POiNG_THUK
POiNG_THUK_PINK
POiNG
POINK
Poink
POiNK
POiT
POIT
PoiT
POIT_DING_FOING_TWONG_PEEN
POIT_DOIT_DIT
POP
POW
PSSSH
PWADAK
PWAM
PWANG
PWOF
PWOiNG
PWOK
PWOMPF
QUACK_QUACK_QUACK_QUACK
QWACK_WAAK_WAAK
RAH_OOOM
RIKKITY_TIKKITY_RAPPA_TAP_TAP
RiNGALiNG
RIP
RIP_SLICE_SHNIKKLE_HAK
RIP_TEAR
RIP_TEAR_ARRGH_GARRGH
RiPF
ROOM
ROWM
RRIP
RRRRR
RRRRRR
RUMBLE_ROR_FAGLORK_SWOOSH
RUMBLE_RUMBLE
RUMBLE_UMBLE_RUMBLE
RUMBOOM_BLOOMA_DOOM_BOOMA_ROOMBA
SAZZIKK_ZIKZIKZIKZIKZIKZIK_ZIKZIKZIK_ZIKZIKZIK_ZIKZIKZIK
SCHKLURT
SCHLAP
SCHLEP
SCHLIP
SCHLIT
SCHLOOP
SCHLOOT
SCRAPE_SCRAPE_SCRAPE
SHIF_SHAF_SHABAMP_MAMP_SHOMPAH_BOMBAH_DIMPAH_MIMPAH_FOMP_DABOMP_GADIFF_GADIFF_GADAFF_GADAFF_GASMITCH_GASMATCH_KABOFF_FAPADDA_DAPADDA_SWIPADDA_DIPADDA_FAP_SPMAP_GAMOP
SHIK_SHIK
SHIKA_SHIKA_SHIKA
SHIKA_SHIKA_SHIKA_SHIKA
SHKALINK_SHKALOINK_SHKALINK_SHKALOINK
SHKLAZITCH_yarg
SHKLiK
SHKLIK
SHKLIK_SHKLIK_SHKLIK_SHLIKLE_SHLAK_SKLIK_SKLUSH_SHKLAKLE_SPLAK
SHKLIKSA
SHKLIKTA
SHKLITZA
SHKLiTZA
SHKLIZICH
SHKLIZORTCH
SHKLIZZITZ
SHKLIZZORTCH
SHKLOORT_THURCH
SHKLOP
SHKLORBBADORP
SHKLORP
SHKLURCH
SHKLURK
SHKWITZ_SHKWITZ
SHLOOK
SHLURK_SHLORK_MMM_SHLURK_GURGLE_AHHH_GLUKLE_GLIK
SHMUZORFT
SHNIP_SHNIP_SHNIP_SHNIP
SHOOGA_SHIK
SHOOK
SHOOK_SHOOK
SHOOK_SHOOK_SHOOK_SHOOK_SHOOK
SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK_SHOOK
SHOOKA_SHOOKA_SHOOKA
SHOOO
SHPLEP
SHPLIPLE_DROOT_GLORT
SHPLOIP
SHPOOOSH_HELP_FAGWASSHHHH_HELP_HELP_GLUKKLE_GLUK
SHPORK_YARG_FWAK
SHTIK_SHTIK_SHTIK
SHTOINK
SHTOINK_SHTOINK_SHTOINK_SHTOINK
SHUFFLE_SHIFFLE
SHUKA_SHUKA_SHUKA
SHWIK_SHWIKA_SHK_SHHHSK_SHASHWIK_SHWIKA_SHWIK_SHASH_SHAK
SILENCE_QUIET_STEALTH_HUSH_HUSHLE_SHHH_MUFFLE_NOT_A_SOUND
SIT_SIT_SIT
SITZ_SITTZLE_SIZZOTZ_KRAKLE
SITZ_SIZZLE
SIZAFITZ
SIZZLE_SITZ
SIZZLE_SITZ_SIZZATS
SKAPASCH
SKAPLUNCH
SKAPROING
SKAZEECH_SKAZOOCH_SKAZEECH_SKAZOOCH
SKIZZORFT
SKLAZONCHO
SKLERCH
SKLISHITTY_SKLOSHITTY_SKLISHITTY_SKLOSHITTY
SKLiSHK
SKLIT_SKLIT
SKLITCH
SKLITCH_SKLITCH
SKLIZZORCH
SKLOOSH
SKLORK
SKLORSH
SKLORTCH
SKLURK
SKLUSH
SKNITCH
SKRAKIT_SKRAKIT
SKRAZEECHIO
SKREEE
SKREEEE
SKREEEEE
SKREEEEE_SKREEEEE
SKREEEEEE
SKREEEEEE_SKREEEEEE
SKREEEEEE_SKREEEE
SKREEEEEEEK
SKREEEEEK
SKREEEEK
SKREEEK
SKREEGAZEETCH
SKREEK
SKREEK_SKREEK
SKREEKLE_GLEEP_SKRONK
SKREEYEEEK
SKREEYEEYEEYEEYEEK
SKRIBBLE_SKRAZITZ_SKRAZATZ
SKRICH_SKRICHA_SKRINK
SKRITCH_SKRITCH_SHOOKA_SHOOKA
SKROIK
SKROINCH
SKRONCH
SKROOM_SKREEK_SKREEK_SKREEK
SKROOOK
SKRUNCH_SKRUNCH_SKRUNCH_SKRICHA_SKRICHA_SKRICHA
SKRUNCHA_SKRUNCHA_WIZ_GA_WIZ
SKWA_BA_DAP
SKWAKO
SKWAPPO
SKWEEK_SKWEEK
SKWIK_SKWIK_SKWIK
SLOOPLE_GLIK_SPLORP
SLURK_GLURKLE_GLUP
SMAK
SMEK
SNAP
SNAP_CRUNCH_CRASH_CRUNCHLE_KRAK_SMASH_KRASH_THUMP_KRAKLE_FUSH_SPAMP
SNAP_GRASP_ZIP_PULL
SNAP_KRAK
SNAP_PLOOBADOOF
SNAP_SNAP
SNAP_SNAP_SNAP
SNIFF
SNIFF_SNIFF_SNIFF_SNIFF
SNIFFLE_SKNIFFLE_SNIFFLE_SNIF_SKNIKLE_SKLUK_SKLUKLE_SKNOSH_SNUFFLE_SHNORKLE_SLOBBLE_SOB
SNIP
SNIP_SNIP
SNIP_SNIP_SNIP_SNIP
SNiP
SPA_ZUNCH
SPALOOSH
SPAMAMP_MABBIT_FLABADAP_GONK
SPASH
SPAZOOSH_SSSSSSSST
SPITZ_SPOPPLE_SPATZ
SPLADAP
SPLADUNK
SPLAK
SPLAP
SPLASH_SPLISHLE_SPLISH_SPLOSH_SPASHLE_GLISH_SPLESH
SPLAT
SPLAZOOSH
SPLISHIDY_SPLASH_SPLADISH_SPLADISH_SPLISHIDY_SPLASHIDY_SPLAPIDY_SPLIP
SPLITCH
SPLOIT
SPLOOSH
SPLOP
SPLORK
SPLORP_BLATCH_THWIP_BLIF_PLORF_BLAP
SPLOYDOING
SPLURP
SPMAMP
SPMAP
SPOOF
SPOOSHT
SPRAZITZ
SPRAZOT_SPRAT
SPRITSITS
SPRITZ
SPRIZAWITZ
SPRIZZITZ
SPROiNG
SPROING
SPROING_GING
SPROINGACHONK
SPROiNGDOiNK
SPROWMMM
SPUSH
SPUTZ_SPITZA_CHUKKUNK_CLUNK
SPWAKO
SPWAP
SPWATCH
SSAT
SSLiT
SSSSSSSS
SSSST
STAMP_STAMP_STAMP_STAMP_STAMP_STAMP_STAMP_STAMP_STAMP_STAMP
STAMP_STAMP
STOINK_PING
STOOF
STOONG
STOOPFT
STROINGGOINK
SUT_FLUT_FLIT_FLOT
SWAP
SWIF
SWIFFLE_KASPLATCH
SWISH_FLIBADIP
SWIT
SWIT_FLIP_SNAT_GAFLOR_ZINGO_PLOOF_ZIZ_KLAK_FAZZAT_TWOP_TONK_PLIF_FLINK_FAK_POK_ETC_ETC_ETC
SWiT_PLOP
SWIT_PLOP
SWIT_SWIT_SWIZZAT_SWAT
SWIZZAK_KLAKKLE_DING
tap_tap_tap
TAP_TAP_TAP
TAP_TAP_TAP_TAP
TAP_TAP_TAP_TAP_TAP_TAP_TAP_TAP_TAP
THAP
THAP_THAP_THAP
THAP_THAP_THAP_THAP_THAP_THAP
THAPLOOF
THHHUT_THHHHT
THHLORP
THIKOOSH
ThiZ_ZiZ_ZiZ_Ziz
THLBBADUP
THLIP
THLOOP
THLUCK
THLUP
THOIK
THOiP
THOIPOING
THOMP_SKLUK_SPLATCH_GOOSH
THOO
THOO_DINK
THOO_DOOMP
THOO_DOINK
THOO_PAF
THOOF_FOING
THOOM_THOOM
THOOMP
thort
THOT
THUB_THUBBLE_THABOOP_BWAP_PLAPPLE_FAPWIP_SPWAM
THUBALUP_THUBALUP_THUBALUP
THUD
THUGAWUNK
thuk
THUMP_THUMP_THUMP_THUMP_THUMP_THUMP
THUMP_BUMP
THUMP_BUMP_KLUMP_TRUMP
THUMP_THUMP_THUMP_THUMP
THUMP
THUNCK
THUTHHHH
THWA_DAP_SPLA_MAP
THWAK
THWAK_BAK_PWADAK_KLAK
THWAK_THWAK_THWAK_THWAK
THWAP
THWAT
THWiP
THWIT
THWIZZIT
THWOCK
THWOK
THWOP
THWUK
TIK_TAKKA_TAK_TAK_TAKKAK_TIK
TIK_TIK_SKREEE
TIK_TIK_TIK_TIK
TIK_TIKKA_TIKKAK_TIKKATIKKA_TA_TAGAK_TAK_TIKKA_TIKKITY_TIK_TAKKA_TAKKA_TIKKA_TIKKA
TIKA_TIKA_TIKA_TIKA
TIKKA_TIK_TIKKA_TIKKAK_TIKKAK_TIKKIK_TIKKIK_TIKA_TIKIK_TIKKA_TIKAKADA_KAKADA_TAK_TIKIK_TIK_TIKATIKA_TIK_TAKADA_TIKAK_TIK_TIKA_TIKAK_KAK_BINGCHIKA_CHUNK_THWIZZIK_ZAK
TIK_TIKATAK_TIKKIK_TIKKIK_TIK_TIKA_TIKKIK_TIKKAK_TIKKAK_TIK_TIKIK_TIKITY_TIK_TIK_TIKKAK_TIKKAK_TAK_KAKA_TAKAKA_TIKKIK_KIK_TAKKAK_KAK_BINGCHIKA_CHUNK_THWIZZIK_ZAK_TIK_TIKKA_TIKKAK_TIK_TIK_TIKAKATA_KAKATA
TIKTIK_TIKKA_TIKKA_TAKTAKTAKKAK_TAKKA_TAKKA_TIKTIKTIK_TIKKA_TIKKAK_TAK_TAK_TIKKA_TIKKA
TING
Ting_aling_aling
TING_KATOONG_PLAPF
Ting_aling
TINGALINGA
TINNG
TIP_TIPPITY_TAP_TAP_BAP_SHA_PAP
TOING
TOK
TOK_TOK_TOK_TOK
TONG
TOOBA_TOOBA_TOOBA_TOOBA
TOOF_THAFF_FAK
TOOMP
TOON
TOONG
TOONGALOONGALOONGA
TOONK_TONK_GAPLONK
TOOOOO
TROMP_TROMP_TEEOO_TEEOO
TROMP_TROMP_TROMP
TUBBA_TUBBA_TUBBA_TUBBA
TWEEDLE_TOODLE_HONK_SKREEK_SKRAK_BRAP_FWEEP_OOT_FIFF_FREEP_OOGA_SKWONK_GREEDLE_GREEDLE_SKREECH
TWEEN_SPWANG
TWOK
TWONG
TWOYYOYYOING_THUK_UGH
TZING
TZING_TZONG_TZOONG_TZWANG
ULK
ULP
UMPF_ECK_RATTLE_RATTLE
UNKLIK
URRSSSH_URSSHHH
UUUUURP
VAROOM_ROWM
VAROOM_VROOM_SPAK_BROOM_SPUT_POW_GROWRROOOM
VARROOM_SKREEK
VOOFEN_VOOFEN
VOOM_VOOM
VOOMAROOMA
VOW
VOWM
VROOM
VROOM_VROOM
VROON
VROOON
VROOON_VREEN_VOWN
VWOO_VWOO_VWOO
WAK
WAK_WAK_WAK_WAK_WAK_WAK_WAK_WAK_WAK
WAM_WAM_WAM_WAM_WAM
WAP
WAP_WAP_WAP_WAP
WAWKLE_PRAWK_BLORF_BREEDEET_GRAWK
WEE_HAAH_YIP_YIP_YIP_KAHEEEE_YOWYOWYOW_WOOPWOOPWOOP_YIP_YIP
WEE_WEE_WEE_WEE_WEE
WEE_WEE_WEE_WEE_WEE_WEE_WEE
WEEEEEEE
WEEEOOOOWEEEOOO_WEEEOOOO_WEEOOOO_WEEEOOOOWEE
WEEEOOOWEEEOOOWEE
WEEOOWEEEOOOO_WEEEOOOO
WEEOOWEEOOOO
WHAK_DINK_KLANK_KLING_DOINK_PLOP
WHAM_PLAM_KLOON_BOONG_KLOONG_POONG_KAPLAM_SPMAM
WHAM_WHAM_WHAM_WHAM_WHAM
WHAP
WHAP_SPMAMP_WUNK_KACHONK
WHEEAH_WHEEAH
WHIR_WHIR_WHIR_WHIR
WHIR_SNIP_WHIRR_SNIP
WHIRR_WHIRR
WHIRR_SNIP_WHIRR_SNAP
WHISK
WHOMP_CHOMP_RIP_SKLIK_URP_GLORK
WHOOSH
WINK_WINK
WINK_WINK_WINKITY_WINK_BLINK
WONG_THUK
WONK
WOOOSH
WOOOSH_WOOOSH_WOOOSH_WOOOSH
WUNK
WUNK_SPWAPPO_KATOONK_SPLAT
Xmng
YEKKLE_GLEK
YING_YING
ZAP
ZAP_GING_GING_TWONG_SPLAT
ZAP_POW
ZAT
ZAZIK_TIK_TIK_TIK_TIK_TIK_TIK_SPROING_KATOONG
ZAZZIK_ZIK_ZIK_ZIZAZZIK_ZIK_ZIZ_ZIZZAK
ZEEM
ZIK_ZIK_ZIK
ZIK_ZOCK_FOON_FIT_KLUNK
ZIKKA_ZAZZIK_ZIK_ZIK_ZIK_ZIK_ZAZIK_ZIK_ZIZZAK
ZIP
ZIT_MOP_FLOOM_FAK_SWAT
ZIT_ZITZIZIZIZZZZZZ
ZIT_SREEK_SKRAK_ZIDIT_POW
ZIT_ZIT_ZIT_ZIT_ZAT_ZAT_SWIZAP
ZiZ
ZIZAZIK_ZIK_ZIK_ZIZZAK_ZIKA_ZIKA
ZLITZ_PLORF
ZOOO_TWEEE_TWEEEE
ZOOT
ZOWM
ZOWNT
ZWEECH
ZWEEN
ZWEET
ZWIT_FAT
ZWIT_GLAP_ZWOT_TINK
ZWIT_ZWIT_ZWIT
ZWIT_SPROING
ZZIP
ZZT_CHOMP
ZZZ_GLAP
ZZZ_ZZZZZZZ_ZZZZZZZZ
ZZZZ
ZZZZ_ZZZZ_ZZT_ZNIK_SNUFFLE_SNORK
ZZZZ_ZZZZ_ZZZZ
ZZZZ_ZZZZ_ZZZZ_ZGLUK
ZZZZ_ZZZZZ_ZZZZZZ_ZZZ
ZZZZOOWNT
ZZZZZ
ZZZZZZ
ZZZZZZZ
ZZZZZZZZ
ZZZZZZZZZ
ZZZZZZZZZZZ
