package Net::Async::Spotify::Object::Generated::Image;

use strict;
use warnings;

our $VERSION = '0.002'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::Image - Package representing Spotify Image Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify Image Object attributes:

=over 4

=item height

Type:Integer
Description:The image height in pixels. If unknown: null or not returned.

=item url

Type:String
Description:The source URL of the image.

=item width

Type:Integer
Description:The image width in pixels. If unknown: null or not returned.

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        height => 'Integer',
        url => 'String',
        width => 'Integer',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
