# Generated by default/object.tt
package Paws::CodeArtifact::SuccessfulPackageVersionInfo;
  use Moose;
  has Revision => (is => 'ro', isa => 'Str', request_name => 'revision', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeArtifact::SuccessfulPackageVersionInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeArtifact::SuccessfulPackageVersionInfo object:

  $service_obj->Method(Att1 => { Revision => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeArtifact::SuccessfulPackageVersionInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->Revision

=head1 DESCRIPTION

Contains the revision and status of a package version.

=head1 ATTRIBUTES


=head2 Revision => Str

The revision of a package version.


=head2 Status => Str

The status of a package version. Valid statuses are:

=over

=item *

C<Published>

=item *

C<Unfinished>

=item *

C<Unlisted>

=item *

C<Archived>

=item *

C<Disposed>

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeArtifact>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

