# Generated by default/object.tt
package Paws::LicenseManager::DatetimeRange;
  use Moose;
  has Begin => (is => 'ro', isa => 'Str', required => 1);
  has End => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LicenseManager::DatetimeRange

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LicenseManager::DatetimeRange object:

  $service_obj->Method(Att1 => { Begin => $value, ..., End => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LicenseManager::DatetimeRange object:

  $result = $service_obj->Method(...);
  $result->Att1->Begin

=head1 DESCRIPTION

Describes a time range, in ISO8601-UTC format.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Begin => Str

Start of the time range.


=head2 End => Str

End of the time range.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LicenseManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

