# Generated by default/object.tt
package Paws::Route53Resolver::ResolverQueryLogConfig;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str');
  has AssociationCount => (is => 'ro', isa => 'Int');
  has CreationTime => (is => 'ro', isa => 'Str');
  has CreatorRequestId => (is => 'ro', isa => 'Str');
  has DestinationArn => (is => 'ro', isa => 'Str');
  has Id => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has OwnerId => (is => 'ro', isa => 'Str');
  has ShareStatus => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Route53Resolver::ResolverQueryLogConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Route53Resolver::ResolverQueryLogConfig object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Route53Resolver::ResolverQueryLogConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

In the response to a CreateResolverQueryLogConfig
(https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverQueryLogConfig.html),
DeleteResolverQueryLogConfig
(https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverQueryLogConfig.html),
GetResolverQueryLogConfig
(https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfig.html),
or ListResolverQueryLogConfigs
(https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html)
request, a complex type that contains settings for one query logging
configuration.

=head1 ATTRIBUTES


=head2 Arn => Str

The ARN for the query logging configuration.


=head2 AssociationCount => Int

The number of VPCs that are associated with the query logging
configuration.


=head2 CreationTime => Str

The date and time that the query logging configuration was created, in
Unix time format and Coordinated Universal Time (UTC).


=head2 CreatorRequestId => Str

A unique string that identifies the request that created the query
logging configuration. The C<CreatorRequestId> allows failed requests
to be retried without the risk of running the operation twice.


=head2 DestinationArn => Str

The ARN of the resource that you want Resolver to send query logs: an
Amazon S3 bucket, a CloudWatch Logs log group, or a Kinesis Data
Firehose delivery stream.


=head2 Id => Str

The ID for the query logging configuration.


=head2 Name => Str

The name of the query logging configuration.


=head2 OwnerId => Str

The AWS account ID for the account that created the query logging
configuration.


=head2 ShareStatus => Str

An indication of whether the query logging configuration is shared with
other AWS accounts, or was shared with the current account by another
AWS account. Sharing is configured through AWS Resource Access Manager
(AWS RAM).


=head2 Status => Str

The status of the specified query logging configuration. Valid values
include the following:

=over

=item *

C<CREATING>: Resolver is creating the query logging configuration.

=item *

C<CREATED>: The query logging configuration was successfully created.
Resolver is logging queries that originate in the specified VPC.

=item *

C<DELETING>: Resolver is deleting this query logging configuration.

=item *

C<FAILED>: Resolver can't deliver logs to the location that is
specified in the query logging configuration. Here are two common
causes:

=over

=item *

The specified destination (for example, an Amazon S3 bucket) was
deleted.

=item *

Permissions don't allow sending logs to the destination.

=back

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Route53Resolver>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

