# Generated by default/object.tt
package Paws::SSM::OpsItemEventFilter;
  use Moose;
  has Key => (is => 'ro', isa => 'Str', required => 1);
  has Operator => (is => 'ro', isa => 'Str', required => 1);
  has Values => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSM::OpsItemEventFilter

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSM::OpsItemEventFilter object:

  $service_obj->Method(Att1 => { Key => $value, ..., Values => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSM::OpsItemEventFilter object:

  $result = $service_obj->Method(...);
  $result->Att1->Key

=head1 DESCRIPTION

Describes a filter for a specific list of OpsItem events. You can
filter event information by using tags. You specify tags by using a
key-value pair mapping.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Key => Str

The name of the filter key. Currently, the only supported value is
C<OpsItemId>.


=head2 B<REQUIRED> Operator => Str

The operator used by the filter call. Currently, the only supported
value is C<Equal>.


=head2 B<REQUIRED> Values => ArrayRef[Str|Undef]

The values for the filter, consisting of one or more OpsItem IDs.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSM>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

