#!/usr/local/ls6/perl/bin/perl
#                              -*- Mode: Perl -*- 
# 
# Makefile.PL -- 
# ITIID           : $ITI$ $Header $__Header$
# Author          : Ulrich Pfeifer
# Created On      : Sun Sep 10 11:00:44 1995
# Last Modified By: Ulrich Pfeifer
# Last Modified On: Thu Feb 13 13:28:39 1997
# Language        : Perl
# Update Count    : 199
# Status          : Unknown, Use with caution!
# 
# (C) Copyright 1995, Universitt Dortmund, all rights reserved.
# 
# $Locker:  $
# $Log: Makefile.PL,v $
# Revision 2.6  1997/02/13 12:29:31  pfeifer
# Bad passing of PREOP
#
# Revision 2.4  1997/02/06 09:43:02  pfeifer
# remove inspect upon "make clean"
#
# Revision 2.3  1997/02/06 09:34:45  pfeifer
# Switched to CVS
#
#

use ExtUtils::MakeMaker;
use Config;

# when compiling with the freeWAIS-sf source directory
$FW      = "/usr/local/ls6/src+data/src/freeWAIS-sf-2.1.1";

# when compiling with the installed freeWAIS-sf 
$TESTDB  = "$FW/FIELD-EXAMPLE/test";
$WAISDIR = '/usr/local/ls6/wais';
$CFLAGS  = "-I$WAISDIR/include/$Config{'archname'}";
$LDFLAGS = "-L$WAISDIR/lib/$Config{'archname'}";

for (('../freeWAIS-sf-2.0', '/usr/src/freeWAIS-sf-2.0', $FW)) {
  if (-d "$_/$Config{'archname'}") {
    $FW="$_/$Config{'archname'}";
  } elsif (-d $_) {
    $FW = $_;
  }
}

$NOSRC = grep /NOSRC/, @ARGV;
if (!$NOSRC and $FW) {
  print STDERR "Seems that you have the freeWAIS-sf source directory around.\n";
  print STDERR "See README if you want to get rid of it.\n";
  write_include();
  open(CONF, "$FW/config.h") || die "Could not open $FW/config.h: $!";
  $regexp = '';
  while (<CONF>) {
    if (/\#define MYREGEXP/) {
        $regexp = "-lregexp";
      }
  }
  close(CONF);
  if (-e "$FW/ctype/ctype.o") {
    $OBJECT = "$FW/ctype/ctype.o";
  } else {
    print STDERR "I do not see '$FW/ctype/ctype.o'\n";
    print STDERR "Assuming that's in libwais.a.\n";
  }
  $LDFLAGS  = "-L$FW/ir -L$FW/regexp -L$FW/lib";
  $CFLAGS   = "-I$FW/ir";
} else {
  print STDERR "Could not locate the freeWAIS-sf source directory.\n";
  print STDERR "Assume that you generated 'wais.h'. See README for details.\n";
  write_include(1);
  $regexp = "-lregexp";         # must check for that !
  $LDFLAGS  = $CFLAGS  = '';
} 

$TESTDB = "$FW/FIELD-EXAMPLE/test" unless (-e "$TESTDB.doc") ;

unless (-e "$TESTDB.doc") {
    print "Your tests database '$TESTDB' is missing.\n";
    print "You must rebuild it before running the tests!\n";
}


$VERSION = getversion('patchlevel.h');
rewrite('Wais.pm', 'Wais', $VERSION);

&WriteMakefile
  (
   'PREREQ_PM'      => { IO::Select => 0},
   'LIBS'           => "$LDFLAGS -lwais $regexp -lftw -lm",
   'INC'            => "$CFLAGS -DWAIS_USES_STDIO",
   'NAME'           => 'Wais',
   'VERSION'        => $VERSION,
   'OBJECT'         => "Wais.o HTWAIS.o dictionary.o $OBJECT",
   'DEFINE'         => '-DTRACE=0 -g',
   'PL_FILES'       => {'inspect.PL' => 'inspect'},
   'dist'           => { SUFFIX   => 'gz',
                         COMPRESS => 'gzip -9f',
                         'PREOP'  => 'changelog -update',
                       },
   'clean' 	    => {'FILES' => '*~ Wais.h inspect'},
   'MAP_TARGET'     => 'waisperl',
   'EXE_FILES'      => [ 'inspect' ],
   
  );

sub getversion {
    my $file = shift;
    my ($version, $revision);

    open(PATCH, $file) || die "Could not open patchlevel.h: $!";
    while (<PATCH>) {
        if (/VERSION ([\d.]+)/) {
            $version = $1;
        }
        if (/PATCHLEVEL (\d+)/) {
            $revision = $1;
        }
    }
    close(PATCH);
    sprintf("%5.3f", $version + $revision/1000);
}

sub moduleversion {
  my ($file, $package) = @_;
  my $version;
  
  open(IN, $file) || die "Could not open $file: $!";
  while (<IN>) {
    if (/^\$($package\:\:)?VERSION\s*=\s*(\d+\.\d+)/) {
      $version = $2;
      last;
    }
  }
  close IN;
  $version;
}

sub write_include {
  my $simple = shift;
  open(INC, ">Wais.h") || die "Could not write 'Wais.h': $!\n";
  print INC "/* Automatically generated by $0. Do not edit */\n";
  print INC "#ifndef _WAIS_H_\n";
  print INC "#define _WAIS_H_\n";
  print INC q[
#ifndef _AP
#define _AP(A) _(A)
#endif
#ifdef WORD
#undef WORD			/* defined in the perl parser */
#endif
#ifdef _config_h_
#undef _config_h_		/* load the freeWAIS-sf config.h also */
#endif
#ifdef warn
#undef warn
#endif
#ifdef Strerror
#undef Strerror
#endif
];
  if ($simple) {
    print INC "#include <wais.h>\n";
  } else {
    print INC q[
#ifdef Uid_t
#undef Uid_t
#endif
#include <ui.h>
#include "dictionary.h"
#include <cutil.h>
#include <irfiles.h>
#include <irtfiles.h>		/* for map_over_words */
#include <irext.h>
#include <irsearch.h>
#include <weight.h>
#include <docid.h>
];
  }
  print INC "#endif /* _WAIS_H_ */\n";
  close INC;
}

sub rewrite {
    my ($file, $package, $VERSION) = @_;
    my $bak = "$file.bak";

    return if moduleversion($file, $package) eq $VERSION;
    rename $file, $bak or die "Could not rename $file: $!";
    open(IN, $bak) || die "Could not open $bak: $!";
    open(OUT, ">$file") || die "Could not open $file: $!";
    print STDERR "Rewriting $file\n";

    while (<IN>) {
        if (/^\$VERSION/) {
            print OUT '$'.'VERSION = '."'$VERSION';\n";
            print STDERR '$'.'VERSION = '."'$VERSION';\n";
        } else {
            print OUT;
        }
    }
    close(IN);
    close(OUT);
    unlink $bak;
}

  
sub MY::postamble {
    my $self = shift;
    
    q[
install :: register

register ::
	].$self->{NOECHO}.q[$(PERL) -I$(PERL_ARCHLIB) -I$(PERL_LIB) \
-e '    use Wais; ' \
-e '    use Config; ' \
-e '    eval "use Sys::Hostname; \\$$host = q[on ].hostname;";' \
-e '    $$address="wais\@ls6.informatik.uni-dortmund.de";'	\
-e '    print "Send registration mail to $$address (y/n)? ";'	\
-e '    $$answer = <STDIN>;' 	\
-e '    if ($$answer !~ /^n/i) {'	\
-e '        exec "perlbug", "-a", $$address, "-C",'	\
-e '        "-s", "Installed Wais extension $$Wais::VERSION $$host$$Config{mydomain}";'	\
-e '    } else {'	\
-e '        print "Ok ... I will keep your secret!\n";'	\
-e '    }'
] . qq[
TESTDB  = $TESTDB
]
}
