package Net::Async::Spotify::API::Generated::Library;

use strict;
use warnings;

our $VERSION = '0.002'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::API::Base);

use Future::AsyncAwait;

=encoding utf8

=head1 NAME

Net::Async::Spotify::API::Generated::Library - Package representing Spotify Library API

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#reference-index
Check C<crawl-api-doc.pl> for more information.

=head1 METHODS

=cut

sub mapping { shift->{mapping} }

=head2 check_users_saved_albums

check_users_saved_albums - Check User's Saved Albums

Check if one or more albums is already saved in the current Spotify user’s ‘Your Music’ library.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details. The user-library-read scope must have been authorized by the user.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of the Spotify IDs for the albums. Maximum: 50 IDs.

=back

and Response Objects being:

- error object


On success, the HTTP status code in the response header is 200 OK and the response body contains a JSON array of true or false values, in the same order in which the ids were specified.
On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub check_users_saved_albums {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{check_users_saved_albums}{method} // 'GET';
    $request->{uri}    = $mapping->{check_users_saved_albums}{uri} // 'https://api.spotify.com/v1/me/albums/contains';
    $request->{param}  = $mapping->{check_users_saved_albums}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{check_users_saved_albums}{response} // [
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 check_users_saved_episodes

check_users_saved_episodes - Check User's Saved Episodes

Check if one or more episodes is already saved in the current Spotify user’s ‘Your Episodes’ library.
This API endpoint is in beta and could change without warning. Please share any feedback that you have, or issues that you discover, in our developer community forum..

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details. The user-library-read scope must have been authorized by the user.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of the Spotify IDs for the episodes. Maximum: 50 IDs.

=back

and Response Objects being:

- error object


On success, the HTTP status code in the response header is 200 OK and the response body contains a JSON array of true or false values, in the same order in which the ids were specified.
On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub check_users_saved_episodes {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{check_users_saved_episodes}{method} // 'GET';
    $request->{uri}    = $mapping->{check_users_saved_episodes}{uri} // 'https://api.spotify.com/v1/me/episodes/contains';
    $request->{param}  = $mapping->{check_users_saved_episodes}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{check_users_saved_episodes}{response} // [
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 check_users_saved_shows

check_users_saved_shows - Check User's Saved Shows

Check if one or more shows is already saved in the current Spotify user’s library.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details. The access token must have been isued on behalf of the user. The user-library-read scope must have been authorised by the user.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of the Spotify IDs for the shows. Maximum: 50 ids.

=back

and Response Objects being:

- error object


On success, the HTTP status code in the response header is 200 OK and the response body contains a JSON array of trueor false values, in the same order in which the ids were specified. On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub check_users_saved_shows {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{check_users_saved_shows}{method} // 'GET';
    $request->{uri}    = $mapping->{check_users_saved_shows}{uri} // 'https://api.spotify.com/v1/me/shows/contains';
    $request->{param}  = $mapping->{check_users_saved_shows}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{check_users_saved_shows}{response} // [
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 check_users_saved_tracks

check_users_saved_tracks - Check User's Saved Tracks

Check if one or more tracks is already saved in the current Spotify user’s ‘Your Music’ library.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details. The user-library-read scope must have been authorized by the user.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of the Spotify IDs for the tracks. Maximum: 50 IDs.

=back

and Response Objects being:

- error object


On success, the HTTP status code in the response header is 200 OK and the response body contains a JSON array of true or false values, in the same order in which the ids were specified.
On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub check_users_saved_tracks {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{check_users_saved_tracks}{method} // 'GET';
    $request->{uri}    = $mapping->{check_users_saved_tracks}{uri} // 'https://api.spotify.com/v1/me/tracks/contains';
    $request->{param}  = $mapping->{check_users_saved_tracks}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{check_users_saved_tracks}{response} // [
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_users_saved_albums

get_users_saved_albums - Get User's Saved Albums

Get a list of the albums saved in the current Spotify user’s ‘Your Music’ library.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details. The user-library-read scope must have been authorized by the user.

=back

=head3 query_parameter

=over 4

=item limit

Type: integer | Required: optional
The maximum number of objects to return. Default: 20. Minimum: 1. Maximum: 50.

=item market

Type: string | Required: optional
An ISO 3166-1 alpha-2 country code or the string from_token. Provide this parameter if you want to apply Track Relinking.

=item offset

Type: integer | Required: optional
The index of the first object to return. Default: 0 (i.e., the first object). Use with limit to get the next set of objects.

=back

and Response Objects being:

- album object
- error object


On success, the HTTP status code in the response header is 200 OK and the response body contains an array of saved album objects (wrapped in a paging object) in JSON format. Each album object is accompanied by a timestamp (added_at) to show when it was added. There is also an etag in the header that can be used in future conditional requests.On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub get_users_saved_albums {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_users_saved_albums}{method} // 'GET';
    $request->{uri}    = $mapping->{get_users_saved_albums}{uri} // 'https://api.spotify.com/v1/me/albums';
    $request->{param}  = $mapping->{get_users_saved_albums}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'limit' => {
                type     => 'integer',
                required => 'optional',
            },
            'market' => {
                type     => 'string',
                required => 'optional',
            },
            'offset' => {
                type     => 'integer',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{get_users_saved_albums}{response} // [
        'album object',
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_users_saved_episodes

get_users_saved_episodes - Get User's Saved Episodes

Get a list of the episodes saved in the current Spotify user’s library.
This API endpoint is in beta and could change without warning. Please share any feedback that you have, or issues that you discover, in our developer community forum.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details. The user-library-read scope must have been authorized by the user.

=back

=head3 query_parameter

=over 4

=item limit

Type: integer | Required: optional
The maximum number of objects to return. Default: 20. Minimum: 1. Maximum: 50.

=item market

Type: string | Required: optional
An ISO 3166-1 alpha-2 country code.
  If a country code is specified, only episodes that are available in that market will be returned.
  If a valid user access token is specified in the request header, the country associated with
  the user account will take priority over this parameter.
  Note: If neither market or user country are provided, the content is considered unavailable for the client.
  Users can view the country that is associated with their account in the account settings.

=item offset

Type: integer | Required: optional
The index of the first object to return. Default: 0 (i.e., the first object). Use with limit to get the next set of objects.

=back

and Response Objects being:

- episode object


 On success, the HTTP status code in the response header is 200 OK and the response body contains an array of saved episode objects (wrapped in a paging object) in JSON format. On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub get_users_saved_episodes {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_users_saved_episodes}{method} // 'GET';
    $request->{uri}    = $mapping->{get_users_saved_episodes}{uri} // 'https://api.spotify.com/v1/me/episodes';
    $request->{param}  = $mapping->{get_users_saved_episodes}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'limit' => {
                type     => 'integer',
                required => 'optional',
            },
            'market' => {
                type     => 'string',
                required => 'optional',
            },
            'offset' => {
                type     => 'integer',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{get_users_saved_episodes}{response} // [
        'episode object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_users_saved_shows

get_users_saved_shows - Get User's Saved Shows

Get a list of shows saved in the current Spotify user’s library. Optional parameters can be used to limit the number of shows returned.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details. The access token must have been isued on behalf of the user. The user-library-read scope must have been authorised by the user.

=back

=head3 query_parameter

=over 4

=item limit

Type: integer | Required: optional
The maximum number of shows to return. Default: 20. Minimum: 1. Maximum: 50

=item offset

Type: integer | Required: optional
The index of the first show to return. Default: 0 (the first object). Use with limit to get the next set of shows.

=back

and Response Objects being:

- show object


On success, the HTTP status code in the response header is 200 OK and the response body contains an array of saved show objects (wrapped in a paging object) in JSON format.
If the current user has no shows saved, the response will be an empty array. If a show is unavailable in the given market it is filtered out. The total field in the paging object represents the number of all items, filtered or not, and thus might be larger than the actual total number of observable items.
On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub get_users_saved_shows {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_users_saved_shows}{method} // 'GET';
    $request->{uri}    = $mapping->{get_users_saved_shows}{uri} // 'https://api.spotify.com/v1/me/shows';
    $request->{param}  = $mapping->{get_users_saved_shows}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'limit' => {
                type     => 'integer',
                required => 'optional',
            },
            'offset' => {
                type     => 'integer',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{get_users_saved_shows}{response} // [
        'show object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_users_saved_tracks

get_users_saved_tracks - Get User's Saved Tracks

Get a list of the songs saved in the current Spotify user’s ‘Your Music’ library.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details. The user-library-read scope must have been authorized by the user.

=back

=head3 query_parameter

=over 4

=item limit

Type: integer | Required: optional
The maximum number of objects to return. Default: 20. Minimum: 1. Maximum: 50.

=item market

Type: string | Required: optional
An ISO 3166-1 alpha-2 country code or the string from_token. Provide this parameter if you want to apply Track Relinking.

=item offset

Type: integer | Required: optional
The index of the first object to return. Default: 0 (i.e., the first object). Use with limit to get the next set of objects.

=back

and Response Objects being:

- track object


On success, the HTTP status code in the response header is 200 OK and the response body contains an array of saved track objects (wrapped in a paging object) in JSON format. On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub get_users_saved_tracks {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_users_saved_tracks}{method} // 'GET';
    $request->{uri}    = $mapping->{get_users_saved_tracks}{uri} // 'https://api.spotify.com/v1/me/tracks';
    $request->{param}  = $mapping->{get_users_saved_tracks}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'limit' => {
                type     => 'integer',
                required => 'optional',
            },
            'market' => {
                type     => 'string',
                required => 'optional',
            },
            'offset' => {
                type     => 'integer',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{get_users_saved_tracks}{response} // [
        'track object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 remove_albums_user

remove_albums_user - Remove Albums for Current User

Remove one or more albums from the current user’s ‘Your Music’ library.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.Modification of the current user’s “Your Music” collection requires authorization of the user-library-modify scope.

=item Content-Type

Type: string | Required: optional
Required if the IDs are passed in the request body, otherwise ignored. The content type of the request body: application/json

=back

=head3 json_body_parameter

=over 4

=item ids

Type: array[string] | Required: optional
A JSON array of the Spotify IDs. For example: ["4iV5W9uYEdYUVa79Axb7Rh", "1301WleyT98MSxVHPZCA6M"]A maximum of 50 items can be specified in one request. Note: if the ids parameter is present in the query string, any IDs listed here in the body will be ignored.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of the Spotify IDs. For example: ids=4iV5W9uYEdYUVa79Axb7Rh,1301WleyT98MSxVHPZCA6M. Maximum: 50 IDs.

=back

and Response Objects being:

- error object


On success, the HTTP status code in the response header is 200 Success. On error, the header status code is an error code and the response body contains an error object. Trying to remove an album when you do not have the user’s authorization returns error 403 Forbidden.Try in our Web Console

=cut

async sub remove_albums_user {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{remove_albums_user}{method} // 'DELETE';
    $request->{uri}    = $mapping->{remove_albums_user}{uri} // 'https://api.spotify.com/v1/me/albums';
    $request->{param}  = $mapping->{remove_albums_user}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
            'Content-Type' => {
                type     => 'string',
                required => 'optional',
            },
        },
        json_body_parameter => {
            'ids' => {
                type     => 'array[string]',
                required => 'optional',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{remove_albums_user}{response} // [
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 remove_episodes_user

remove_episodes_user - Remove User's Saved Episodes

Remove one or more episodes from the current user’s library.
This API endpoint is in beta and could change without warning. Please share any feedback that you have, or issues that you discover, in our developer community forum.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.Modification of the current user’s collection requires authorization of the user-library-modify scope.

=item Content-Type

Type: string | Required: optional
Required if the IDs are passed in the request body, otherwise ignored. The content type of the request body: application/json

=back

=head3 json_body_parameter

=over 4

=item ids

Type: array[string] | Required: optional
A JSON array of the Spotify IDs. A maximum of 50 items can be specified in one request. Note: if the ids parameter is present in the query string, any IDs listed here in the body will be ignored.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of the Spotify IDs. Maximum: 50 IDs.

=back

and Response Objects being:

- error object


On success, the HTTP status code in the response header is 200 Success. On error, the header status code is an error code and the response body contains an error object. Trying to remove an episode when you do not have the user’s authorization returns error 403 Forbidden.Try in our Web Console

=cut

async sub remove_episodes_user {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{remove_episodes_user}{method} // 'DELETE';
    $request->{uri}    = $mapping->{remove_episodes_user}{uri} // 'https://api.spotify.com/v1/me/episodes';
    $request->{param}  = $mapping->{remove_episodes_user}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
            'Content-Type' => {
                type     => 'string',
                required => 'optional',
            },
        },
        json_body_parameter => {
            'ids' => {
                type     => 'array[string]',
                required => 'optional',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{remove_episodes_user}{response} // [
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 remove_shows_user

remove_shows_user - Remove User's Saved Shows

Delete one or more shows from current Spotify user’s library.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details. The access token must have been issued on behalf of the user. The user-library-modify scope must have been authorized by the user.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of Spotify IDs for the shows to be deleted from the user’s library.

=item market

Type: string | Required: optional
An ISO 3166-1 alpha-2 country code.
If a country code is specified, only shows that are available in that market will be removed.
If a valid user access token is specified in the request header, the country associated with
the user account will take priority over this parameter.
Note: If neither market or user country are provided, the content is considered unavailable for the client.
Users can view the country that is associated with their account in the account settings.

=back

and Response Objects being:

- error object


On success, the HTTP status code in the response header is 200 OK.
On error, the header status code is an error code and the response body contains an error object. A 403 Forbidden while trying to add a show when you do not have the user’s authorisation.Try in our Web Console

=cut

async sub remove_shows_user {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{remove_shows_user}{method} // 'DELETE';
    $request->{uri}    = $mapping->{remove_shows_user}{uri} // 'https://api.spotify.com/v1/me/shows';
    $request->{param}  = $mapping->{remove_shows_user}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
            'market' => {
                type     => 'string',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{remove_shows_user}{response} // [
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 remove_tracks_user

remove_tracks_user - Remove User's Saved Tracks

Remove one or more tracks from the current user’s ‘Your Music’ library.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.Modification of the current user’s “Your Music” collection requires authorization of the user-library-modify scope.

=item Content-Type

Type: string | Required: optional
Required if the IDs are passed in the request body, otherwise ignored. The content type of the request body: application/json

=back

=head3 json_body_parameter

=over 4

=item ids

Type: array[string] | Required: optional
A JSON array of the Spotify IDs. For example: ["4iV5W9uYEdYUVa79Axb7Rh", "1301WleyT98MSxVHPZCA6M"]A maximum of 50 items can be specified in one request. Note: if the ids parameter is present in the query string, any IDs listed here in the body will be ignored.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of the Spotify IDs. For example: ids=4iV5W9uYEdYUVa79Axb7Rh,1301WleyT98MSxVHPZCA6M. Maximum: 50 IDs.

=back

and Response Objects being:

- error object


On success, the HTTP status code in the response header is 200 Success. On error, the header status code is an error code and the response body contains an error object. Trying to remove an album when you do not have the user’s authorization returns error 403 Forbidden.Try in our Web Console

=cut

async sub remove_tracks_user {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{remove_tracks_user}{method} // 'DELETE';
    $request->{uri}    = $mapping->{remove_tracks_user}{uri} // 'https://api.spotify.com/v1/me/tracks';
    $request->{param}  = $mapping->{remove_tracks_user}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
            'Content-Type' => {
                type     => 'string',
                required => 'optional',
            },
        },
        json_body_parameter => {
            'ids' => {
                type     => 'array[string]',
                required => 'optional',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{remove_tracks_user}{response} // [
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 save_albums_user

save_albums_user - Save Albums for Current User

Save one or more albums to the current user’s ‘Your Music’ library.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.Modification of the current user’s “Your Music” collection requires authorization of the user-library-modify scope.

=item Content-Type

Type: string | Required: optional
Required if the IDs are passed in the request body, otherwise ignored. The content type of the request body: application/json

=back

=head3 json_body_parameter

=over 4

=item ids

Type: array[string] | Required: optional
A JSON array of the Spotify IDs. For example: ["4iV5W9uYEdYUVa79Axb7Rh", "1301WleyT98MSxVHPZCA6M"]A maximum of 50 items can be specified in one request. Note: if the ids parameter is present in the query string, any IDs listed here in the body will be ignored.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of the Spotify IDs. For example: ids=4iV5W9uYEdYUVa79Axb7Rh,1301WleyT98MSxVHPZCA6M. Maximum: 50 IDs.

=back

and Response Objects being:

- error object


On success, the HTTP status code in the response header is 201 Created. On error, the header status code is an error code and the response body contains an error object. Trying to add an album when you do not have the user’s authorization returns error 403 Forbidden.Try in our Web Console

=cut

async sub save_albums_user {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{save_albums_user}{method} // 'PUT';
    $request->{uri}    = $mapping->{save_albums_user}{uri} // 'https://api.spotify.com/v1/me/albums';
    $request->{param}  = $mapping->{save_albums_user}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
            'Content-Type' => {
                type     => 'string',
                required => 'optional',
            },
        },
        json_body_parameter => {
            'ids' => {
                type     => 'array[string]',
                required => 'optional',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{save_albums_user}{response} // [
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 save_episodes_user

save_episodes_user - Save Episodes for User

Save one or more episodes to the current user’s library.
This API endpoint is in beta and could change without warning. Please share any feedback that you have, or issues that you discover, in our developer community forum.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.Modification of the current user’s “Your Music” collection requires authorization of the user-library-modify scope.

=item Content-Type

Type: string | Required: optional
Required if the IDs are passed in the request body, otherwise ignored. The content type of the request body: application/json

=back

=head3 json_body_parameter

=over 4

=item ids

Type: array[string] | Required: optional
A JSON array of the Spotify IDs. A maximum of 50 items can be specified in one request. Note: if the ids parameter is present in the query string, any IDs listed here in the body will be ignored.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of the Spotify IDs. Maximum: 50 IDs.

=back

and Response Objects being:

- error object


On success, the HTTP status code in the response header is 200 OK. On error, the header status code is an error code and the response body contains an error object. Trying to add an episode when you do not have the user’s authorization, returns error 403 Forbidden.Try in our Web Console

=cut

async sub save_episodes_user {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{save_episodes_user}{method} // 'PUT';
    $request->{uri}    = $mapping->{save_episodes_user}{uri} // 'https://api.spotify.com/v1/me/episodes';
    $request->{param}  = $mapping->{save_episodes_user}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
            'Content-Type' => {
                type     => 'string',
                required => 'optional',
            },
        },
        json_body_parameter => {
            'ids' => {
                type     => 'array[string]',
                required => 'optional',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{save_episodes_user}{response} // [
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 save_shows_user

save_shows_user - Save Shows for Current User

Save one or more shows to current Spotify user’s library.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details. The access token must have been issued on behalf of the user. The user-library-modify scope must have been authorized by the user.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of the Spotify IDs. Maximum: 50 IDs.

=back

and Response Objects being:

- error object


On success, the HTTP status code in the response header is 200 OK. On error, the header status code is an error code and the response body contains an error object. A 403 Forbidden while trying to add a show when you do not have the user’s authorisation or when the user already has have over 10,000 items saved in library.Try in our Web Console

=cut

async sub save_shows_user {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{save_shows_user}{method} // 'PUT';
    $request->{uri}    = $mapping->{save_shows_user}{uri} // 'https://api.spotify.com/v1/me/shows';
    $request->{param}  = $mapping->{save_shows_user}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{save_shows_user}{response} // [
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 save_tracks_user

save_tracks_user - Save Tracks for User

Save one or more tracks to the current user’s ‘Your Music’ library.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.Modification of the current user’s “Your Music” collection requires authorization of the user-library-modify scope.

=item Content-Type

Type: string | Required: optional
Required if the IDs are passed in the request body, otherwise ignored. The content type of the request body: application/json

=back

=head3 json_body_parameter

=over 4

=item ids

Type: array[string] | Required: optional
A JSON array of the Spotify IDs. For example: ["4iV5W9uYEdYUVa79Axb7Rh", "1301WleyT98MSxVHPZCA6M"]A maximum of 50 items can be specified in one request. Note: if the ids parameter is present in the query string, any IDs listed here in the body will be ignored.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of the Spotify IDs. For example: ids=4iV5W9uYEdYUVa79Axb7Rh,1301WleyT98MSxVHPZCA6M. Maximum: 50 IDs.

=back

and Response Objects being:

- error object


On success, the HTTP status code in the response header is 200 OK. On error, the header status code is an error code and the response body contains an error object. Trying to add a track when you do not have the user’s authorization, or when you have over 10.000 tracks in Your Music, returns error 403 Forbidden.Try in our Web Console

=cut

async sub save_tracks_user {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{save_tracks_user}{method} // 'PUT';
    $request->{uri}    = $mapping->{save_tracks_user}{uri} // 'https://api.spotify.com/v1/me/tracks';
    $request->{param}  = $mapping->{save_tracks_user}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
            'Content-Type' => {
                type     => 'string',
                required => 'optional',
            },
        },
        json_body_parameter => {
            'ids' => {
                type     => 'array[string]',
                required => 'optional',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{save_tracks_user}{response} // [
        'error object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

1;
