# Generated by default/object.tt
package Paws::CloudWatchEvents::RedshiftDataParameters;
  use Moose;
  has Database => (is => 'ro', isa => 'Str', required => 1);
  has DbUser => (is => 'ro', isa => 'Str');
  has SecretManagerArn => (is => 'ro', isa => 'Str');
  has Sql => (is => 'ro', isa => 'Str', required => 1);
  has StatementName => (is => 'ro', isa => 'Str');
  has WithEvent => (is => 'ro', isa => 'Bool');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatchEvents::RedshiftDataParameters

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatchEvents::RedshiftDataParameters object:

  $service_obj->Method(Att1 => { Database => $value, ..., WithEvent => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatchEvents::RedshiftDataParameters object:

  $result = $service_obj->Method(...);
  $result->Att1->Database

=head1 DESCRIPTION

These are custom parameters to be used when the target is a Redshift
cluster to invoke the Redshift Data API ExecuteStatement based on
EventBridge events.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Database => Str

The name of the database. Required when authenticating using temporary
credentials.


=head2 DbUser => Str

The database user name. Required when authenticating using temporary
credentials.


=head2 SecretManagerArn => Str

The name or ARN of the secret that enables access to the database.
Required when authenticating using AWS Secrets Manager.


=head2 B<REQUIRED> Sql => Str

The SQL statement text to run.


=head2 StatementName => Str

The name of the SQL statement. You can name the SQL statement when you
create it to identify the query.


=head2 WithEvent => Bool

Indicates whether to send an event back to EventBridge after the SQL
statement runs.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatchEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

