/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xml.impl.xmlbeans;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.xml.impl.xmlbeans.LogicalEquality;
import org.mozilla.javascript.xml.impl.xmlbeans.Namespace;
import org.mozilla.javascript.xml.impl.xmlbeans.NamespaceHelper;
import org.mozilla.javascript.xml.impl.xmlbeans.QName;
import org.mozilla.javascript.xml.impl.xmlbeans.XMLLibImpl;
import org.mozilla.javascript.xml.impl.xmlbeans.XMLList;
import org.mozilla.javascript.xml.impl.xmlbeans.XMLName;
import org.mozilla.javascript.xml.impl.xmlbeans.XMLObjectImpl;

class XML
extends XMLObjectImpl {
    static final long serialVersionUID = -630969919086449092L;
    private XScriptAnnotation _anno;
    private static final int APPEND_CHILD = 1;
    private static final int PREPEND_CHILD = 2;
    static /* synthetic */ Class class$org$mozilla$javascript$xml$impl$xmlbeans$XML$XScriptAnnotation;

    private XML(XMLLibImpl lib, XScriptAnnotation anno) {
        super(lib, lib.xmlPrototype);
        this._anno = anno;
        this._anno._xScriptXML = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XML createEmptyXML(XMLLibImpl lib) {
        XScriptAnnotation anno;
        XmlObject xo = XmlObject.Factory.newInstance();
        XmlCursor curs = xo.newCursor();
        try {
            anno = new XScriptAnnotation(curs);
            curs.setBookmark((XmlCursor.XmlBookmark)anno);
        }
        finally {
            curs.dispose();
        }
        return new XML(lib, anno);
    }

    private static XML createXML(XMLLibImpl lib, XmlCursor curs) {
        if (curs.currentTokenType().isStartdoc()) {
            curs.toFirstContentToken();
        }
        XScriptAnnotation anno = XML.findAnnotation(curs);
        return new XML(lib, anno);
    }

    private static XML createAttributeXML(XMLLibImpl lib, XmlCursor cursor) {
        if (!cursor.isAttr()) {
            throw new IllegalArgumentException();
        }
        XScriptAnnotation anno = new XScriptAnnotation(cursor);
        cursor.setBookmark((XmlCursor.XmlBookmark)anno);
        return new XML(lib, anno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XML createTextElement(XMLLibImpl lib, javax.xml.namespace.QName qname, String value) {
        XScriptAnnotation anno;
        XmlObject xo = XmlObject.Factory.newInstance();
        XmlCursor cursor = xo.newCursor();
        try {
            cursor.toNextToken();
            cursor.beginElement(qname.getLocalPart(), qname.getNamespaceURI());
            cursor.insertChars(value);
            cursor.toStartDoc();
            cursor.toNextToken();
            anno = new XScriptAnnotation(cursor);
            cursor.setBookmark((XmlCursor.XmlBookmark)anno);
        }
        finally {
            cursor.dispose();
        }
        return new XML(lib, anno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XML createFromXmlObject(XMLLibImpl lib, XmlObject xo) {
        XScriptAnnotation anno;
        XmlCursor curs = xo.newCursor();
        if (curs.currentTokenType().isStartdoc()) {
            curs.toFirstContentToken();
        }
        try {
            anno = new XScriptAnnotation(curs);
            curs.setBookmark((XmlCursor.XmlBookmark)anno);
        }
        finally {
            curs.dispose();
        }
        return new XML(lib, anno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XML createFromJS(XMLLibImpl lib, Object inputObject) {
        XScriptAnnotation anno;
        XmlObject xo;
        String frag;
        boolean isText = false;
        if (inputObject == null || inputObject == Undefined.instance) {
            frag = "";
        } else if (inputObject instanceof XMLObjectImpl) {
            frag = ((XMLObjectImpl)inputObject).toXMLString(0);
        } else {
            Object wrapped;
            if (inputObject instanceof Wrapper && (wrapped = ((Wrapper)inputObject).unwrap()) instanceof XmlObject) {
                return XML.createFromXmlObject(lib, (XmlObject)wrapped);
            }
            frag = ScriptRuntime.toString(inputObject);
        }
        if (frag.trim().startsWith("<>")) {
            throw ScriptRuntime.typeError("Invalid use of XML object anonymous tags <></>.");
        }
        if (frag.indexOf("<") == -1) {
            isText = true;
            frag = "<textFragment>" + frag + "</textFragment>";
        }
        XmlOptions options = new XmlOptions();
        if (lib.ignoreComments) {
            options.put((Object)"LOAD_STRIP_COMMENTS");
        }
        if (lib.ignoreProcessingInstructions) {
            options.put((Object)"LOAD_STRIP_PROCINSTS");
        }
        if (lib.ignoreWhitespace) {
            options.put((Object)"LOAD_STRIP_WHITESPACE");
        }
        try {
            xo = XmlObject.Factory.parse((String)frag, (XmlOptions)options);
            Context cx = Context.getCurrentContext();
            String defaultURI = lib.getDefaultNamespaceURI(cx);
            if (defaultURI.length() > 0) {
                XmlCursor cursor = xo.newCursor();
                boolean isRoot = true;
                while (!cursor.toNextToken().isEnddoc()) {
                    if (!cursor.isStart()) continue;
                    boolean defaultNSDeclared = false;
                    cursor.push();
                    while (cursor.toNextToken().isAnyAttr()) {
                        if (!cursor.isNamespace() || cursor.getName().getLocalPart().length() != 0) continue;
                        defaultNSDeclared = true;
                        break;
                    }
                    cursor.pop();
                    if (defaultNSDeclared) {
                        cursor.toEndToken();
                        continue;
                    }
                    javax.xml.namespace.QName qname = cursor.getName();
                    if (qname.getNamespaceURI().length() == 0) {
                        qname = new javax.xml.namespace.QName(defaultURI, qname.getLocalPart());
                        cursor.setName(qname);
                    }
                    if (!isRoot) continue;
                    cursor.push();
                    cursor.toNextToken();
                    cursor.insertNamespace("", defaultURI);
                    cursor.pop();
                    isRoot = false;
                }
                cursor.dispose();
            }
        }
        catch (XmlException xe) {
            String errMsg = xe.getMessage();
            if (errMsg.equals("error: Unexpected end of file after null")) {
                xo = XmlObject.Factory.newInstance();
            }
            throw ScriptRuntime.typeError(xe.getMessage());
        }
        catch (Throwable e) {
            throw ScriptRuntime.typeError("Not Parsable as XML");
        }
        XmlCursor curs = xo.newCursor();
        if (curs.currentTokenType().isStartdoc()) {
            curs.toFirstContentToken();
        }
        if (isText) {
            curs.toFirstContentToken();
        }
        try {
            anno = new XScriptAnnotation(curs);
            curs.setBookmark((XmlCursor.XmlBookmark)anno);
        }
        finally {
            curs.dispose();
        }
        return new XML(lib, anno);
    }

    static XML getFromAnnotation(XMLLibImpl lib, XScriptAnnotation anno) {
        if (anno._xScriptXML == null) {
            anno._xScriptXML = new XML(lib, anno);
        }
        return anno._xScriptXML;
    }

    private static XmlCursor.TokenType skipNonElements(XmlCursor curs) {
        XmlCursor.TokenType tt = curs.currentTokenType();
        while (tt.isComment() || tt.isProcinst()) {
            tt = curs.toNextToken();
        }
        return tt;
    }

    protected static XScriptAnnotation findAnnotation(XmlCursor curs) {
        XmlCursor.XmlBookmark anno = curs.getBookmark((Object)(class$org$mozilla$javascript$xml$impl$xmlbeans$XML$XScriptAnnotation == null ? (class$org$mozilla$javascript$xml$impl$xmlbeans$XML$XScriptAnnotation = XML.class$("org.mozilla.javascript.xml.impl.xmlbeans.XML$XScriptAnnotation")) : class$org$mozilla$javascript$xml$impl$xmlbeans$XML$XScriptAnnotation));
        if (anno == null) {
            anno = new XScriptAnnotation(curs);
            curs.setBookmark(anno);
        }
        return (XScriptAnnotation)anno;
    }

    private XmlOptions getOptions() {
        XmlOptions options = new XmlOptions();
        if (this.lib.ignoreComments) {
            options.put((Object)"LOAD_STRIP_COMMENTS");
        }
        if (this.lib.ignoreProcessingInstructions) {
            options.put((Object)"LOAD_STRIP_PROCINSTS");
        }
        if (this.lib.ignoreWhitespace) {
            options.put((Object)"LOAD_STRIP_WHITESPACE");
        }
        if (this.lib.prettyPrinting) {
            options.put((Object)"SAVE_PRETTY_PRINT", null);
            options.put((Object)"SAVE_PRETTY_PRINT_INDENT", (Object)new Integer(this.lib.prettyIndent));
        }
        return options;
    }

    private static String dumpNode(XmlCursor cursor, XmlOptions opts) {
        if (cursor.isText()) {
            return cursor.getChars();
        }
        if (cursor.isFinish()) {
            return "";
        }
        cursor.push();
        boolean wanRawText = cursor.isStartdoc() && !cursor.toFirstChild();
        cursor.pop();
        return wanRawText ? cursor.getTextValue() : cursor.xmlText(opts);
    }

    private XmlCursor newCursor() {
        XmlCursor curs;
        if (this._anno != null) {
            curs = this._anno.createCursor();
            if (curs == null) {
                XmlObject doc = XmlObject.Factory.newInstance();
                curs = doc.newCursor();
                if (this._anno._name != null) {
                    curs.toNextToken();
                    curs.insertElement(this._anno._name);
                    curs.toPrevSibling();
                }
                curs.setBookmark((XmlCursor.XmlBookmark)this._anno);
            }
        } else {
            XmlObject doc = XmlObject.Factory.newInstance();
            curs = doc.newCursor();
        }
        return curs;
    }

    private boolean moveToChild(XmlCursor curs, long index, boolean fFirstChild, boolean fUseStartDoc) {
        block11: {
            XmlCursor.TokenType tt;
            if (index < 0L) {
                throw new IllegalArgumentException();
            }
            long idxChild = 0L;
            if (!fUseStartDoc && curs.currentTokenType().isStartdoc()) {
                curs.toFirstContentToken();
            }
            if (!(tt = curs.toFirstContentToken()).isNone() && !tt.isEnd()) {
                while (true) {
                    if (index == idxChild) {
                        return true;
                    }
                    tt = curs.currentTokenType();
                    if (tt.isText()) {
                        curs.toNextToken();
                    } else if (tt.isStart()) {
                        curs.toEndToken();
                        curs.toNextToken();
                    } else {
                        if (tt.isComment() || tt.isProcinst()) {
                            continue;
                        }
                        break block11;
                    }
                    ++idxChild;
                }
            }
            if (fFirstChild && index == 0L) {
                return true;
            }
        }
        return false;
    }

    XmlCursor.TokenType tokenType() {
        XmlCursor curs = this.newCursor();
        if (curs.isStartdoc()) {
            curs.toFirstContentToken();
        }
        XmlCursor.TokenType result = curs.currentTokenType();
        curs.dispose();
        return result;
    }

    private boolean moveSrcToDest(XmlCursor srcCurs, XmlCursor destCurs, boolean fDontMoveIfSame) {
        XmlCursor.TokenType tt;
        boolean fMovedSomething = true;
        do {
            if (fDontMoveIfSame && srcCurs.isInSameDocument(destCurs) && srcCurs.comparePosition(destCurs) == 0) {
                fMovedSomething = false;
                break;
            }
            if (destCurs.currentTokenType().isStartdoc()) {
                destCurs.toNextToken();
            }
            XmlCursor copyCurs = this.copy(srcCurs);
            copyCurs.moveXml(destCurs);
            copyCurs.dispose();
        } while (!(tt = srcCurs.currentTokenType()).isStart() && !tt.isEnd() && !tt.isEnddoc());
        return fMovedSomething;
    }

    /*
     * Unable to fully structure code
     */
    private XmlCursor copy(XmlCursor cursToCopy) {
        xo = XmlObject.Factory.newInstance();
        copyCurs = null;
        if (cursToCopy.currentTokenType().isText()) {
            try {
                copyCurs = XmlObject.Factory.parse((String)("<x:fragment xmlns:x=\"http://www.openuri.org/fragment\">" + cursToCopy.getChars() + "</x:fragment>")).newCursor();
                if (cursToCopy.toNextSibling() || !cursToCopy.currentTokenType().isText()) ** GOTO lbl23
                cursToCopy.toNextToken();
            }
            catch (Exception ex) {
                throw ScriptRuntime.typeError(ex.getMessage());
            }
        } else {
            copyCurs = xo.newCursor();
            copyCurs.toFirstContentToken();
            if (cursToCopy.currentTokenType() == XmlCursor.TokenType.STARTDOC) {
                cursToCopy.toNextToken();
            }
            cursToCopy.copyXml(copyCurs);
            if (!cursToCopy.toNextSibling() && cursToCopy.currentTokenType().isText()) {
                cursToCopy.toNextToken();
            }
        }
lbl23:
        // 5 sources

        copyCurs.toStartDoc();
        copyCurs.toFirstContentToken();
        return copyCurs;
    }

    private void insertChild(XmlCursor curs, Object xmlToInsert) {
        if (xmlToInsert != null && !(xmlToInsert instanceof Undefined)) {
            if (xmlToInsert instanceof XmlCursor) {
                this.moveSrcToDest((XmlCursor)xmlToInsert, curs, true);
            } else if (xmlToInsert instanceof XML) {
                XML xmlValue = (XML)xmlToInsert;
                if (xmlValue.tokenType() == XmlCursor.TokenType.ATTR) {
                    this.insertChild(curs, xmlValue.toString());
                } else {
                    XmlCursor cursToInsert = ((XML)xmlToInsert).newCursor();
                    this.moveSrcToDest(cursToInsert, curs, true);
                    cursToInsert.dispose();
                }
            } else if (xmlToInsert instanceof XMLList) {
                XMLList list = (XMLList)xmlToInsert;
                for (int i = 0; i < list.length(); ++i) {
                    this.insertChild(curs, list.item(i));
                }
            } else {
                String xmlStr = ScriptRuntime.toString(xmlToInsert);
                XmlObject xo = XmlObject.Factory.newInstance();
                XmlCursor sourceCurs = xo.newCursor();
                sourceCurs.toNextToken();
                sourceCurs.insertChars(xmlStr);
                sourceCurs.toPrevToken();
                this.moveSrcToDest(sourceCurs, curs, true);
            }
        }
    }

    private void insertChild(XML childToMatch, Object xmlToInsert, int addToType) {
        XmlCursor curs = this.newCursor();
        XmlCursor.TokenType tt = curs.currentTokenType();
        XmlCursor xmlChildCursor = childToMatch.newCursor();
        if (tt.isStartdoc()) {
            tt = curs.toFirstContentToken();
        }
        if (tt.isContainer()) {
            tt = curs.toNextToken();
            while (!tt.isEnd()) {
                if (tt.isStart() && curs.comparePosition(xmlChildCursor) == 0) {
                    if (addToType == 1) {
                        curs.toEndToken();
                        curs.toNextToken();
                    }
                    this.insertChild(curs, xmlToInsert);
                    break;
                }
                if (tt.isStart()) {
                    tt = curs.toEndToken();
                }
                tt = curs.toNextToken();
            }
        }
        xmlChildCursor.dispose();
        curs.dispose();
    }

    protected void removeToken(XmlCursor curs) {
        XmlObject xo = XmlObject.Factory.newInstance();
        XmlCursor tmpCurs = xo.newCursor();
        tmpCurs.toFirstContentToken();
        curs.moveXml(tmpCurs);
        tmpCurs.dispose();
    }

    protected void removeChild(long index) {
        XmlCursor curs = this.newCursor();
        if (this.moveToChild(curs, index, false, false)) {
            this.removeToken(curs);
        }
        curs.dispose();
    }

    protected static javax.xml.namespace.QName computeQName(Object name) {
        if (name instanceof String) {
            int idx;
            String fullName;
            String ns = null;
            String localName = null;
            localName = fullName = (String)name;
            if (fullName.startsWith("\"") && (idx = fullName.indexOf(":")) != -1) {
                ns = fullName.substring(1, idx - 1);
                localName = fullName.substring(idx + 1);
            }
            if (ns == null) {
                return new javax.xml.namespace.QName(localName);
            }
            return new javax.xml.namespace.QName(ns, localName);
        }
        return null;
    }

    private void replace(XmlCursor destCurs, XML newValue) {
        if (destCurs.isStartdoc()) {
            destCurs.toFirstContentToken();
        }
        this.removeToken(destCurs);
        XmlCursor srcCurs = newValue.newCursor();
        if (srcCurs.currentTokenType().isStartdoc()) {
            srcCurs.toFirstContentToken();
        }
        this.moveSrcToDest(srcCurs, destCurs, false);
        if (!destCurs.toPrevSibling()) {
            destCurs.toPrevToken();
        }
        destCurs.setBookmark((XmlCursor.XmlBookmark)new XScriptAnnotation(destCurs));
        destCurs.toEndToken();
        destCurs.toNextToken();
        srcCurs.dispose();
    }

    private boolean doPut(XMLName name, XML currXMLNode, XMLObjectImpl xmlValue) {
        boolean result = false;
        XmlCursor curs = currXMLNode.newCursor();
        try {
            int toAssignLen = xmlValue.length();
            for (int i = 0; i < toAssignLen; ++i) {
                XML xml = xmlValue instanceof XMLList ? ((XMLList)xmlValue).item(i) : (XML)xmlValue;
                XmlCursor.TokenType tt = xml.tokenType();
                if (tt == XmlCursor.TokenType.ATTR || tt == XmlCursor.TokenType.TEXT) {
                    xml = this.makeXmlFromString(this.lib, name, xml.toString());
                }
                if (i == 0) {
                    this.replace(curs, xml);
                    continue;
                }
                this.insertChild(curs, xml);
            }
            result = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ScriptRuntime.typeError(ex.getMessage());
        }
        finally {
            curs.dispose();
        }
        return result;
    }

    private XML makeXmlFromString(XMLLibImpl lib, XMLName name, String value) {
        javax.xml.namespace.QName qname;
        try {
            qname = new javax.xml.namespace.QName(name.uri(), name.localName());
        }
        catch (Exception e) {
            throw ScriptRuntime.typeError(e.getMessage());
        }
        XML result = XML.createTextElement(lib, qname, value);
        return result;
    }

    private XMLList matchAttributes(XMLName xmlName) {
        XMLList result = new XMLList(this.lib);
        XmlCursor curs = this.newCursor();
        if (curs.currentTokenType().isStartdoc()) {
            curs.toFirstContentToken();
        }
        if (curs.isStart() && curs.toFirstAttribute()) {
            do {
                if (!this.qnameMatches(xmlName, curs.getName())) continue;
                result.addToList(this.createAttributeObject(curs));
            } while (curs.toNextAttribute());
        }
        curs.dispose();
        return result;
    }

    private XML createAttributeObject(XmlCursor attrCurs) {
        XML result = null;
        if (attrCurs.currentTokenType().isAttr()) {
            result = XML.createAttributeXML(this.lib, attrCurs);
        }
        return result;
    }

    public String getClassName() {
        return "XML";
    }

    public Object get(int index, Scriptable start) {
        if (index == 0) {
            return this;
        }
        return Scriptable.NOT_FOUND;
    }

    boolean hasXMLProperty(XMLName xmlName) {
        boolean result = false;
        if (this.prototypeFlag) {
            String name = xmlName.localName();
            if (this.getMethod(name) != NOT_FOUND) {
                result = true;
            }
        } else {
            String name = xmlName.localName();
            if (this.getPropertyList(xmlName).length() > 0 || this.getMethod(name) != NOT_FOUND) {
                result = true;
            }
        }
        return result;
    }

    public boolean has(int index, Scriptable start) {
        return index == 0;
    }

    public Object[] getIds() {
        Object[] enumObjs = this.prototypeFlag ? new Object[]{} : new Object[]{new Integer(0)};
        return enumObjs;
    }

    public Object[] getIdsForDebug() {
        return this.getIds();
    }

    Object getXMLProperty(XMLName xmlName) {
        Object result = NOT_FOUND;
        if (this.prototypeFlag) {
            String name = xmlName.localName();
            result = this.getMethod(name);
        } else {
            result = this.getPropertyList(xmlName);
        }
        return result;
    }

    void putXMLProperty(XMLName xmlName, Object value) {
        if (!this.prototypeFlag) {
            if (value == null) {
                value = "null";
            } else if (value instanceof Undefined) {
                value = "undefined";
            }
            if (xmlName.isAttributeName()) {
                this.setAttribute(xmlName, value);
            } else if (xmlName.uri() == null && xmlName.localName().equals("*")) {
                this.setChildren(value);
            } else {
                XMLList matches;
                XMLObjectImpl xmlValue = null;
                if (value instanceof XMLObjectImpl) {
                    xmlValue = (XMLObjectImpl)value;
                    if (xmlValue instanceof XML && ((XML)xmlValue).tokenType() == XmlCursor.TokenType.ATTR) {
                        xmlValue = this.makeXmlFromString(this.lib, xmlName, xmlValue.toString());
                    }
                    if (xmlValue instanceof XMLList) {
                        for (int i = 0; i < xmlValue.length(); ++i) {
                            XML xml = ((XMLList)xmlValue).item(i);
                            if (xml.tokenType() != XmlCursor.TokenType.ATTR) continue;
                            ((XMLList)xmlValue).replace(i, this.makeXmlFromString(this.lib, xmlName, xml.toString()));
                        }
                    }
                } else {
                    xmlValue = this.makeXmlFromString(this.lib, xmlName, ScriptRuntime.toString(value));
                }
                if ((matches = this.getPropertyList(xmlName)).length() == 0) {
                    this.appendChild(xmlValue);
                } else {
                    for (int i = 1; i < matches.length(); ++i) {
                        this.removeChild(matches.item(i).childIndex());
                    }
                    this.doPut(xmlName, matches.item(0), xmlValue);
                }
            }
        }
    }

    public void put(int index, Scriptable start, Object value) {
        throw ScriptRuntime.typeError("Assignment to indexed XML is not allowed");
    }

    void deleteXMLProperty(XMLName name) {
        if (!name.isDescendants() && name.isAttributeName()) {
            XmlCursor curs = this.newCursor();
            if (name.localName().equals("*")) {
                if (curs.toFirstAttribute()) {
                    while (curs.currentTokenType().isAttr()) {
                        curs.removeXml();
                    }
                }
            } else {
                javax.xml.namespace.QName qname = new javax.xml.namespace.QName(name.uri(), name.localName());
                curs.removeAttribute(qname);
            }
            curs.dispose();
        } else {
            XMLList matches = this.getPropertyList(name);
            matches.remove();
        }
    }

    public void delete(int index) {
        if (index == 0) {
            this.remove();
        }
    }

    protected XScriptAnnotation getAnnotation() {
        return this._anno;
    }

    protected void changeNS(String oldURI, String newURI) {
        XmlCursor curs = this.newCursor();
        while (curs.toParent()) {
        }
        XmlCursor.TokenType tt = curs.currentTokenType();
        if (tt.isStartdoc()) {
            tt = curs.toFirstContentToken();
        }
        if (tt.isStart()) {
            do {
                javax.xml.namespace.QName currQName;
                if (!tt.isStart() && !tt.isAttr() && !tt.isNamespace() || !oldURI.equals((currQName = curs.getName()).getNamespaceURI())) continue;
                curs.setName(new javax.xml.namespace.QName(newURI, currQName.getLocalPart()));
            } while (!(tt = curs.toNextToken()).isEnddoc() && !tt.isNone());
        }
        curs.dispose();
    }

    void remove() {
        XmlCursor childCurs = this.newCursor();
        if (childCurs.currentTokenType().isStartdoc()) {
            XmlCursor.TokenType tt = childCurs.toFirstContentToken();
            while (!tt.isEnd() && !tt.isEnddoc()) {
                this.removeToken(childCurs);
                tt = childCurs.currentTokenType();
            }
        } else {
            this.removeToken(childCurs);
        }
        childCurs.dispose();
    }

    void replaceAll(XML value) {
        XmlCursor curs = this.newCursor();
        this.replace(curs, value);
        this._anno = value._anno;
        curs.dispose();
    }

    void setAttribute(XMLName xmlName, Object value) {
        javax.xml.namespace.QName qName;
        if (xmlName.uri() == null && xmlName.localName().equals("*")) {
            throw ScriptRuntime.typeError("@* assignment not supported.");
        }
        XmlCursor curs = this.newCursor();
        String strValue = ScriptRuntime.toString(value);
        if (curs.currentTokenType().isStartdoc()) {
            curs.toFirstContentToken();
        }
        try {
            qName = new javax.xml.namespace.QName(xmlName.uri(), xmlName.localName());
        }
        catch (Exception e) {
            throw ScriptRuntime.typeError(e.getMessage());
        }
        if (!curs.setAttributeText(qName, strValue)) {
            if (curs.currentTokenType().isStart()) {
                curs.toNextToken();
            }
            curs.insertAttributeWithValue(qName, strValue);
        }
        curs.dispose();
    }

    private XMLList allChildNodes(String namespace) {
        XMLList result = new XMLList(this.lib);
        XmlCursor curs = this.newCursor();
        XmlCursor.TokenType tt = curs.currentTokenType();
        javax.xml.namespace.QName targetProperty = new javax.xml.namespace.QName(namespace, "*");
        if (tt.isStartdoc()) {
            tt = curs.toFirstContentToken();
        }
        if (tt.isContainer()) {
            tt = curs.toFirstContentToken();
            while (!tt.isEnd()) {
                if (!tt.isStart()) {
                    result.addToList(XML.findAnnotation(curs));
                    targetProperty = null;
                } else if (namespace == null || namespace.length() == 0 || namespace.equals("*") || curs.getName().getNamespaceURI().equals(namespace)) {
                    result.addToList(XML.findAnnotation(curs));
                    if (targetProperty != null) {
                        if (targetProperty.getLocalPart().equals("*")) {
                            targetProperty = curs.getName();
                        } else if (!targetProperty.getLocalPart().equals(curs.getName().getLocalPart())) {
                            targetProperty = null;
                        }
                    }
                }
                if (tt.isStart()) {
                    tt = curs.toEndToken();
                }
                tt = curs.toNextToken();
            }
        }
        curs.dispose();
        result.setTargets(this, targetProperty);
        return result;
    }

    private XMLList matchDescendantAttributes(XMLName xmlName) {
        XMLList result = new XMLList(this.lib);
        XmlCursor curs = this.newCursor();
        XmlCursor.TokenType tt = curs.currentTokenType();
        result.setTargets(this, null);
        if (tt.isStartdoc()) {
            tt = curs.toFirstContentToken();
        }
        if (tt.isContainer()) {
            int nestLevel = 1;
            while (nestLevel > 0) {
                tt = curs.toNextToken();
                if (tt.isAttr() && this.qnameMatches(xmlName, curs.getName())) {
                    result.addToList(XML.findAnnotation(curs));
                }
                if (tt.isStart()) {
                    ++nestLevel;
                    continue;
                }
                if (tt.isEnd()) {
                    --nestLevel;
                    continue;
                }
                if (!tt.isEnddoc()) continue;
            }
        }
        curs.dispose();
        return result;
    }

    private XMLList matchDescendantChildren(XMLName xmlName) {
        XMLList result = new XMLList(this.lib);
        XmlCursor curs = this.newCursor();
        XmlCursor.TokenType tt = curs.currentTokenType();
        result.setTargets(this, null);
        if (tt.isStartdoc()) {
            tt = curs.toFirstContentToken();
        }
        if (tt.isContainer()) {
            int nestLevel = 1;
            while (nestLevel > 0) {
                tt = curs.toNextToken();
                if (!(tt.isAttr() || tt.isEnd() || tt.isEnddoc())) {
                    if (!tt.isStart() && !tt.isProcinst()) {
                        if (xmlName.localName().equals("*")) {
                            result.addToList(XML.findAnnotation(curs));
                        }
                    } else if (this.qnameMatches(xmlName, curs.getName())) {
                        result.addToList(XML.findAnnotation(curs));
                    }
                }
                if (tt.isStart()) {
                    ++nestLevel;
                    continue;
                }
                if (tt.isEnd()) {
                    --nestLevel;
                    continue;
                }
                if (!tt.isEnddoc()) continue;
            }
        }
        curs.dispose();
        return result;
    }

    private XMLList matchChildren(XmlCursor.TokenType tokenType) {
        return this.matchChildren(tokenType, XMLName.formStar());
    }

    private XMLList matchChildren(XmlCursor.TokenType tokenType, XMLName name) {
        javax.xml.namespace.QName qname;
        XMLList result = new XMLList(this.lib);
        XmlCursor curs = this.newCursor();
        XmlCursor.TokenType tt = curs.currentTokenType();
        javax.xml.namespace.QName targetProperty = qname = new javax.xml.namespace.QName(name.uri(), name.localName());
        if (tt.isStartdoc()) {
            tt = curs.toFirstContentToken();
        }
        if (tt.isContainer()) {
            tt = curs.toFirstContentToken();
            while (!tt.isEnd()) {
                if (tt == tokenType) {
                    if (!tt.isStart() && !tt.isProcinst()) {
                        result.addToList(XML.findAnnotation(curs));
                        targetProperty = null;
                    } else if (this.qnameMatches(name, curs.getName())) {
                        result.addToList(XML.findAnnotation(curs));
                        if (targetProperty != null) {
                            if (targetProperty.getLocalPart().equals("*")) {
                                targetProperty = curs.getName();
                            } else if (!targetProperty.getLocalPart().equals(curs.getName().getLocalPart())) {
                                targetProperty = null;
                            }
                        }
                    }
                }
                if (tt.isStart()) {
                    tt = curs.toEndToken();
                }
                tt = curs.toNextToken();
            }
        }
        curs.dispose();
        if (tokenType == XmlCursor.TokenType.START) {
            result.setTargets(this, targetProperty);
        }
        return result;
    }

    private boolean qnameMatches(XMLName template, javax.xml.namespace.QName match) {
        boolean matches = false;
        if ((template.uri() == null || template.uri().equals(match.getNamespaceURI())) && (template.localName().equals("*") || template.localName().equals(match.getLocalPart()))) {
            matches = true;
        }
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XML addNamespace(Namespace ns) {
        String nsPrefix = ns.prefix();
        if (nsPrefix == null) {
            return this;
        }
        XmlCursor cursor = this.newCursor();
        try {
            if (!cursor.isContainer()) {
                XML xML = this;
                return xML;
            }
            javax.xml.namespace.QName qname = cursor.getName();
            if (qname.getNamespaceURI().equals("") && nsPrefix.equals("")) {
                XML xML = this;
                return xML;
            }
            Map prefixToURI = NamespaceHelper.getAllNamespaces(this.lib, cursor);
            String uri = (String)prefixToURI.get(nsPrefix);
            if (uri != null) {
                if (uri.equals(ns.uri())) {
                    XML xML = this;
                    return xML;
                }
                cursor.push();
                while (cursor.toNextToken().isAnyAttr()) {
                    String prefix;
                    if (!cursor.isNamespace() || !(prefix = (qname = cursor.getName()).getLocalPart()).equals(nsPrefix)) continue;
                    cursor.removeXml();
                    break;
                }
                cursor.pop();
            }
            cursor.toNextToken();
            cursor.insertNamespace(nsPrefix, ns.uri());
        }
        finally {
            cursor.dispose();
        }
        return this;
    }

    XML appendChild(Object xml) {
        XmlCursor curs = this.newCursor();
        if (curs.isStartdoc()) {
            curs.toFirstContentToken();
        }
        if (curs.isStart()) {
            curs.toEndToken();
        }
        this.insertChild(curs, xml);
        curs.dispose();
        return this;
    }

    XMLList attribute(XMLName xmlName) {
        return this.matchAttributes(xmlName);
    }

    XMLList attributes() {
        XMLName xmlName = XMLName.formStar();
        return this.matchAttributes(xmlName);
    }

    XMLList child(long index) {
        XMLList result = new XMLList(this.lib);
        result.setTargets(this, null);
        result.addToList(this.getXmlChild(index));
        return result;
    }

    XMLList child(XMLName xmlName) {
        if (xmlName == null) {
            return new XMLList(this.lib);
        }
        XMLList result = xmlName.localName().equals("*") ? this.allChildNodes(xmlName.uri()) : this.matchChildren(XmlCursor.TokenType.START, xmlName);
        return result;
    }

    XML getXmlChild(long index) {
        XML result = null;
        XmlCursor curs = this.newCursor();
        if (this.moveToChild(curs, index, false, true)) {
            result = XML.createXML(this.lib, curs);
        }
        curs.dispose();
        return result;
    }

    int childIndex() {
        int index = 0;
        XmlCursor curs = this.newCursor();
        XmlCursor.TokenType tt = curs.currentTokenType();
        while (true) {
            if (tt.isText()) {
                ++index;
                if (!curs.toPrevSibling()) {
                    break;
                }
            } else if (tt.isStart()) {
                tt = curs.toPrevToken();
                if (!tt.isEnd()) break;
                curs.toNextToken();
                if (!curs.toPrevSibling()) break;
                ++index;
            } else {
                if (!tt.isComment() && !tt.isProcinst()) break;
                curs.toPrevToken();
            }
            tt = curs.currentTokenType();
        }
        index = curs.currentTokenType().isStartdoc() ? -1 : index;
        curs.dispose();
        return index;
    }

    XMLList children() {
        return this.allChildNodes(null);
    }

    XMLList comments() {
        return this.matchChildren(XmlCursor.TokenType.COMMENT);
    }

    boolean contains(Object xml) {
        boolean result = false;
        if (xml instanceof XML) {
            result = this.equivalentXml(xml);
        }
        return result;
    }

    Object copy() {
        XmlCursor srcCurs = this.newCursor();
        if (srcCurs.isStartdoc()) {
            srcCurs.toFirstContentToken();
        }
        XML xml = XML.createEmptyXML(this.lib);
        XmlCursor destCurs = xml.newCursor();
        destCurs.toFirstContentToken();
        srcCurs.copyXml(destCurs);
        destCurs.dispose();
        srcCurs.dispose();
        return xml;
    }

    XMLList descendants(XMLName xmlName) {
        XMLList result = xmlName.isAttributeName() ? this.matchDescendantAttributes(xmlName) : this.matchDescendantChildren(xmlName);
        return result;
    }

    Object[] inScopeNamespaces() {
        XmlCursor cursor = this.newCursor();
        Object[] namespaces = NamespaceHelper.inScopeNamespaces(this.lib, cursor);
        cursor.dispose();
        return namespaces;
    }

    XML insertChildAfter(Object child, Object xml) {
        if (child == null) {
            this.prependChild(xml);
        } else if (child instanceof XML) {
            this.insertChild((XML)child, xml, 1);
        }
        return this;
    }

    XML insertChildBefore(Object child, Object xml) {
        if (child == null) {
            this.appendChild(xml);
        } else if (child instanceof XML) {
            this.insertChild((XML)child, xml, 2);
        }
        return this;
    }

    boolean hasOwnProperty(XMLName xmlName) {
        String property;
        boolean hasProperty = false;
        hasProperty = this.prototypeFlag ? 0 != this.findPrototypeId(property = xmlName.localName()) : this.getPropertyList(xmlName).length() > 0;
        return hasProperty;
    }

    boolean hasComplexContent() {
        return !this.hasSimpleContent();
    }

    boolean hasSimpleContent() {
        boolean simpleContent = false;
        XmlCursor curs = this.newCursor();
        if (curs.isAttr() || curs.isText()) {
            return true;
        }
        if (curs.isStartdoc()) {
            curs.toFirstContentToken();
        }
        simpleContent = !curs.toFirstChild();
        curs.dispose();
        return simpleContent;
    }

    int length() {
        return 1;
    }

    String localName() {
        XmlCursor cursor = this.newCursor();
        if (cursor.isStartdoc()) {
            cursor.toFirstContentToken();
        }
        String name = null;
        if (cursor.isStart() || cursor.isAttr() || cursor.isProcinst()) {
            javax.xml.namespace.QName qname = cursor.getName();
            name = qname.getLocalPart();
        }
        cursor.dispose();
        return name;
    }

    QName name() {
        XmlCursor cursor = this.newCursor();
        if (cursor.isStartdoc()) {
            cursor.toFirstContentToken();
        }
        QName name = null;
        if (cursor.isStart() || cursor.isAttr() || cursor.isProcinst()) {
            javax.xml.namespace.QName qname = cursor.getName();
            if (cursor.isProcinst()) {
                name = new QName(this.lib, "", qname.getLocalPart(), "");
            } else {
                String uri = qname.getNamespaceURI();
                String prefix = qname.getPrefix();
                name = new QName(this.lib, uri, qname.getLocalPart(), prefix);
            }
        }
        cursor.dispose();
        return name;
    }

    Object namespace(String prefix) {
        XmlCursor cursor = this.newCursor();
        if (cursor.isStartdoc()) {
            cursor.toFirstContentToken();
        }
        Object result = null;
        if (prefix == null) {
            if (cursor.isStart() || cursor.isAttr()) {
                Object[] inScopeNS = NamespaceHelper.inScopeNamespaces(this.lib, cursor);
                XmlCursor cursor2 = this.newCursor();
                if (cursor2.isStartdoc()) {
                    cursor2.toFirstContentToken();
                }
                result = NamespaceHelper.getNamespace(this.lib, cursor2, inScopeNS);
                cursor2.dispose();
            }
        } else {
            Map prefixToURI = NamespaceHelper.getAllNamespaces(this.lib, cursor);
            String uri = (String)prefixToURI.get(prefix);
            result = uri == null ? Undefined.instance : new Namespace(this.lib, prefix, uri);
        }
        cursor.dispose();
        return result;
    }

    Object[] namespaceDeclarations() {
        XmlCursor cursor = this.newCursor();
        Object[] namespaces = NamespaceHelper.namespaceDeclarations(this.lib, cursor);
        cursor.dispose();
        return namespaces;
    }

    Object nodeKind() {
        XmlCursor.TokenType tt = this.tokenType();
        String result = tt == XmlCursor.TokenType.ATTR ? "attribute" : (tt == XmlCursor.TokenType.TEXT ? "text" : (tt == XmlCursor.TokenType.COMMENT ? "comment" : (tt == XmlCursor.TokenType.PROCINST ? "processing-instruction" : (tt == XmlCursor.TokenType.START ? "element" : "text"))));
        return result;
    }

    void normalize() {
        XmlCursor curs = this.newCursor();
        XmlCursor.TokenType tt = curs.currentTokenType();
        if (tt.isStartdoc()) {
            tt = curs.toFirstContentToken();
        }
        if (tt.isContainer()) {
            int nestLevel = 1;
            String previousText = null;
            while (nestLevel > 0) {
                tt = curs.toNextToken();
                if (tt == XmlCursor.TokenType.TEXT) {
                    String currentText = curs.getChars().trim();
                    if (currentText.trim().length() == 0) {
                        this.removeToken(curs);
                        curs.toPrevToken();
                    } else if (previousText == null) {
                        previousText = currentText;
                    } else {
                        String newText = previousText + currentText;
                        curs.toPrevToken();
                        this.removeToken(curs);
                        this.removeToken(curs);
                        curs.insertChars(newText);
                    }
                } else {
                    previousText = null;
                }
                if (tt.isStart()) {
                    ++nestLevel;
                    continue;
                }
                if (tt.isEnd()) {
                    --nestLevel;
                    continue;
                }
                if (!tt.isEnddoc()) continue;
            }
        }
        curs.dispose();
    }

    Object parent() {
        XmlCursor curs = this.newCursor();
        Object parent = curs.isStartdoc() ? Undefined.instance : (curs.toParent() ? (curs.isStartdoc() ? Undefined.instance : XML.getFromAnnotation(this.lib, XML.findAnnotation(curs))) : Undefined.instance);
        curs.dispose();
        return parent;
    }

    XML prependChild(Object xml) {
        XmlCursor curs = this.newCursor();
        if (curs.isStartdoc()) {
            curs.toFirstContentToken();
        }
        curs.toFirstContentToken();
        this.insertChild(curs, xml);
        curs.dispose();
        return this;
    }

    Object processingInstructions(XMLName xmlName) {
        return this.matchChildren(XmlCursor.TokenType.PROCINST, xmlName);
    }

    boolean propertyIsEnumerable(Object name) {
        double x;
        boolean result = name instanceof Integer ? (Integer)name == 0 : (name instanceof Number ? (x = ((Number)name).doubleValue()) == 0.0 && 1.0 / x > 0.0 : ScriptRuntime.toString(name).equals("0"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XML removeNamespace(Namespace ns) {
        XmlCursor cursor = this.newCursor();
        try {
            if (cursor.isStartdoc()) {
                cursor.toFirstContentToken();
            }
            if (!cursor.isStart()) {
                XML xML = this;
                return xML;
            }
            String nsPrefix = ns.prefix();
            String nsURI = ns.uri();
            HashMap prefixToURI = new HashMap();
            int depth = 1;
            while (!cursor.isEnd() || depth != 0) {
                if (cursor.isStart()) {
                    prefixToURI.clear();
                    NamespaceHelper.getNamespaces(cursor, prefixToURI);
                    ObjArray inScopeNSBag = new ObjArray();
                    Iterator i = prefixToURI.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        ns = new Namespace(this.lib, (String)entry.getKey(), (String)entry.getValue());
                        inScopeNSBag.add(ns);
                    }
                    ns = new Namespace(this.lib, nsURI);
                    inScopeNSBag.add(ns);
                    Object[] inScopeNS = inScopeNSBag.toArray();
                    Namespace n = NamespaceHelper.getNamespace(this.lib, cursor, inScopeNS);
                    if (nsURI.equals(n.uri()) && (nsPrefix == null || nsPrefix.equals(n.prefix()))) {
                        XML xML = this;
                        return xML;
                    }
                    cursor.push();
                    boolean hasNext = cursor.toFirstAttribute();
                    while (hasNext) {
                        n = NamespaceHelper.getNamespace(this.lib, cursor, inScopeNS);
                        if (nsURI.equals(n.uri()) && (nsPrefix == null || nsPrefix.equals(n.prefix()))) {
                            XML xML = this;
                            return xML;
                        }
                        hasNext = cursor.toNextAttribute();
                    }
                    cursor.pop();
                    if (nsPrefix == null) {
                        i = prefixToURI.entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry entry = i.next();
                            if (!entry.getValue().equals(nsURI)) continue;
                            NamespaceHelper.removeNamespace(cursor, (String)entry.getKey());
                        }
                    } else if (nsURI.equals(prefixToURI.get(nsPrefix))) {
                        NamespaceHelper.removeNamespace(cursor, String.valueOf(nsPrefix));
                    }
                }
                switch (cursor.toNextToken().intValue()) {
                    case 3: {
                        ++depth;
                        break;
                    }
                    case 4: {
                        --depth;
                    }
                }
            }
        }
        finally {
            cursor.dispose();
        }
        return this;
    }

    XML replace(long index, Object xml) {
        XMLList xlChildToReplace = this.child(index);
        if (xlChildToReplace.length() > 0) {
            XML childToReplace = xlChildToReplace.item(0);
            this.insertChildAfter(childToReplace, xml);
            this.removeChild(index);
        }
        return this;
    }

    XML replace(XMLName xmlName, Object xml) {
        this.putXMLProperty(xmlName, xml);
        return this;
    }

    XML setChildren(Object xml) {
        XMLName xmlName = XMLName.formStar();
        XMLList matches = this.getPropertyList(xmlName);
        matches.remove();
        this.appendChild(xml);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLocalName(String localName) {
        XmlCursor cursor = this.newCursor();
        try {
            if (cursor.isStartdoc()) {
                cursor.toFirstContentToken();
            }
            if (cursor.isText() || cursor.isComment()) {
                return;
            }
            javax.xml.namespace.QName qname = cursor.getName();
            cursor.setName(new javax.xml.namespace.QName(qname.getNamespaceURI(), localName, qname.getPrefix()));
        }
        finally {
            cursor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setName(QName qname) {
        XmlCursor cursor = this.newCursor();
        try {
            if (cursor.isStartdoc()) {
                cursor.toFirstContentToken();
            }
            if (cursor.isText() || cursor.isComment()) {
                return;
            }
            if (cursor.isProcinst()) {
                String localName = qname.localName();
                cursor.setName(new javax.xml.namespace.QName(localName));
            } else {
                String prefix = qname.prefix();
                if (prefix == null) {
                    prefix = "";
                }
                cursor.setName(new javax.xml.namespace.QName(qname.uri(), qname.localName(), prefix));
            }
        }
        finally {
            cursor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNamespace(Namespace ns) {
        XmlCursor cursor = this.newCursor();
        try {
            if (cursor.isStartdoc()) {
                cursor.toFirstContentToken();
            }
            if (cursor.isText() || cursor.isComment() || cursor.isProcinst()) {
                return;
            }
            String prefix = ns.prefix();
            if (prefix == null) {
                prefix = "";
            }
            cursor.setName(new javax.xml.namespace.QName(ns.uri(), this.localName(), prefix));
        }
        finally {
            cursor.dispose();
        }
    }

    XMLList text() {
        return this.matchChildren(XmlCursor.TokenType.TEXT);
    }

    public String toString() {
        XmlCursor curs = this.newCursor();
        if (curs.isStartdoc()) {
            curs.toFirstContentToken();
        }
        String result = curs.isText() ? curs.getChars() : (curs.isStart() && this.hasSimpleContent() ? curs.getTextValue() : this.toXMLString(0));
        return result;
    }

    String toSource(int indent) {
        return this.toXMLString(indent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String toXMLString(int indent) {
        String result;
        XmlCursor curs = this.newCursor();
        if (curs.isStartdoc()) {
            curs.toFirstContentToken();
        }
        try {
            if (curs.isText()) {
                result = curs.getChars();
            } else if (curs.isAttr()) {
                result = curs.getTextValue();
            } else if (curs.isComment() || curs.isProcinst()) {
                result = XML.dumpNode(curs, this.getOptions());
                String start = "<xml-fragment>";
                String end = "</xml-fragment>";
                if (result.startsWith(start)) {
                    result = result.substring(start.length());
                }
                if (result.endsWith(end)) {
                    result = result.substring(0, result.length() - end.length());
                }
            } else {
                result = XML.dumpNode(curs, this.getOptions());
            }
        }
        finally {
            curs.dispose();
        }
        return result;
    }

    Object valueOf() {
        return this;
    }

    boolean equivalentXml(Object target) {
        boolean result = false;
        if (target instanceof XML) {
            XML otherXml = (XML)target;
            XmlCursor.TokenType thisTT = this.tokenType();
            XmlCursor.TokenType otherTT = otherXml.tokenType();
            if (thisTT == XmlCursor.TokenType.ATTR || otherTT == XmlCursor.TokenType.ATTR || thisTT == XmlCursor.TokenType.TEXT || otherTT == XmlCursor.TokenType.TEXT) {
                result = this.toString().equals(otherXml.toString());
            } else {
                XmlCursor cursOne = this.newCursor();
                XmlCursor cursTwo = otherXml.newCursor();
                result = LogicalEquality.nodesEqual(cursOne, cursTwo);
                cursOne.dispose();
                cursTwo.dispose();
            }
        } else if (target instanceof XMLList) {
            XMLList otherList = (XMLList)target;
            if (otherList.length() == 1) {
                result = this.equivalentXml(otherList.getXmlFromAnnotation(0));
            }
        } else if (this.hasSimpleContent()) {
            String otherStr = ScriptRuntime.toString(target);
            result = this.toString().equals(otherStr);
        }
        return result;
    }

    XMLList getPropertyList(XMLName name) {
        XMLList result = name.isDescendants() ? this.descendants(name) : (name.isAttributeName() ? this.attribute(name) : this.child(name));
        return result;
    }

    protected Object jsConstructor(Context cx, boolean inNewExpr, Object[] args) {
        if (args.length == 0) {
            return XML.createFromJS(this.lib, "");
        }
        Object arg0 = args[0];
        if (!inNewExpr && arg0 instanceof XML) {
            return arg0;
        }
        return XML.createFromJS(this.lib, arg0);
    }

    public Scriptable getExtraMethodSource(Context cx) {
        if (this.hasSimpleContent()) {
            String src = this.toString();
            return ScriptRuntime.toObjectOrNull(cx, src);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XmlObject getXmlObject() {
        XmlObject xo;
        XmlCursor cursor = this.newCursor();
        try {
            xo = cursor.getObject();
        }
        finally {
            cursor.dispose();
        }
        return xo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class NamespaceDeclarations {
        private int _prefixIdx = 0;
        private StringBuffer _namespaceDecls = new StringBuffer();
        private String _defaultNSURI;

        NamespaceDeclarations(XmlCursor curs) {
            XML.skipNonElements(curs);
            this._defaultNSURI = curs.namespaceForPrefix("");
            if (this.isAnyDefaultNamespace()) {
                this.addDecl("", this._defaultNSURI);
            }
        }

        private void addDecl(String prefix, String ns) {
            this._namespaceDecls.append((prefix.length() > 0 ? "declare namespace " + prefix : "default element namespace") + " = \"" + ns + "\"" + "\n");
        }

        String getNextPrefix(String ns) {
            String prefix = "NS" + this._prefixIdx++;
            this._namespaceDecls.append("declare namespace " + prefix + " = " + "\"" + ns + "\"" + "\n");
            return prefix;
        }

        boolean isAnyDefaultNamespace() {
            return this._defaultNSURI != null ? this._defaultNSURI.length() > 0 : false;
        }

        String getDeclarations() {
            return this._namespaceDecls.toString();
        }
    }

    static final class XScriptAnnotation
    extends XmlCursor.XmlBookmark
    implements Serializable {
        private static final long serialVersionUID = 1L;
        javax.xml.namespace.QName _name;
        XML _xScriptXML;

        XScriptAnnotation(XmlCursor curs) {
            this._name = curs.getName();
        }
    }
}

