use strict;
use warnings;
use vars qw($bootstrapping);

BEGIN {
  if (my ($x) = grep { /^--bootstrap(?:=.*)?$/ } @ARGV) {
    @ARGV = grep { !/^--bootstrap(?:=.*)?$/ } @ARGV;
    $bootstrapping = 1;
    $x =~ /^--bootstrap(?:=(.*))?$/;
    my @args = (defined $1 ? ($1) : ());

    {
      local @INC = @INC;
      unshift(@INC, 'lib');
      require local::lib;
    }

    local::lib->import(@args);

    push(@ARGV,$ENV{PERL_MM_OPT});
    push(@ARGV, map { "-I$_" } split(':',$ENV{PERL5LIB}));

    system($^X, '-MExtUtils::MakeMaker 6.31', '-e1');
    my $eumm = $? >> 8;

    system($^X, '-MCPAN 1.80', '-e1');
    my $cpan = $? >> 8;
    my $cpan_command = '';

    system($^X, '-MCPAN', '-e',
      'my $done; require ExtUtils::MakeMaker;
       my $orig = ExtUtils::MakeMaker->can("prompt");
       *ExtUtils::MakeMaker::prompt = sub {
         if (!$done && $_[0] =~ /manual configuration/) {
           $done++;
           return "no";
         }
         return $orig->(@_);
       };
       CPAN::Config->load;
       unless ($done || -w $CPAN::Config->{keep_source_where}) {
         my $save = $CPAN::Config->{urllist};
         delete @{$CPAN::Config}{keys %$CPAN::Config};
         $CPAN::Config->{urllist} = $save;
         CPAN::Config->init;
       }'
    );

    $ENV{PERL_MM_USE_DEFAULT} = 1;

    # XXX - remove the force on EUMM once its test suite survive PERL_MM_OPT

    if ($eumm) { # non-zero exit
      $cpan_command .= 'force("install","ExtUtils::MakeMaker"); ';
    }
    if ($cpan) {
      $cpan_command .= 'force("install","CPAN"); ';
    }
    if(length $cpan_command) {
      system($^X, '-MCPAN', '-e', $cpan_command);
    }
    if ($cpan) {
      system($^X, '-MCPAN', '-e', 'CPAN::Config->load; CPAN::Config->commit;');
    }
  }
}

use inc::Module::Install;

name 'local-lib';
all_from 'lib/local/lib.pm';

requires 'ExtUtils::MakeMaker' => '6.31'; # version INSTALL_BASE was added
requires 'ExtUtils::CBuilder'; # this and ParseXS are needed for MB C_support
requires 'ExtUtils::ParseXS';
requires 'Module::Build' => '0.28'; # lib -> lib/perl5 change
requires 'CPAN' => '1.80'; # sudo support

# No, really. See
# https://rt.cpan.org/Public/Bug/Display.html?id=23735
# for why CPAN now sets the CPANPLUS env var.
# trouble is this means we can't auto_install(_now) CPAN itself
# without this beautiful hack

my $no_cpanplus_env = !exists $ENV{PERL5_CPANPLUS_IS_RUNNING};
require CPAN;
delete $ENV{PERL5_CPANPLUS_IS_RUNNING} if $no_cpanplus_env;

if ($bootstrapping) {
  auto_install_now;
} else {
  auto_install;
}

WriteAll;
