/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.CallableExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.serialize.codenorm.Normalizer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalizeUnicode
extends SystemFunction
implements CallableExpression {
    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        StringValue sv = (StringValue)this.argument[0].evaluateItem(c);
        if (sv == null) {
            return StringValue.EMPTY_STRING;
        }
        String form = this.argument.length == 1 ? "NFC" : Whitespace.trim(this.argument[1].evaluateAsString(c));
        return this.normalize(sv, form, c);
    }

    public SequenceIterator<? extends AtomicValue> call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
        StringValue sv = (StringValue)arguments[0].next();
        if (sv == null) {
            return SingletonIterator.makeIterator(StringValue.EMPTY_STRING);
        }
        String nf = arguments.length == 1 ? "NFC" : Whitespace.trim(arguments[1].next().getStringValue());
        StringValue result = this.normalize(sv, nf, context);
        return Value.asIterator(result);
    }

    public StringValue normalize(StringValue sv, String form, XPathContext c) throws XPathException {
        byte fb = 2;
        if (this.argument.length == 2) {
            if (form.equalsIgnoreCase("NFC")) {
                fb = 2;
            } else if (form.equalsIgnoreCase("NFD")) {
                fb = 0;
            } else if (form.equalsIgnoreCase("NFKC")) {
                fb = 3;
            } else if (form.equalsIgnoreCase("NFKD")) {
                fb = 1;
            } else {
                if (form.length() == 0) {
                    return sv;
                }
                String msg = "Normalization form " + form + " is not supported";
                XPathException err = new XPathException(msg);
                err.setErrorCode("FOCH0003");
                err.setXPathContext(c);
                err.setLocator(this);
                throw err;
            }
        }
        boolean allASCII = true;
        CharSequence chars = sv.getStringValueCS();
        if (chars instanceof CompressedWhitespace) {
            return sv;
        }
        for (int i = chars.length() - 1; i >= 0; --i) {
            if (chars.charAt(i) <= '\u007f') continue;
            allASCII = false;
            break;
        }
        if (allASCII) {
            return sv;
        }
        Normalizer norm = new Normalizer(fb, c.getConfiguration());
        CharSequence result = norm.normalize(sv.getStringValueCS());
        return StringValue.makeStringValue(result);
    }
}

