/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Negatable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;

public class NotFn
extends SystemFunction
implements Negatable {
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        XPathException err = TypeChecker.ebvError(this.argument[0], visitor.getConfiguration().getTypeHierarchy());
        if (err != null) {
            err.setLocator(this);
            throw err;
        }
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        this.argument[0] = ExpressionTool.unsortedIfHomogeneous(opt, this.argument[0]);
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e == this) {
            Expression ebv = BooleanFn.rewriteEffectiveBooleanValue(this.argument[0], visitor, contextItemType);
            if (ebv != null) {
                this.argument[0] = ebv;
            }
            if (this.argument[0] instanceof Negatable && ((Negatable)((Object)this.argument[0])).isNegatable(visitor)) {
                return ((Negatable)((Object)this.argument[0])).negate().optimize(visitor, contextItemType);
            }
            return this;
        }
        return e;
    }

    public boolean isNegatable(ExpressionVisitor visitor) {
        return true;
    }

    public Expression negate() {
        return SystemFunction.makeSystemFunction("boolean", this.getArguments());
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext c) throws XPathException {
        try {
            return !this.argument[0].effectiveBooleanValue(c);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(c);
            throw e;
        }
    }
}

