/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.HashSet;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class ImportedFunctionLibrary
implements FunctionLibrary,
XQueryFunctionBinder {
    private transient QueryModule importingModule;
    private XQueryFunctionLibrary baseLibrary;
    private HashSet namespaces = new HashSet(5);

    public ImportedFunctionLibrary(QueryModule importingModule, XQueryFunctionLibrary baseLibrary) {
        this.importingModule = importingModule;
        this.baseLibrary = baseLibrary;
    }

    public void addImportedNamespace(String namespace) {
        this.namespaces.add(namespace);
    }

    public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env, Container container) throws XPathException {
        String uri = functionName.getURI();
        if (this.namespaces.contains(uri)) {
            Expression call = this.baseLibrary.bind(functionName, staticArgs, env, container);
            if (call != null) {
                XQueryFunction def = this.baseLibrary.getDeclaration(functionName, staticArgs);
                this.importingModule.checkImportedFunctionSignature(def);
            }
            return call;
        }
        return null;
    }

    public XQueryFunction getDeclaration(StructuredQName functionName, Expression[] staticArgs) {
        String uri = functionName.getURI();
        if (this.namespaces.contains(uri)) {
            return this.baseLibrary.getDeclaration(functionName, staticArgs);
        }
        return null;
    }

    public FunctionLibrary copy() {
        ImportedFunctionLibrary lib = new ImportedFunctionLibrary(this.importingModule, this.baseLibrary);
        for (String ns : this.namespaces) {
            lib.addImportedNamespace(ns);
        }
        return lib;
    }

    public void setImportingModule(QueryModule importingModule) {
        this.importingModule = importingModule;
    }

    public SequenceType[] getFunctionSignature(StructuredQName functionName, int arity) {
        if (this.namespaces.contains(functionName.getURI())) {
            return this.baseLibrary.getFunctionSignature(functionName, arity);
        }
        return null;
    }
}

