#!/usr/bin/perl -w
#
#    uconverter.pl
#
#    $Id: uconverter.pl,v 1.2 2001/02/11 03:27:53 bstell Exp $
#
#    Copyright (c) 2000 Brian Stell
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License 
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

require 5.6.0;
use strict;

use POSIX qw(locale_h errno);
use utf8;

use ExtUtils::testlib;
use ICU;
use ICU::UConverter;

print "<pre>\n";

my $ja_utf8_str = '1971年3月1日 16時00分00秒GMT-08:00';
my $ja_sjis_str = '1971N31 160000bGMT-08:00';
my $ja_2022jp_str = '$BG/';

#show_conversion('ISO-8859-1', 'hello', 'hello');
#show_conversion('SJIS', $ja_utf8_str, $ja_sjis_str);

#show_conversion('ISO_2022,locale=jp', $ja_utf8_str, $ja_2022jp_str);
my $ja_utf8_str2 = '1971年 1971年 1971年 1971年 1971年';
my $ja_2022jp_str2 = '$BG/';
show_conversion('ISO_2022,locale=jp', $ja_utf8_str2, $ja_2022jp_str2);

sub show_conversion {
    my ($converter_str, $utf8_str, $locale_str) = @_;

    print "converter: ($converter_str)\n";
    my $ucnv = new ICU::UConverter($converter_str);
    my $locale_from_utf8 = $ucnv->ucnv_fromUChars($utf8_str);
    # did not fix things: $ucnv->reset();
    # did not fix things: my $tmp_str = $ucnv->ucnv_fromUChars("\n");
    $ucnv = new ICU::UConverter($converter_str);
    my $locale2_from_utf8 = $ucnv->ucnv_fromUChars($utf8_str);
    my $locale3_from_utf8 = $ucnv->ucnv_fromUChars($utf8_str);
    my $utf8_from_locale = $ucnv->ucnv_toUChars($locale_str);

    print "    utf8_str         = ($utf8_str)\n";
    print "    locale_str       = ($locale_str)\n";
    print "    locale_from_utf8 = ($locale_from_utf8)\n";
    print "    locale2_from_utf8 = ($locale2_from_utf8)\n";
    print "    locale3_from_utf8 = ($locale3_from_utf8)\n";
    print "    utf8_from_locale = ($utf8_from_locale)\n";
}

print "</pre>\n";

#my $IS_TTY_OUT = -t STDOUT;
#print "IS_TTY_OUT = $IS_TTY_OUT\n";
# iso 2022 output to a xterm really screws up the xterm's display
# so don't output iso 2022 jp to a tty

exit(0);
