/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.planar;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.Function;
import org.maltparser.parser.AbstractParserFactory;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.algorithm.planar.PlanarAddressFunction;
import org.maltparser.parser.algorithm.planar.PlanarConfig;

public abstract class PlanarFactory
implements AbstractParserFactory {
    protected Algorithm algorithm;
    protected DependencyParserConfig manager;

    public PlanarFactory(Algorithm algorithm) {
        this.setAlgorithm(algorithm);
        this.setManager(algorithm.getManager());
    }

    public ParserConfiguration makeParserConfiguration() throws MaltChainedException {
        if (this.manager.getConfigLogger().isInfoEnabled()) {
            this.manager.getConfigLogger().info("  Parser configuration : Planar with no_covered_roots = " + this.manager.getOptionValue("planar", "no_covered_roots").toString().toUpperCase() + ", " + "acyclicity = " + this.manager.getOptionValue("planar", "acyclicity").toString().toUpperCase() + ", connectedness = " + this.manager.getOptionValue("planar", "connectedness").toString().toUpperCase() + "\n");
        }
        return new PlanarConfig(this.manager.getSymbolTables(), this.manager.getOptionValue("planar", "no_covered_roots").toString(), this.manager.getOptionValue("planar", "acyclicity").toString(), this.manager.getOptionValue("planar", "connectedness").toString());
    }

    public Function makeFunction(String subFunctionName) throws MaltChainedException {
        return new PlanarAddressFunction(subFunctionName, this.algorithm);
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public DependencyParserConfig getManager() {
        return this.manager;
    }

    public void setManager(DependencyParserConfig manager) {
        this.manager = manager;
    }
}

