#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::CurrencyCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. CurrencyCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::CurrencyCodeType

=head1 DESCRIPTION

Defines the standard 3-letter ISO 4217 currency code set.
However, only certain currency codes are currently valid for use on eBay.
The valid codes are documented below with the notation "(in/out)".
Other codes in this list are for future use.
The documentation below specifies English names for each currency.
Alternatively, use GeteBayDetails to retrieve the names programmatically.
A reference: http://www.xe.com/iso4217.htm



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 AFA

=cut


use constant AFA => scalar('AFA');


=head2 ALL

=cut


use constant ALL => scalar('ALL');


=head2 DZD

=cut


use constant DZD => scalar('DZD');


=head2 ADP

=cut


use constant ADP => scalar('ADP');


=head2 AOA

=cut


use constant AOA => scalar('AOA');


=head2 ARS

=cut


use constant ARS => scalar('ARS');


=head2 AMD

=cut


use constant AMD => scalar('AMD');


=head2 AWG

=cut


use constant AWG => scalar('AWG');


=head2 AZM

=cut


use constant AZM => scalar('AZM');


=head2 BSD

=cut


use constant BSD => scalar('BSD');


=head2 BHD

=cut


use constant BHD => scalar('BHD');


=head2 BDT

=cut


use constant BDT => scalar('BDT');


=head2 BBD

=cut


use constant BBD => scalar('BBD');


=head2 BYR

=cut


use constant BYR => scalar('BYR');


=head2 BZD

=cut


use constant BZD => scalar('BZD');


=head2 BMD

=cut


use constant BMD => scalar('BMD');


=head2 BTN

=cut


use constant BTN => scalar('BTN');


=head2 INR

Indian Rupee.
For eBay, you can only specify this currency for listings you submit to the
India site (site ID 203).



=cut


use constant INR => scalar('INR');


=head2 BOV

=cut


use constant BOV => scalar('BOV');


=head2 BOB

=cut


use constant BOB => scalar('BOB');


=head2 BAM

=cut


use constant BAM => scalar('BAM');


=head2 BWP

=cut


use constant BWP => scalar('BWP');


=head2 BRL

=cut


use constant BRL => scalar('BRL');


=head2 BND

=cut


use constant BND => scalar('BND');


=head2 BGL

=cut


use constant BGL => scalar('BGL');


=head2 BGN

=cut


use constant BGN => scalar('BGN');


=head2 BIF

=cut


use constant BIF => scalar('BIF');


=head2 KHR

=cut


use constant KHR => scalar('KHR');


=head2 CAD

Canadian Dollar.
For eBay, you can only specify this currency for listings you submit to the
Canada site (site ID 2)
(Items listed on the Canada site can also specify USD.)



=cut


use constant CAD => scalar('CAD');


=head2 CVE

=cut


use constant CVE => scalar('CVE');


=head2 KYD

=cut


use constant KYD => scalar('KYD');


=head2 XAF

=cut


use constant XAF => scalar('XAF');


=head2 CLF

=cut


use constant CLF => scalar('CLF');


=head2 CLP

=cut


use constant CLP => scalar('CLP');


=head2 CNY

=cut


use constant CNY => scalar('CNY');


=head2 COP

=cut


use constant COP => scalar('COP');


=head2 KMF

=cut


use constant KMF => scalar('KMF');


=head2 CDF

=cut


use constant CDF => scalar('CDF');


=head2 CRC

=cut


use constant CRC => scalar('CRC');


=head2 HRK

=cut


use constant HRK => scalar('HRK');


=head2 CUP

=cut


use constant CUP => scalar('CUP');


=head2 CYP

=cut


use constant CYP => scalar('CYP');


=head2 CZK

=cut


use constant CZK => scalar('CZK');


=head2 DKK

=cut


use constant DKK => scalar('DKK');


=head2 DJF

=cut


use constant DJF => scalar('DJF');


=head2 DOP

=cut


use constant DOP => scalar('DOP');


=head2 TPE

=cut


use constant TPE => scalar('TPE');


=head2 ECV

=cut


use constant ECV => scalar('ECV');


=head2 ECS

=cut


use constant ECS => scalar('ECS');


=head2 EGP

=cut


use constant EGP => scalar('EGP');


=head2 SVC

=cut


use constant SVC => scalar('SVC');


=head2 ERN

=cut


use constant ERN => scalar('ERN');


=head2 EEK

=cut


use constant EEK => scalar('EEK');


=head2 ETB

=cut


use constant ETB => scalar('ETB');


=head2 FKP

=cut


use constant FKP => scalar('FKP');


=head2 FJD

=cut


use constant FJD => scalar('FJD');


=head2 GMD

=cut


use constant GMD => scalar('GMD');


=head2 GEL

=cut


use constant GEL => scalar('GEL');


=head2 GHC

=cut


use constant GHC => scalar('GHC');


=head2 GIP

=cut


use constant GIP => scalar('GIP');


=head2 GTQ

=cut


use constant GTQ => scalar('GTQ');


=head2 GNF

=cut


use constant GNF => scalar('GNF');


=head2 GWP

=cut


use constant GWP => scalar('GWP');


=head2 GYD

=cut


use constant GYD => scalar('GYD');


=head2 HTG

=cut


use constant HTG => scalar('HTG');


=head2 HNL

=cut


use constant HNL => scalar('HNL');


=head2 HKD

Hong Kong Dollar.
For eBay, you can only specify this currency for listings you submit to the
Hong Kong site (site ID 201).



=cut


use constant HKD => scalar('HKD');


=head2 HUF

=cut


use constant HUF => scalar('HUF');


=head2 ISK

=cut


use constant ISK => scalar('ISK');


=head2 IDR

=cut


use constant IDR => scalar('IDR');


=head2 IRR

=cut


use constant IRR => scalar('IRR');


=head2 IQD

=cut


use constant IQD => scalar('IQD');


=head2 ILS

=cut


use constant ILS => scalar('ILS');


=head2 JMD

=cut


use constant JMD => scalar('JMD');


=head2 JPY

=cut


use constant JPY => scalar('JPY');


=head2 JOD

=cut


use constant JOD => scalar('JOD');


=head2 KZT

=cut


use constant KZT => scalar('KZT');


=head2 KES

=cut


use constant KES => scalar('KES');


=head2 AUD

Australian Dollar.
For eBay, you can only specify this currency for listings you submit to the
Australia site (site ID 15).



=cut


use constant AUD => scalar('AUD');


=head2 KPW

=cut


use constant KPW => scalar('KPW');


=head2 KRW

=cut


use constant KRW => scalar('KRW');


=head2 KWD

=cut


use constant KWD => scalar('KWD');


=head2 KGS

=cut


use constant KGS => scalar('KGS');


=head2 LAK

=cut


use constant LAK => scalar('LAK');


=head2 LVL

=cut


use constant LVL => scalar('LVL');


=head2 LBP

=cut


use constant LBP => scalar('LBP');


=head2 LSL

=cut


use constant LSL => scalar('LSL');


=head2 LRD

=cut


use constant LRD => scalar('LRD');


=head2 LYD

=cut


use constant LYD => scalar('LYD');


=head2 CHF

Swiss Franc.
For eBay, you can only specify this currency for listings you submit to the
Switzerland site (site ID 193).



=cut


use constant CHF => scalar('CHF');


=head2 LTL

=cut


use constant LTL => scalar('LTL');


=head2 MOP

=cut


use constant MOP => scalar('MOP');


=head2 MKD

=cut


use constant MKD => scalar('MKD');


=head2 MGF

=cut


use constant MGF => scalar('MGF');


=head2 MWK

=cut


use constant MWK => scalar('MWK');


=head2 MYR

Malaysian Ringgit.
For eBay, you can only specify this currency for listings you submit to the
Malaysia site (site ID 207).



=cut


use constant MYR => scalar('MYR');


=head2 MVR

=cut


use constant MVR => scalar('MVR');


=head2 MTL

=cut


use constant MTL => scalar('MTL');


=head2 EUR

Euro.
For eBay, you can only specify this currency for listings you submit to these sites:
Austria (site 16), Belgium_French (site 23),
France (site 71), Germany (site 77), Italy (site 101), Belgium_Dutch (site 123),
Netherlands (site 146), Spain (site 186), Ireland (site 205).



=cut


use constant EUR => scalar('EUR');


=head2 MRO

=cut


use constant MRO => scalar('MRO');


=head2 MUR

=cut


use constant MUR => scalar('MUR');


=head2 MXN

=cut


use constant MXN => scalar('MXN');


=head2 MXV

=cut


use constant MXV => scalar('MXV');


=head2 MDL

=cut


use constant MDL => scalar('MDL');


=head2 MNT

=cut


use constant MNT => scalar('MNT');


=head2 XCD

=cut


use constant XCD => scalar('XCD');


=head2 MZM

=cut


use constant MZM => scalar('MZM');


=head2 MMK

=cut


use constant MMK => scalar('MMK');


=head2 ZAR

=cut


use constant ZAR => scalar('ZAR');


=head2 NAD

=cut


use constant NAD => scalar('NAD');


=head2 NPR

=cut


use constant NPR => scalar('NPR');


=head2 ANG

=cut


use constant ANG => scalar('ANG');


=head2 XPF

=cut


use constant XPF => scalar('XPF');


=head2 NZD

=cut


use constant NZD => scalar('NZD');


=head2 NIO

=cut


use constant NIO => scalar('NIO');


=head2 NGN

=cut


use constant NGN => scalar('NGN');


=head2 NOK

=cut


use constant NOK => scalar('NOK');


=head2 OMR

=cut


use constant OMR => scalar('OMR');


=head2 PKR

=cut


use constant PKR => scalar('PKR');


=head2 PAB

=cut


use constant PAB => scalar('PAB');


=head2 PGK

=cut


use constant PGK => scalar('PGK');


=head2 PYG

=cut


use constant PYG => scalar('PYG');


=head2 PEN

=cut


use constant PEN => scalar('PEN');


=head2 PHP

Philippines Peso.
For eBay, you can only specify this currency for listings you submit to the
Philippines site (site ID 211).



=cut


use constant PHP => scalar('PHP');


=head2 PLN

Poland, Zloty.
For eBay, you can only specify this currency for listings you submit to the
Poland site (site ID 212).



=cut


use constant PLN => scalar('PLN');


=head2 USD

US Dollar.
For eBay, you can only specify this currency for listings you submit to the
US (site ID 0), eBayMotors (site 100), and Canada (site 2) sites.



=cut


use constant USD => scalar('USD');


=head2 QAR

=cut


use constant QAR => scalar('QAR');


=head2 ROL

=cut


use constant ROL => scalar('ROL');


=head2 RUB

=cut


use constant RUB => scalar('RUB');


=head2 RUR

=cut


use constant RUR => scalar('RUR');


=head2 RWF

=cut


use constant RWF => scalar('RWF');


=head2 SHP

=cut


use constant SHP => scalar('SHP');


=head2 WST

=cut


use constant WST => scalar('WST');


=head2 STD

=cut


use constant STD => scalar('STD');


=head2 SAR

=cut


use constant SAR => scalar('SAR');


=head2 SCR

=cut


use constant SCR => scalar('SCR');


=head2 SLL

=cut


use constant SLL => scalar('SLL');


=head2 SGD

Singapore Dollar.
For eBay, you can only specify this currency for listings you submit to the
Singapore site (site 216).



=cut


use constant SGD => scalar('SGD');


=head2 SKK

=cut


use constant SKK => scalar('SKK');


=head2 SIT

=cut


use constant SIT => scalar('SIT');


=head2 SBD

=cut


use constant SBD => scalar('SBD');


=head2 SOS

=cut


use constant SOS => scalar('SOS');


=head2 LKR

=cut


use constant LKR => scalar('LKR');


=head2 SDD

=cut


use constant SDD => scalar('SDD');


=head2 SRG

=cut


use constant SRG => scalar('SRG');


=head2 SZL

=cut


use constant SZL => scalar('SZL');


=head2 SEK

Swedish Krona.
For eBay, you can only specify this currency for listings you submit to the
Sweden site (site 218).



=cut


use constant SEK => scalar('SEK');


=head2 SYP

=cut


use constant SYP => scalar('SYP');


=head2 TWD

New Taiwan Dollar. Note that there is no longer an eBay Taiwan site.



=cut


use constant TWD => scalar('TWD');


=head2 TJS

=cut


use constant TJS => scalar('TJS');


=head2 TZS

=cut


use constant TZS => scalar('TZS');


=head2 THB

=cut


use constant THB => scalar('THB');


=head2 XOF

=cut


use constant XOF => scalar('XOF');


=head2 TOP

=cut


use constant TOP => scalar('TOP');


=head2 TTD

=cut


use constant TTD => scalar('TTD');


=head2 TND

=cut


use constant TND => scalar('TND');


=head2 TRL

=cut


use constant TRL => scalar('TRL');


=head2 TMM

=cut


use constant TMM => scalar('TMM');


=head2 UGX

=cut


use constant UGX => scalar('UGX');


=head2 UAH

=cut


use constant UAH => scalar('UAH');


=head2 AED

=cut


use constant AED => scalar('AED');


=head2 GBP

Pound Sterling.
For eBay, you can only specify this currency for listings you submit to the
UK site (site ID 3).



=cut


use constant GBP => scalar('GBP');


=head2 USS

=cut


use constant USS => scalar('USS');


=head2 USN

=cut


use constant USN => scalar('USN');


=head2 UYU

=cut


use constant UYU => scalar('UYU');


=head2 UZS

=cut


use constant UZS => scalar('UZS');


=head2 VUV

=cut


use constant VUV => scalar('VUV');


=head2 VEB

=cut


use constant VEB => scalar('VEB');


=head2 VND

=cut


use constant VND => scalar('VND');


=head2 MAD

=cut


use constant MAD => scalar('MAD');


=head2 YER

=cut


use constant YER => scalar('YER');


=head2 YUM

=cut


use constant YUM => scalar('YUM');


=head2 ZMK

=cut


use constant ZMK => scalar('ZMK');


=head2 ZWD

=cut


use constant ZWD => scalar('ZWD');


=head2 ATS

=cut


use constant ATS => scalar('ATS');


=head2 CustomCode

Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
