# Generated by default/object.tt
package Paws::LookoutMetrics::SNSConfiguration;
  use Moose;
  has RoleArn => (is => 'ro', isa => 'Str', required => 1);
  has SnsTopicArn => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutMetrics::SNSConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutMetrics::SNSConfiguration object:

  $service_obj->Method(Att1 => { RoleArn => $value, ..., SnsTopicArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutMetrics::SNSConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->RoleArn

=head1 DESCRIPTION

Contains information about the SNS topic to which you want to send your
alerts and the IAM role that has access to that topic.

=head1 ATTRIBUTES


=head2 B<REQUIRED> RoleArn => Str

The ARN of the IAM role that has access to the target SNS topic.


=head2 B<REQUIRED> SnsTopicArn => Str

The ARN of the target SNS topic.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutMetrics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

