# Generated by default/object.tt
package Paws::MediaTailor::ScheduleAdBreak;
  use Moose;
  has ApproximateDurationSeconds => (is => 'ro', isa => 'Int');
  has ApproximateStartTime => (is => 'ro', isa => 'Str');
  has SourceLocationName => (is => 'ro', isa => 'Str');
  has VodSourceName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaTailor::ScheduleAdBreak

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaTailor::ScheduleAdBreak object:

  $service_obj->Method(Att1 => { ApproximateDurationSeconds => $value, ..., VodSourceName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaTailor::ScheduleAdBreak object:

  $result = $service_obj->Method(...);
  $result->Att1->ApproximateDurationSeconds

=head1 DESCRIPTION

The schedule's ad break properties.

=head1 ATTRIBUTES


=head2 ApproximateDurationSeconds => Int

The approximate duration of the ad break, in seconds.


=head2 ApproximateStartTime => Str

The approximate time that the ad will start playing.


=head2 SourceLocationName => Str

The name of the source location containing the VOD source used for the
ad break.


=head2 VodSourceName => Str

The name of the VOD source used for the ad break.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaTailor>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

