/*    Locale.xs
 *
 *    $Id: Locale.xs,v 1.6 2001/08/07 02:56:39 mrperl Exp $
 *
 *    Copyright (c) 2000 Brian Stell
 *
 *    This package is free software and is provided ``as is'' without
 *    express or implied warranty. It may be used, redistributed and/or
 *    modified under the terms of the Perl Artistic License
 *    (see http://www.perl.com/perl/misc/Artistic.html)
 *
 */

extern "C" {
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
}

#include  "unicode/locid.h"
#include  "picu/picu_debug.h"
#include  "picu/picu_utf8.h"
#include  "picu/picu_util.h"
#include  "picu/Locale.h"

char *Locale_class_string = "ICU::Locale";
static int debugLevel = 0;

// See Locale.h for an explanation of why we need
// a class here

const Locale *
Picu_Locale::getIcuLocale()
{
    return(mIcuLocale);
}

int
Picu_Locale::getIsLocallyAllocated()
{
    return(mIsLocallyAllocated);
}

Picu_Locale::Picu_Locale(const Locale *aIcuLocale, int aLocallyAllocated)
{
    mIcuLocale = aIcuLocale;
    mIsLocallyAllocated = aLocallyAllocated;
}

Picu_Locale::~Picu_Locale()
{
    if (mIsLocallyAllocated) {
        DEBUG100("locally allocated");
        delete mIcuLocale;
    }
    else {
        DEBUG100("not locally allocated");
    }
}


MODULE = ICU::Locale    PACKAGE = ICU::Locale    PREFIX = Picu_

# This requires xsubpp version 1.925 or greater
REQUIRE: 1.925

void
Picu_Locale::DESTROY()
    CODE:
        DEBUG100("Picu_Locale::DESTROY()");
        delete THIS;
        DEBUG100("Picu_Locale::DESTROY()");

void
getAvailableLocales(CLASS)
        char *CLASS; 
    PREINIT:
        int i;  
        int32_t count;
        const Locale *locales;
    PPCODE: 
        locales = Locale::getAvailableLocales(count);
    EXTEND(SP, count); 
        for (i=0; i<count; i++) {
            SV *sv = sv_newmortal();
            Picu_Locale *ppL = new Picu_Locale(&locales[i], 0);
            sv_setref_pv(sv, CLASS, (void *)ppL);
            PUSHs(sv);
        }

const char *
Picu_Locale::getCountry()
    CODE:
        RETVAL = THIS->getIcuLocale()->getCountry();
    OUTPUT:
        RETVAL

Picu_Locale *
getDefault(CLASS)
        char *CLASS;
    CODE:
        RETVAL = new Picu_Locale(&Locale::getDefault(), 0);
    OUTPUT:
        RETVAL

const char *
Picu_Locale::getDisplayCountry(inLocale=0)
        Picu_Locale *inLocale;
    PREINIT:
        UnicodeString dispCntry;
        U8 *u8str;
        uint32_t u8len;
    CODE:
        if (items == 2) {
            if (!IS_LOCALE_OBJECT(ST(1))) {
                Perl_croak("var is *NOT* type %s", Locale_class_string);
            }
            THIS->getIcuLocale()->getDisplayCountry(*inLocale->getIcuLocale(), dispCntry);
        }
        else {
            THIS->getIcuLocale()->getDisplayCountry(dispCntry);
        }
        u8str = UnicodeStringToU8String(dispCntry, &u8len);
        ST(0) = sv_newmortal();
        sv_usepvn(ST(0), (char*)u8str, u8len);
    OUTPUT:

const char *
Picu_Locale::getDisplayLanguage(inLocale=0)
        Picu_Locale *inLocale;
    PREINIT:
        UnicodeString dispLang;
        U8 *u8str;
        uint32_t u8len;
    CODE:
        if (items == 2) {
            if (!IS_LOCALE_OBJECT(ST(1))) {
                Perl_croak("var is *NOT* type %s", Locale_class_string);
            }
            THIS->getIcuLocale()->getDisplayLanguage(*inLocale->getIcuLocale(), dispLang);
        }
        else {
            THIS->getIcuLocale()->getDisplayLanguage(dispLang);
        }
        u8str = UnicodeStringToU8String(dispLang, &u8len);
        ST(0) = sv_newmortal();
        sv_usepvn(ST(0), (char*)u8str, u8len);
    OUTPUT:

const char *
Picu_Locale::getDisplayName(inLocale=0)
        Picu_Locale *inLocale;
    PREINIT:
        UnicodeString dispName;
        U8 *u8str;
        uint32_t u8len;
    CODE:
        if (items == 2) {
            if (!IS_LOCALE_OBJECT(ST(1))) {
                Perl_croak("var is *NOT* type %s", Locale_class_string);
            }
            THIS->getIcuLocale()->getDisplayName(*inLocale->getIcuLocale(), dispName);
        }
        else {
            THIS->getIcuLocale()->getDisplayName(dispName);
        }
        u8str = UnicodeStringToU8String(dispName, &u8len);
        ST(0) = sv_newmortal();
        sv_usepvn(ST(0), (char*)u8str, u8len);
    OUTPUT:

const char *
Picu_Locale::getDisplayVariant(inLocale=0)
        Picu_Locale *inLocale;
    PREINIT:
        UnicodeString dispVariant;
        U8 *u8str;
        uint32_t u8len;
    CODE:
        if (items == 2) {
            if (!IS_LOCALE_OBJECT(ST(1))) {
                Perl_croak("var is *NOT* type %s", Locale_class_string);
            }
            THIS->getIcuLocale()->getDisplayVariant(*inLocale->getIcuLocale(), dispVariant);
        }
        else {
            THIS->getIcuLocale()->getDisplayVariant(dispVariant);
        }
        u8str = UnicodeStringToU8String(dispVariant, &u8len);
        ST(0) = sv_newmortal();
        sv_usepvn(ST(0), (char*)u8str, u8len);
    OUTPUT:

void
getISOLanguages(CLASS)
    char *CLASS; 
    PREINIT:
    int i;  
    int32_t count = 0;
    const char* const* languages;
    const char* const* p;
    PPCODE: 
    languages = Locale::getISOLanguages();
    for (p=languages; *p; p++) {
        count++;
    }
    EXTEND(SP, count); 
    for (i=0; i<count; i++) {
        const char *ios_country = languages[i];
        PUSHs(sv_2mortal(newSVpvn(ios_country, strlen(ios_country))));
    }

void
getISOCountries(CLASS)
    char *CLASS; 
    PREINIT:
    int i;  
    int32_t count = 0;
    const char* const* countries;
    const char* const* p;
    PPCODE: 
    countries = Locale::getISOCountries();
    for (p=countries; *p; p++) {
        count++;
    }
    EXTEND(SP, count); 
    for (i=0; i<count; i++) {
        const char *ios_country = countries[i];
        PUSHs(sv_2mortal(newSVpvn(ios_country, strlen(ios_country))));
    }

const char *
Picu_Locale::getLanguage()
    CODE:
        RETVAL = THIS->getIcuLocale()->getLanguage();
    OUTPUT:
        RETVAL

unsigned int
Picu_Locale::getLCID()
    CODE:
        RETVAL = THIS->getIcuLocale()->getLCID();
    OUTPUT:
        RETVAL

const char *
Picu_Locale::getName()
    CODE:
        RETVAL = THIS->getIcuLocale()->getName();
    OUTPUT:
        RETVAL

const char *
Picu_Locale::getVariant()
    CODE:
        RETVAL = THIS->getIcuLocale()->getVariant();
    OUTPUT:
        RETVAL

int
Picu_Locale::hashCode()
    CODE:
        RETVAL = THIS->getIcuLocale()->hashCode();
    OUTPUT:
        RETVAL

Picu_Locale *
Picu_Locale::new(...)
    PREINIT:
        char *language = 0;
        char *country  = 0;
        char *variant  = 0;
        Picu_Locale *other_locale = 0;
    CODE:
        // we go to alot of work here to
        // distinguish between a locale object and a language string
        if (items < 1 || items > 4)
            Perl_croak(aTHX_ "Usage: new ICU::Locale(language=0, country=0, variant=0)\n   or: new ICU::Locale(otherLocale)");

        if (items >= 2) {
            if (sv_isobject(ST(1))) {
                if (!IS_LOCALE_OBJECT(ST(1))) {
                    Perl_croak("var is *NOT* type %s", Locale_class_string);
                }
                /* other_locale = (Picu_Locale *)SvIV((SV*)SvRV( ST(1) )); */
                other_locale = (Picu_Locale *)SvIV(SvRV( ST(1) ));
            }
            else {
                language = (char *)SvPV_nolen(ST(1));
            }
        }
        if (items >= 3) {
            country = (char *)SvPV_nolen(ST(2));
        }
        if (items == 4) {
            variant = (char *)SvPV_nolen(ST(3));
        }
        if (other_locale) {
            RETVAL = new Picu_Locale(new Locale(*other_locale->getIcuLocale()), 1);
        }
        else {
            RETVAL = new Picu_Locale(new Locale(language, country, variant), 1);
        }
    OUTPUT:
        RETVAL

int
setDebugLevel(...)
    CODE:
        RETVAL = debugLevel; // return old value
        if (items > 1) {
            Perl_croak(aTHX_ "Usage: ICU::DateFormat::setDebugLevel([new_debug_level])");
        }
        else if (items == 1) {
            debugLevel = SvIV(ST(0));
        }
        DEBUG100("debugLevel = %d", debugLevel);
    OUTPUT:
        RETVAL

void
setDefault(CLASS, newLocale, ...)
        char *CLASS;
        Picu_Locale * newLocale;
    PREINIT:
        UErrorCode status = U_ZERO_ERROR;
        SV *sv_status = NULL;
    CODE:
        if (items > 3) {
            Perl_croak(aTHX_
                  "Usage: ICU::setDefault(locale [, \\$status])");
        }

        if (items == 3) {
            if (!SVIsIntRef(ST(2))) {
                Perl_croak(aTHX_ "ICU::DateFormat::parse: param 2 must "
                                 "be an integer reference");
            }
            sv_status = SvRV(ST(2));
            status = (UErrorCode)SvIV(sv_status);
            if (U_FAILURE(status)) {
                XSRETURN_UNDEF;
            }
        }
        Locale::setDefault(*newLocale->getIcuLocale(), status);
        if (sv_status) {
            sv_setiv(sv_status, (IV)status);
        }
    OUTPUT:



