use strict;
use warnings;
use Test::More;
use Path::Tiny;

plan skip_all => "Test::Portability::Files required for testing filenames portability"
    unless eval "use Test::Portability::Files; 1";

#options(all_tests => 1); # to be hyper-strict
options(
    #test_mac_length       => 1,
    test_space            => 1,
    test_symlink          => 1,
    test_special_chars    => 1,
    test_windows_reserved => 1,
    test_case             => 1,
);
my $manifestfile;
BEGIN{
    # prepare, because we want to check only *.t an *.pm and *.pl files
    use File::Find;
    my $module_base_dir = path(__FILE__)->parent->parent;

    my $lib_dir = $module_base_dir->child("lib");
    my $t_dir = $module_base_dir->child("t");
    $manifestfile = $module_base_dir->child("MANIFEST")->absolute();
    if ($manifestfile->is_file) {
        $manifestfile->remove();
    }

    sub wanted {
        m/.*\.(p[ml]|t)$/ &&
            -f _ &&
            $manifestfile->append($File::Find::name) &&
            $manifestfile->append("\n");
    }
    find(\&wanted, $lib_dir->stringify, $t_dir->stringify);

}
# tests
run_tests();

#clean up
if ($manifestfile->is_file) {
    $manifestfile->remove();

}
1;