# Generated by default/object.tt
package Paws::GameLift::EC2InstanceCounts;
  use Moose;
  has ACTIVE => (is => 'ro', isa => 'Int');
  has DESIRED => (is => 'ro', isa => 'Int');
  has IDLE => (is => 'ro', isa => 'Int');
  has MAXIMUM => (is => 'ro', isa => 'Int');
  has MINIMUM => (is => 'ro', isa => 'Int');
  has PENDING => (is => 'ro', isa => 'Int');
  has TERMINATING => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GameLift::EC2InstanceCounts

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GameLift::EC2InstanceCounts object:

  $service_obj->Method(Att1 => { ACTIVE => $value, ..., TERMINATING => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GameLift::EC2InstanceCounts object:

  $result = $service_obj->Method(...);
  $result->Att1->ACTIVE

=head1 DESCRIPTION

Resource capacity settings. Fleet capacity is measured in EC2
instances. Pending and terminating counts are non-zero when the fleet
capacity is adjusting to a scaling event or if access to resources is
temporarily affected.

EC2 instance counts are part of FleetCapacity.

=head1 ATTRIBUTES


=head2 ACTIVE => Int

Actual number of instances that are ready to host game sessions.


=head2 DESIRED => Int

Ideal number of active instances. GameLift will always try to maintain
the desired number of instances. Capacity is scaled up or down by
changing the desired instances.


=head2 IDLE => Int

Number of active instances that are not currently hosting a game
session.


=head2 MAXIMUM => Int

The maximum instance count value allowed.


=head2 MINIMUM => Int

The minimum instance count value allowed.


=head2 PENDING => Int

Number of instances that are starting but not yet active.


=head2 TERMINATING => Int

Number of instances that are no longer active but haven't yet been
terminated.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GameLift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

