# Generated by default/object.tt
package Paws::SecurityHub::AwsApiGatewayRestApiDetails;
  use Moose;
  has ApiKeySource => (is => 'ro', isa => 'Str');
  has BinaryMediaTypes => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has CreatedDate => (is => 'ro', isa => 'Str');
  has Description => (is => 'ro', isa => 'Str');
  has EndpointConfiguration => (is => 'ro', isa => 'Paws::SecurityHub::AwsApiGatewayEndpointConfiguration');
  has Id => (is => 'ro', isa => 'Str');
  has MinimumCompressionSize => (is => 'ro', isa => 'Int');
  has Name => (is => 'ro', isa => 'Str');
  has Version => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsApiGatewayRestApiDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsApiGatewayRestApiDetails object:

  $service_obj->Method(Att1 => { ApiKeySource => $value, ..., Version => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsApiGatewayRestApiDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->ApiKeySource

=head1 DESCRIPTION

Contains information about a REST API in version 1 of Amazon API
Gateway.

=head1 ATTRIBUTES


=head2 ApiKeySource => Str

The source of the API key for metering requests according to a usage
plan.

C<HEADER> indicates whether to read the API key from the X-API-Key
header of a request.

C<AUTHORIZER> indicates whether to read the API key from the
C<UsageIdentifierKey> from a custom authorizer.


=head2 BinaryMediaTypes => ArrayRef[Str|Undef]

The list of binary media types supported by the REST API.


=head2 CreatedDate => Str

Indicates when the API was created.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 Description => Str

A description of the REST API.


=head2 EndpointConfiguration => L<Paws::SecurityHub::AwsApiGatewayEndpointConfiguration>

The endpoint configuration of the REST API.


=head2 Id => Str

The identifier of the REST API.


=head2 MinimumCompressionSize => Int

The minimum size in bytes of a payload before compression is enabled.

If C<null>, then compression is disabled.

If 0, then all payloads are compressed.


=head2 Name => Str

The name of the REST API.


=head2 Version => Str

The version identifier for the REST API.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

