# DO NOT EDIT, PRETTY PLEASE!
# This file is automatically generated by wl-scanner.pl
#

use strict;
use warnings;
use utf8;

=encoding utf8
=cut

=head1 NAME

WL::workspaces - Perl binding for workspaces protocol

=head1 SYNOPSIS

  use WL::workspaces;

=head1 DESCRIPTION

B<WL::workspaces> is a package generated from Wayland protocol definition
using L<wl-scanner.pl>. It implements L<WL::Base> subclasses with wrappers
for requests, event processing and constants for enums.

It is not indended to be used directly. Instead, see L<WL::Connection> to see
how to obtain the object instances.

To see how to attach event callbacks and issue requests, please refer to
L<WL::Base> base class.

Until proper documentation is finished, please refer to documentation of C
bindings of the generated code (it is intended to be readable) to see what
arguments to give to requests and expect from events.

Please consider this an alpha quality code, whose API can change at any time,
until we reach version 1.0.

=cut

package WL::workspaces;

our $VERSION = 0.92;

package WL::workspace_manager;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'workspace_manager';

# Requests
use constant REQUEST_MOVE_SURFACE => 0;

sub move_surface
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_MOVE_SURFACE, pack ('L L',
		shift->{id},
		shift), $file);

	return $retval;
}

# Events
use constant EVENT_STATE => 0;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_STATE) {
		@_ = unpack ('L L', shift);
		return $self->state (shift,
			shift);
	} else {
		die 'Bad opcode';
	}
}


=head1 BUGS

The interface documentation for the bindings is lacking.

Only client part implemented, not server.

=head1 SEE ALSO

=over

=item *

L<http://wayland.freedesktop.org/> -- Wayland project web site

=item *

L<wl-draw.pl> -- Example Wayland client

=item *

L<wl-scanner.pl> -- Tool that generated this module

=item *

L<WL::Base> -- Base class for Wayland objects

=item *

L<WL::Connection> -- Estabilish a Wayland connection

=back

=head1 COPYRIGHT

Copyright 2013, 2014 Lubomir Rintel

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 AUTHORS

Lubomir Rintel C<lkundrak@v3.sk>

=cut

